/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer;

import com.tagtraum.perf.gcviewer.ChartPanelView;
import com.tagtraum.perf.gcviewer.GCViewer;
import com.tagtraum.perf.gcviewer.ModelChart;
import com.tagtraum.perf.gcviewer.ModelChartImpl;
import com.tagtraum.perf.gcviewer.ModelPanel;
import com.tagtraum.perf.gcviewer.RefreshWatchDog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GCDocument
extends JInternalFrame {
    private List chartPanelViews = new ArrayList();
    private ModelChart modelChart;
    private boolean showModelPanel = true;
    private boolean watched;
    private RefreshWatchDog refreshWatchDog = new RefreshWatchDog();

    public GCDocument(final GCViewer gcViewer, String s) {
        super(s, true, true, true, false);
        this.refreshWatchDog.setGcDocument(this);
        this.modelChart = new MultiModelChartFacade();
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        this.getContentPane().setDropTarget(new DropTarget(this, 1, new DropTargetListener(){

            public void dragEnter(DropTargetDragEvent e) {
                if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    e.acceptDrag(1);
                } else {
                    e.rejectDrag();
                }
            }

            public void dragOver(DropTargetDragEvent dtde) {
            }

            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            public void dragExit(DropTargetEvent dte) {
            }

            public void drop(DropTargetDropEvent e) {
                try {
                    Transferable tr = e.getTransferable();
                    if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        e.acceptDrop(1);
                        List list = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                        File[] files = list.toArray(new File[list.size()]);
                        gcViewer.add(files);
                        GCDocument.this.getContentPane().invalidate();
                        e.dropComplete(true);
                    } else {
                        e.rejectDrop();
                    }
                }
                catch (IOException ioe) {
                    e.rejectDrop();
                    ioe.printStackTrace();
                }
                catch (UnsupportedFlavorException ufe) {
                    e.rejectDrop();
                    ufe.printStackTrace();
                }
            }
        }));
    }

    public RefreshWatchDog getRefreshWatchDog() {
        return this.refreshWatchDog;
    }

    public boolean isShowModelPanel() {
        return this.showModelPanel;
    }

    public void setShowModelPanel(boolean showModelPanel) {
        boolean mustRelayout = this.showModelPanel != showModelPanel;
        this.showModelPanel = showModelPanel;
        if (mustRelayout) {
            this.relayout();
        }
    }

    public boolean reloadModels(boolean background) throws IOException {
        boolean reloaded = false;
        for (int i = 0; i < this.chartPanelViews.size(); ++i) {
            reloaded |= ((ChartPanelView)this.chartPanelViews.get(i)).reloadModel();
        }
        if (!background) {
            this.relayout();
        }
        return reloaded;
    }

    public ModelChart getModelChart() {
        return this.modelChart;
    }

    public void add(URL url) throws IOException {
        ChartPanelView chartPanelView = new ChartPanelView(this, url);
        this.chartPanelViews.add(chartPanelView);
        chartPanelView.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("minimized".equals(event.getPropertyName())) {
                    GCDocument.this.relayout();
                }
            }
        });
        if (this.chartPanelViews.size() > 1) {
            this.modelChart.setScaleFactor(this.modelChart.getScaleFactor());
            this.modelChart.setShowFullGCLines(this.modelChart.isShowFullGCLines());
            this.modelChart.setShowGCTimesLine(this.modelChart.isShowGCTimesLine());
            this.modelChart.setShowGCTimesRectangles(this.modelChart.isShowGCTimesRectangles());
            this.modelChart.setShowIncGCLines(this.modelChart.isShowIncGCLines());
            this.modelChart.setShowTotalMemoryLine(this.modelChart.isShowTotalMemoryLine());
            this.modelChart.setShowUsedMemoryLine(this.modelChart.isShowUsedMemoryLine());
        }
        this.relayout();
    }

    public void removeChartPanelView(ChartPanelView chartPanelView) {
        this.chartPanelViews.remove(chartPanelView);
        this.relayout();
    }

    public void relayout() {
        this.getContentPane().removeAll();
        if (this.chartPanelViews.size() > 1) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.chartPanelViews.size(); ++i) {
                sb.append(((ChartPanelView)this.chartPanelViews.get(i)).getModel().getURL().getFile());
                if (i + 1 >= this.chartPanelViews.size()) continue;
                sb.append(", ");
            }
            this.setTitle(sb.toString());
        } else if (!this.chartPanelViews.isEmpty()) {
            this.setTitle(((ChartPanelView)this.chartPanelViews.get(0)).getModel().getURL().toString());
        } else {
            this.setTitle("");
        }
        int row = 0;
        boolean noMaximizedChartPanelView = true;
        ChartPanelView lastMaximizedChartPanelView = this.getLastMaximizedChartPanelView();
        MasterViewPortChangeListener masterViewPortChangeListener = new MasterViewPortChangeListener();
        for (int i = 0; i < this.chartPanelViews.size(); ++i) {
            ChartPanelView chartPanelView = (ChartPanelView)this.chartPanelViews.get(i);
            ModelChartImpl modelChart = (ModelChartImpl)chartPanelView.getModelChart();
            ModelPanel modelPanel = chartPanelView.getModelPanel();
            modelChart.invalidate();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.anchor = 11;
            constraints.gridy = row;
            if (this.chartPanelViews.size() > 1 || chartPanelView.isMinimized() && this.chartPanelViews.size() == 1) {
                constraints.gridwidth = 2;
                constraints.weightx = 2.0;
                this.getContentPane().add((Component)chartPanelView.getViewBar(), constraints);
            }
            constraints.fill = 1;
            constraints.gridy = ++row;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.gridx = 0;
            constraints.weightx = 2.0;
            constraints.weighty = 2.0;
            modelChart.setPreferredSize(new Dimension(800, 600));
            modelChart.setVisible(!chartPanelView.isMinimized());
            this.getContentPane().add((Component)modelChart, constraints);
            constraints.gridy = row;
            constraints.gridheight = 1;
            constraints.gridx = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 15;
            this.getContentPane().add((Component)modelPanel, constraints);
            modelPanel.setVisible(this.showModelPanel && !chartPanelView.isMinimized());
            if (!chartPanelView.isMinimized()) {
                noMaximizedChartPanelView = false;
                boolean isLastMaximizedChartPanelView = lastMaximizedChartPanelView == chartPanelView;
                JViewport viewport = modelChart.getViewport();
                this.lockChartsToOneScrollbar(viewport, isLastMaximizedChartPanelView, modelChart, masterViewPortChangeListener);
                JScrollBar horizontalScrollBar = modelChart.getHorizontalScrollBar();
                ChangeListener[] changeListeners = ((DefaultBoundedRangeModel)horizontalScrollBar.getModel()).getChangeListeners();
                for (int j = 0; j < changeListeners.length; ++j) {
                    if (!(changeListeners[j] instanceof ScrollBarMaximumChangeListener)) continue;
                    horizontalScrollBar.getModel().removeChangeListener(changeListeners[j]);
                }
                if (isLastMaximizedChartPanelView && this.isWatched()) {
                    horizontalScrollBar.getModel().addChangeListener(new ScrollBarMaximumChangeListener());
                }
                if (isLastMaximizedChartPanelView) {
                    horizontalScrollBar.setEnabled(!this.isWatched());
                }
            }
            ++row;
        }
        if (noMaximizedChartPanelView) {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 1;
            constraints.gridy = row;
            constraints.weightx = 3.0;
            constraints.weighty = 3.0;
            this.getContentPane().add((Component)new JPanel(), constraints);
        }
        this.scaleModelChart();
        this.revalidate();
    }

    private void lockChartsToOneScrollbar(JViewport viewport, boolean lastMaximizedChartPanelView, ModelChartImpl modelChart, MasterViewPortChangeListener masterViewPortChangeListener) {
        ChangeListener[] changeListeners = viewport.getChangeListeners();
        for (int j = 0; j < changeListeners.length; ++j) {
            if (!(changeListeners[j] instanceof MasterViewPortChangeListener)) continue;
            viewport.removeChangeListener(changeListeners[j]);
        }
        if (lastMaximizedChartPanelView) {
            modelChart.setHorizontalScrollBarPolicy(30);
            viewport.addChangeListener(masterViewPortChangeListener);
        } else {
            modelChart.setHorizontalScrollBarPolicy(31);
            masterViewPortChangeListener.addSlaveViewport(viewport);
        }
    }

    public int getChartPanelViewCount() {
        return this.chartPanelViews.size();
    }

    public ChartPanelView getChartPanelView(int i) {
        return (ChartPanelView)this.chartPanelViews.get(i);
    }

    public void setWatched(boolean watched) {
        this.watched = watched;
        JScrollBar horizontalScrollBar = ((ModelChartImpl)this.getLastMaximizedChartPanelView().getModelChart()).getHorizontalScrollBar();
        if (watched) {
            horizontalScrollBar.setValue(horizontalScrollBar.getMaximum());
        }
        horizontalScrollBar.setEnabled(!watched);
    }

    public boolean isWatched() {
        return this.watched;
    }

    public ChartPanelView getLastMaximizedChartPanelView() {
        ChartPanelView lastMaximizedChartPanelView = null;
        for (int i = 0; i < this.chartPanelViews.size(); ++i) {
            ChartPanelView chartPanelView = (ChartPanelView)this.chartPanelViews.get(i);
            if (chartPanelView.isMinimized()) continue;
            lastMaximizedChartPanelView = chartPanelView;
        }
        return lastMaximizedChartPanelView;
    }

    private void scaleModelChart() {
        for (int i = 0; i < this.chartPanelViews.size(); ++i) {
            ChartPanelView aChartPanelView = (ChartPanelView)this.chartPanelViews.get(i);
            aChartPanelView.getModelChart().setFootprint(this.getMaxFootprint());
            aChartPanelView.getModelChart().setMaxPause(this.getMaxMaxPause());
            aChartPanelView.getModelChart().setRunningTime(this.getMaxRunningTime());
        }
    }

    private double getMaxRunningTime() {
        double max = 0.0;
        for (int i = 0; i < this.chartPanelViews.size(); ++i) {
            max = Math.max(max, ((ChartPanelView)this.chartPanelViews.get(i)).getModel().getRunningTime());
        }
        return max;
    }

    private long getMaxFootprint() {
        long max = 0L;
        for (int i = 0; i < this.chartPanelViews.size(); ++i) {
            max = Math.max(max, ((ChartPanelView)this.chartPanelViews.get(i)).getModel().getFootprint());
        }
        return max;
    }

    private double getMaxMaxPause() {
        double max = 0.0;
        for (int i = 0; i < this.chartPanelViews.size(); ++i) {
            max = Math.max(max, ((ChartPanelView)this.chartPanelViews.get(i)).getModel().getPause().getMax());
        }
        return max;
    }

    private class ScrollBarMaximumChangeListener
    implements ChangeListener {
        private ScrollBarMaximumChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (GCDocument.this.isWatched()) {
                BoundedRangeModel model = (BoundedRangeModel)e.getSource();
                model.setValue(model.getMaximum());
            }
        }
    }

    private class MultiModelChartFacade
    implements ModelChart {
        private MultiModelChartFacade() {
        }

        public boolean isAntiAlias() {
            if (GCDocument.this.chartPanelViews.isEmpty()) {
                return false;
            }
            return ((ChartPanelView)GCDocument.this.chartPanelViews.get(0)).getModelChart().isAntiAlias();
        }

        public void setAntiAlias(boolean antiAlias) {
            for (int i = 0; i < GCDocument.this.chartPanelViews.size(); ++i) {
                ((ChartPanelView)GCDocument.this.chartPanelViews.get(i)).getModelChart().setAntiAlias(antiAlias);
            }
        }

        public long getFootprint() {
            if (GCDocument.this.chartPanelViews.isEmpty()) {
                return 0L;
            }
            return ((ChartPanelView)GCDocument.this.chartPanelViews.get(0)).getModelChart().getFootprint();
        }

        public double getMaxPause() {
            if (GCDocument.this.chartPanelViews.isEmpty()) {
                return 0.0;
            }
            return ((ChartPanelView)GCDocument.this.chartPanelViews.get(0)).getModelChart().getMaxPause();
        }

        public void setRunningTime(double runningTime) {
            for (int i = 0; i < GCDocument.this.chartPanelViews.size(); ++i) {
                ((ChartPanelView)GCDocument.this.chartPanelViews.get(i)).getModelChart().setRunningTime(runningTime);
            }
        }

        public void setFootprint(long footPrint) {
            for (int i = 0; i < GCDocument.this.chartPanelViews.size(); ++i) {
                ((ChartPanelView)GCDocument.this.chartPanelViews.get(i)).getModelChart().setFootprint(footPrint);
            }
        }

        public void setMaxPause(double maxPause) {
            for (int i = 0; i < GCDocument.this.chartPanelViews.size(); ++i) {
                ((ChartPanelView)GCDocument.this.chartPanelViews.get(i)).getModelChart().setMaxPause(maxPause);
            }
        }

        public void setScaleFactor(double scaleFactor) {
            for (int i = 0; i < GCDocument.this.chartPanelViews.size(); ++i) {
                ((ChartPanelView)GCDocument.this.chartPanelViews.get(i)).getModelChart().setScaleFactor(scaleFactor);
            }
        }

        public double getScaleFactor() {
            if (GCDocument.this.chartPanelViews.isEmpty()) {
                return 1.0;
            }
            return ((ChartPanelView)GCDocument.this.chartPanelViews.get(0)).getModelChart().getScaleFactor();
        }

        public boolean isShowGCTimesLine() {
            if (GCDocument.this.chartPanelViews.isEmpty()) {
                return false;
            }
            return ((ChartPanelView)GCDocument.this.chartPanelViews.get(0)).getModelChart().isShowGCTimesLine();
        }

        public void setShowGCTimesLine(boolean showGCTimesLine) {
            for (int i = 0; i < GCDocument.this.chartPanelViews.size(); ++i) {
                ((ChartPanelView)GCDocument.this.chartPanelViews.get(i)).getModelChart().setShowGCTimesLine(showGCTimesLine);
            }
        }

        public boolean isShowGCTimesRectangles() {
            if (GCDocument.this.chartPanelViews.isEmpty()) {
                return false;
            }
            return ((ChartPanelView)GCDocument.this.chartPanelViews.get(0)).getModelChart().isShowGCTimesRectangles();
        }

        public void setShowGCTimesRectangles(boolean showGCTimesRectangles) {
            for (int i = 0; i < GCDocument.this.chartPanelViews.size(); ++i) {
                ((ChartPanelView)GCDocument.this.chartPanelViews.get(i)).getModelChart().setShowGCTimesRectangles(showGCTimesRectangles);
            }
        }

        public boolean isShowFullGCLines() {
            if (GCDocument.this.chartPanelViews.isEmpty()) {
                return false;
            }
            return ((ChartPanelView)GCDocument.this.chartPanelViews.get(0)).getModelChart().isShowFullGCLines();
        }

        public void setShowFullGCLines(boolean showFullGCLines) {
            for (int i = 0; i < GCDocument.this.chartPanelViews.size(); ++i) {
                ((ChartPanelView)GCDocument.this.chartPanelViews.get(i)).getModelChart().setShowFullGCLines(showFullGCLines);
            }
        }

        public boolean isShowIncGCLines() {
            if (GCDocument.this.chartPanelViews.isEmpty()) {
                return false;
            }
            return ((ChartPanelView)GCDocument.this.chartPanelViews.get(0)).getModelChart().isShowIncGCLines();
        }

        public void setShowIncGCLines(boolean showIncGCLines) {
            for (int i = 0; i < GCDocument.this.chartPanelViews.size(); ++i) {
                ((ChartPanelView)GCDocument.this.chartPanelViews.get(i)).getModelChart().setShowIncGCLines(showIncGCLines);
            }
        }

        public boolean isShowTotalMemoryLine() {
            if (GCDocument.this.chartPanelViews.isEmpty()) {
                return false;
            }
            return ((ChartPanelView)GCDocument.this.chartPanelViews.get(0)).getModelChart().isShowTotalMemoryLine();
        }

        public void setShowTotalMemoryLine(boolean showTotalMemoryLine) {
            for (int i = 0; i < GCDocument.this.chartPanelViews.size(); ++i) {
                ((ChartPanelView)GCDocument.this.chartPanelViews.get(i)).getModelChart().setShowTotalMemoryLine(showTotalMemoryLine);
            }
        }

        public boolean isShowUsedMemoryLine() {
            if (GCDocument.this.chartPanelViews.isEmpty()) {
                return false;
            }
            return ((ChartPanelView)GCDocument.this.chartPanelViews.get(0)).getModelChart().isShowUsedMemoryLine();
        }

        public void setShowUsedMemoryLine(boolean showUsedMemoryLine) {
            for (int i = 0; i < GCDocument.this.chartPanelViews.size(); ++i) {
                ((ChartPanelView)GCDocument.this.chartPanelViews.get(i)).getModelChart().setShowUsedMemoryLine(showUsedMemoryLine);
            }
        }

        public void setShowTenured(boolean showTenured) {
            for (int i = 0; i < GCDocument.this.chartPanelViews.size(); ++i) {
                ((ChartPanelView)GCDocument.this.chartPanelViews.get(i)).getModelChart().setShowTenured(showTenured);
            }
        }

        public boolean isShowTenured() {
            if (GCDocument.this.chartPanelViews.isEmpty()) {
                return false;
            }
            return ((ChartPanelView)GCDocument.this.chartPanelViews.get(0)).getModelChart().isShowTenured();
        }

        public void setShowYoung(boolean showYoung) {
            for (int i = 0; i < GCDocument.this.chartPanelViews.size(); ++i) {
                ((ChartPanelView)GCDocument.this.chartPanelViews.get(i)).getModelChart().setShowYoung(showYoung);
            }
        }

        public boolean isShowYoung() {
            if (GCDocument.this.chartPanelViews.isEmpty()) {
                return false;
            }
            return ((ChartPanelView)GCDocument.this.chartPanelViews.get(0)).getModelChart().isShowYoung();
        }
    }

    private static class MasterViewPortChangeListener
    implements ChangeListener {
        private List slaveViewPorts = new ArrayList();

        private MasterViewPortChangeListener() {
        }

        public void addSlaveViewport(JViewport viewPort) {
            this.slaveViewPorts.add(viewPort);
        }

        public void stateChanged(ChangeEvent e) {
            JViewport master = (JViewport)e.getSource();
            int x = master.getViewPosition().x;
            for (int i = 0; i < this.slaveViewPorts.size(); ++i) {
                JViewport slave = (JViewport)this.slaveViewPorts.get(i);
                slave.setViewPosition(new Point(x, slave.getViewPosition().y));
            }
        }
    }
}

