/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer;

import com.tagtraum.perf.gcviewer.AbstractGCEvent;
import com.tagtraum.perf.gcviewer.ConcurrentGCEvent;
import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.math.DoubleData;
import com.tagtraum.perf.gcviewer.math.IntData;
import com.tagtraum.perf.gcviewer.math.RegressionLine;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GCModel
implements Serializable {
    private static Logger LOG = Logger.getLogger(GCModel.class.getName());
    private List allEvents;
    private List events;
    private List gcEvents;
    private List concurrentGCEvents;
    private List currentNoFullGCEvents;
    private List fullGCEvents;
    private long lastModified;
    private long length;
    private long footprint;
    private double runningTime;
    private DoubleData pause;
    private DoubleData fullGCPause;
    private DoubleData gcPause;
    private long freedMemory;
    private Format format;
    private IntData postGCUsedMemory;
    private IntData postFullGCUsedMemory;
    private IntData freedMemoryByGC;
    private IntData freedMemoryByFullGC;
    private DoubleData postGCSlope;
    private RegressionLine currentPostGCSlope;
    private RegressionLine currentRelativePostGCIncrease;
    private DoubleData relativePostGCIncrease;
    private RegressionLine postFullGCSlope;
    private RegressionLine relativePostFullGCIncrease;
    private boolean countTenuredAsFull = true;
    private URL url;

    public GCModel(boolean countTenuredAsFull) {
        this.countTenuredAsFull = countTenuredAsFull;
        this.allEvents = new ArrayList();
        this.events = new ArrayList();
        this.gcEvents = new ArrayList();
        this.concurrentGCEvents = new ArrayList();
        this.fullGCEvents = new ArrayList();
        this.currentNoFullGCEvents = new ArrayList();
        this.currentPostGCSlope = new RegressionLine();
        this.postFullGCSlope = new RegressionLine();
        this.postGCSlope = new DoubleData();
        this.freedMemoryByGC = new IntData();
        this.freedMemoryByFullGC = new IntData();
        this.postFullGCUsedMemory = new IntData();
        this.postGCUsedMemory = new IntData();
        this.pause = new DoubleData();
        this.fullGCPause = new DoubleData();
        this.gcPause = new DoubleData();
        this.currentRelativePostGCIncrease = new RegressionLine();
        this.relativePostGCIncrease = new DoubleData();
        this.relativePostFullGCIncrease = new RegressionLine();
    }

    public boolean isCountTenuredAsFull() {
        return this.countTenuredAsFull;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public URL getURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setURL(URL url) {
        this.url = url;
        if (url.getProtocol().startsWith("http")) {
            HttpURLConnection urlConnection = null;
            try {
                urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod("HEAD");
                this.length = urlConnection.getContentLength();
                this.lastModified = urlConnection.getLastModified();
                return;
            }
            catch (IOException e) {
                if (!LOG.isLoggable(Level.WARNING)) return;
                LOG.log(Level.WARNING, "Failed to obtain age and length of URL " + url, e);
                return;
            }
            finally {
                try {
                    InputStream inputStream;
                    if (urlConnection != null && (inputStream = urlConnection.getInputStream()) != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
                catch (IOException ignore) {}
            }
        }
        URLConnection urlConnection = null;
        try {
            urlConnection = url.openConnection();
            this.length = urlConnection.getContentLength();
            this.lastModified = urlConnection.getLastModified();
            return;
        }
        catch (IOException e) {
            if (!LOG.isLoggable(Level.WARNING)) return;
            LOG.log(Level.WARNING, "Failed to obtain age and length of URL " + url, e);
            return;
        }
        finally {
            try {
                InputStream inputStream;
                if (urlConnection != null && (inputStream = urlConnection.getInputStream()) != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isDifferent(File otherFile) {
        return this.lastModified != otherFile.lastModified() || this.length != otherFile.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean isDifferent(URL otherURL) {
        otherLength = 0L;
        otherLastModified = 0L;
        if (otherURL.getProtocol().startsWith("http")) {
            urlConnection = null;
            try {
                urlConnection = (HttpURLConnection)otherURL.openConnection();
                urlConnection.setRequestMethod("HEAD");
                otherLength = urlConnection.getContentLength();
                otherLastModified = urlConnection.getLastModified();
            }
            catch (IOException e) {
                if (!GCModel.LOG.isLoggable(Level.WARNING)) ** GOTO lbl45
                GCModel.LOG.log(Level.WARNING, "Failed to obtain age and otherLength of URL " + otherURL, e);
            }
            finally {
                try {
                    if (urlConnection != null && (inputStream = urlConnection.getInputStream()) != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
                catch (IOException ignore) {}
            }
        } else {
            urlConnection = null;
            try {
                urlConnection = otherURL.openConnection();
                otherLength = urlConnection.getContentLength();
                otherLastModified = urlConnection.getLastModified();
            }
            catch (IOException e) {
                if (GCModel.LOG.isLoggable(Level.WARNING)) {
                    GCModel.LOG.log(Level.WARNING, "Failed to obtain age and otherLength of URL " + otherURL, e);
                }
            }
            finally {
                try {
                    if (urlConnection != null && (inputStream = urlConnection.getInputStream()) != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
                catch (IOException ignore) {}
            }
        }
        return this.lastModified != otherLastModified || this.length != otherLength;
    }

    public Iterator getGCEvents() {
        return this.events.iterator();
    }

    public Iterator getConcurrentGCEvents() {
        return this.concurrentGCEvents.iterator();
    }

    public Iterator getEvents() {
        return this.allEvents.iterator();
    }

    public void add(AbstractGCEvent abstractEvent) {
        this.allEvents.add(abstractEvent);
        if (abstractEvent instanceof ConcurrentGCEvent) {
            this.concurrentGCEvents.add(abstractEvent);
        } else if (abstractEvent instanceof GCEvent) {
            this.events.add(abstractEvent);
            GCEvent event = (GCEvent)abstractEvent;
            this.footprint = Math.max(this.footprint, (long)event.getTotal());
            this.runningTime = Math.max(this.runningTime, event.getTimestamp());
            this.freedMemory += (long)(event.getPreUsed() - event.getPostUsed());
            this.pause.add(event.getPause());
            if (event.getType().getGeneration() != AbstractGCEvent.Generation.TENURED && !event.hasTenuredDetail()) {
                this.gcEvents.add(event);
                this.postGCUsedMemory.add(event.getPostUsed());
                this.freedMemoryByGC.add(event.getPreUsed() - event.getPostUsed());
                this.currentNoFullGCEvents.add(event);
                this.currentPostGCSlope.addPoint(event.getTimestamp(), event.getPostUsed());
                this.currentRelativePostGCIncrease.addPoint(this.currentRelativePostGCIncrease.getPointCount(), event.getPostUsed());
                this.gcPause.add(event.getPause());
            } else {
                if (event.getType().getGeneration() == AbstractGCEvent.Generation.TENURED || event.hasTenuredDetail()) {
                    this.fullGCEvents.add(event);
                    this.postFullGCUsedMemory.add(event.getPostUsed());
                    int freed = event.getPreUsed() - event.getPostUsed();
                    this.freedMemoryByFullGC.add(freed);
                    this.fullGCPause.add(event.getPause());
                    this.postFullGCSlope.addPoint(event.getTimestamp(), event.getPostUsed());
                    this.relativePostFullGCIncrease.addPoint(this.relativePostFullGCIncrease.getPointCount(), event.getPostUsed());
                }
                if (this.currentPostGCSlope.hasPoints()) {
                    if (this.currentPostGCSlope.isLine()) {
                        this.postGCSlope.add(this.currentPostGCSlope.slope(), this.currentPostGCSlope.getPointCount());
                        this.relativePostGCIncrease.add(this.currentRelativePostGCIncrease.slope(), this.currentRelativePostGCIncrease.getPointCount());
                    }
                    this.currentPostGCSlope.reset();
                    this.currentRelativePostGCIncrease.reset();
                }
            }
        }
    }

    public int size() {
        return this.events.size();
    }

    public AbstractGCEvent get(int index) {
        return (AbstractGCEvent)this.events.get(index);
    }

    public DoubleData getFullGCPause() {
        return this.fullGCPause;
    }

    public DoubleData getGCPause() {
        return this.gcPause;
    }

    public RegressionLine getRelativePostFullGCIncrease() {
        return this.relativePostFullGCIncrease;
    }

    public DoubleData getRelativePostGCIncrease() {
        return this.relativePostGCIncrease;
    }

    public double getPostGCSlope() {
        return this.postGCSlope.average();
    }

    public IntData getPostGCUsedMemory() {
        return this.postGCUsedMemory;
    }

    public RegressionLine getCurrentPostGCSlope() {
        return this.currentPostGCSlope;
    }

    public RegressionLine getPostFullGCSlope() {
        return this.postFullGCSlope;
    }

    public IntData getPostFullGCUsedMemory() {
        return this.postFullGCUsedMemory;
    }

    public IntData getFreedMemoryByGC() {
        return this.freedMemoryByGC;
    }

    public IntData getFreedMemoryByFullGC() {
        return this.freedMemoryByFullGC;
    }

    public IntData getFootprintAfterGC() {
        return this.postGCUsedMemory;
    }

    public IntData getFootprintAfterFullGC() {
        return this.postFullGCUsedMemory;
    }

    public DoubleData getPause() {
        return this.pause;
    }

    public double getThroughput() {
        return 100.0 * (this.runningTime - this.pause.getSum()) / this.runningTime;
    }

    public long getFootprint() {
        return this.footprint;
    }

    public double getRunningTime() {
        return this.runningTime;
    }

    public long getFreedMemory() {
        return this.freedMemory;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public boolean hasCorrectTimestamp() {
        return this.format == Format.IBM_VERBOSE_GC || this.format == Format.SUN_X_LOG_GC || this.format == Format.SUN_1_2_2VERBOSE_GC;
    }

    public String toString() {
        return this.events.toString();
    }

    public static class Format
    implements Serializable {
        private String format;
        public static final Format SUN_VERBOSE_GC = new Format("Sun -verbose:gc");
        public static final Format SUN_X_LOG_GC = new Format("Sun -Xloggc:<file>");
        public static final Format IBM_VERBOSE_GC = new Format("IBM -verbose:gc");
        public static final Format SUN_1_2_2VERBOSE_GC = new Format("Sun 1.2.2 -verbose:gc");

        private Format(String format) {
            this.format = format;
        }

        public String toString() {
            return this.format;
        }
    }
}

