/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer;

import com.tagtraum.perf.gcviewer.DesktopPane;
import com.tagtraum.perf.gcviewer.GCDocument;
import com.tagtraum.perf.gcviewer.RecentURLsMenu;
import com.tagtraum.perf.gcviewer.action.About;
import com.tagtraum.perf.gcviewer.action.Arrange;
import com.tagtraum.perf.gcviewer.action.Exit;
import com.tagtraum.perf.gcviewer.action.Export;
import com.tagtraum.perf.gcviewer.action.OpenFile;
import com.tagtraum.perf.gcviewer.action.OpenRecent;
import com.tagtraum.perf.gcviewer.action.OpenURL;
import com.tagtraum.perf.gcviewer.action.Refresh;
import com.tagtraum.perf.gcviewer.action.Watch;
import com.tagtraum.perf.gcviewer.action.Zoom;
import com.tagtraum.perf.gcviewer.renderer.FullGCLineRenderer;
import com.tagtraum.perf.gcviewer.renderer.GCRectanglesRenderer;
import com.tagtraum.perf.gcviewer.renderer.GCTimesRenderer;
import com.tagtraum.perf.gcviewer.renderer.IncLineRenderer;
import com.tagtraum.perf.gcviewer.renderer.TotalHeapRenderer;
import com.tagtraum.perf.gcviewer.renderer.TotalTenuredRenderer;
import com.tagtraum.perf.gcviewer.renderer.TotalYoungRenderer;
import com.tagtraum.perf.gcviewer.renderer.UsedHeapRenderer;
import com.tagtraum.perf.gcviewer.util.NumberParser;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class GCViewer
extends JFrame {
    public static ResourceBundle localStrings = ResourceBundle.getBundle("com.tagtraum.perf.gcviewer.localStrings");
    private static final String PREFERENCE_VERSION = "1.1";
    private static final String FULL_GC_LINES = "fullgclines";
    private static final String INC_GC_LINES = "incgclines";
    private static final String GC_LINES_LINE = "gctimesline";
    private static final String GC_TIMES_RECTANGLES = "gctimesrectangles";
    private static final String TOTAL_MEMORY = "totalmemory";
    private static final String USED_MEMORY = "usedmemory";
    private static final String TENURED_MEMORY = "tenuredmemory";
    private static final String YOUNG_MEMORY = "youngmemory";
    private JToolBar toolBar;
    private ActionListener viewActionListener;
    private JMenu fileMenu;
    private JMenu windowMenu;
    private JMenuItem exportMenuItem;
    private ButtonGroup windowCheckBoxGroup = new ButtonGroup();
    private JDesktopPane desktopPane;
    private JComboBox zoomComboBox;
    private Exit exitAction = new Exit(this);
    private About aboutAction = new About(this);
    private OpenFile openFileAction = new OpenFile(this);
    private OpenURL openURLAction = new OpenURL(this);
    private Refresh refreshAction = new Refresh(this);
    private Export exportAction = new Export(this);
    private Zoom zoomAction = new Zoom(this);
    private Arrange arrangeAction = new Arrange(this);
    private Watch watchAction = new Watch(this);
    private JCheckBoxMenuItem showDataPanel;
    private JCheckBoxMenuItem fullGCLines;
    private JCheckBoxMenuItem incGCLines;
    private JCheckBoxMenuItem gcTimesLine;
    private JCheckBoxMenuItem gcTimesRectangle;
    private JCheckBoxMenuItem usedMemory;
    private JCheckBoxMenuItem totalMemory;
    private JCheckBoxMenuItem tenuredMemory;
    private JCheckBoxMenuItem youngMemory;
    private JCheckBoxMenuItem watchCheckBoxMenuItem;
    private JCheckBoxMenuItem antiAlias;
    private Map lines;
    private JToggleButton watchToggle;
    private RecentURLsMenu recentURLsMenu;
    private InternalFrameListener gcDocumentListener = new InternalFrameListener(){

        public void internalFrameOpened(InternalFrameEvent e) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(new WindowMenuItemAction(e));
            GCViewer.this.windowMenu.add(menuItem);
            GCViewer.this.windowCheckBoxGroup.add(menuItem);
        }

        public void internalFrameClosing(InternalFrameEvent e) {
        }

        public void internalFrameClosed(InternalFrameEvent e) {
            if (GCViewer.this.desktopPane.getAllFrames().length == 0) {
                GCViewer.this.arrangeAction.setEnabled(false);
            }
            ((GCDocument)e.getInternalFrame()).getRefreshWatchDog().stop();
            for (int i = 2; i < GCViewer.this.windowMenu.getItemCount(); ++i) {
                JMenuItem item = GCViewer.this.windowMenu.getItem(i);
                if (((WindowMenuItemAction)item.getAction()).getGcDocument() != e.getInternalFrame()) continue;
                GCViewer.this.windowMenu.remove(item);
                GCViewer.this.windowCheckBoxGroup.remove(item);
                break;
            }
        }

        public void internalFrameIconified(InternalFrameEvent e) {
        }

        public void internalFrameDeiconified(InternalFrameEvent e) {
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            for (int i = 2; i < GCViewer.this.windowMenu.getItemCount(); ++i) {
                JMenuItem item = GCViewer.this.windowMenu.getItem(i);
                if (((WindowMenuItemAction)item.getAction()).getGcDocument() != e.getInternalFrame()) continue;
                item.setSelected(true);
                break;
            }
            GCViewer.this.zoomComboBox.setSelectedItem((int)(GCViewer.this.getSelectedGCDocument().getModelChart().getScaleFactor() * 1000.0) + "%");
            GCViewer.this.exportAction.setEnabled(true);
            GCViewer.this.refreshAction.setEnabled(true);
            GCViewer.this.watchAction.setEnabled(true);
            GCViewer.this.watchCheckBoxMenuItem.setSelected(GCViewer.this.getSelectedGCDocument().isWatched());
            GCViewer.this.getSelectedGCDocument().getRefreshWatchDog().setAction(GCViewer.this.watchAction);
            GCViewer.this.watchToggle.setSelected(GCViewer.this.getSelectedGCDocument().isWatched());
            GCViewer.this.zoomAction.setEnabled(true);
            GCViewer.this.arrangeAction.setEnabled(true);
            GCViewer.this.fullGCLines.setState(GCViewer.this.getSelectedGCDocument().getModelChart().isShowFullGCLines());
            GCViewer.this.incGCLines.setState(GCViewer.this.getSelectedGCDocument().getModelChart().isShowIncGCLines());
            GCViewer.this.gcTimesLine.setState(GCViewer.this.getSelectedGCDocument().getModelChart().isShowGCTimesLine());
            GCViewer.this.gcTimesRectangle.setState(GCViewer.this.getSelectedGCDocument().getModelChart().isShowGCTimesRectangles());
            GCViewer.this.totalMemory.setState(GCViewer.this.getSelectedGCDocument().getModelChart().isShowTotalMemoryLine());
            GCViewer.this.usedMemory.setState(GCViewer.this.getSelectedGCDocument().getModelChart().isShowUsedMemoryLine());
            GCViewer.this.tenuredMemory.setState(GCViewer.this.getSelectedGCDocument().getModelChart().isShowTenured());
            GCViewer.this.youngMemory.setState(GCViewer.this.getSelectedGCDocument().getModelChart().isShowYoung());
            GCViewer.this.showDataPanel.setState(GCViewer.this.getSelectedGCDocument().isShowModelPanel());
            GCViewer.this.antiAlias.setSelected(GCViewer.this.getSelectedGCDocument().getModelChart().isAntiAlias());
        }

        public void internalFrameDeactivated(InternalFrameEvent e) {
            GCViewer.this.exportAction.setEnabled(false);
            GCViewer.this.refreshAction.setEnabled(false);
            GCViewer.this.watchAction.setEnabled(false);
            GCViewer.this.zoomAction.setEnabled(false);
            GCViewer.this.watchToggle.setSelected(false);
            GCViewer.this.watchCheckBoxMenuItem.setSelected(false);
            ((GCDocument)e.getInternalFrame()).getRefreshWatchDog().setAction(null);
        }
    };

    public GCViewer() {
        super("tagtraum industries incorporated - GCViewer");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("gcviewericon.gif")));
        this.desktopPane = new DesktopPane(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                GCViewer.this.exit();
            }
        });
        this.viewActionListener = new ViewMenuActionListener();
        this.recentURLsMenu = new RecentURLsMenu(this);
        this.openURLAction.setRecentURLsModel(this.recentURLsMenu.getRecentURLsModel());
        this.setJMenuBar(this.initMenuBar());
        this.toolBar = this.initToolBar();
        this.watchCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GCViewer.this.watchToggle.setSelected(GCViewer.this.watchCheckBoxMenuItem.getState());
            }
        });
        this.watchToggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GCViewer.this.watchCheckBoxMenuItem.setState(GCViewer.this.watchToggle.isSelected());
            }
        });
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.desktopPane, "Center");
        this.loadPreferences();
        this.setVisible(true);
    }

    public RecentURLsMenu getRecentFilesMenu() {
        return this.recentURLsMenu;
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    public GCDocument getSelectedGCDocument() {
        return (GCDocument)this.desktopPane.getSelectedFrame();
    }

    private static URL[] convertFilesToURLs(File[] files) throws MalformedURLException {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            urls[i] = files[i].getAbsoluteFile().toURL();
        }
        return urls;
    }

    public void open(File[] files) {
        try {
            URL[] urls = GCViewer.convertFilesToURLs(files);
            if (files.length >= 1) {
                // empty if block
            }
            this.open(urls);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.toString() + " " + e.getLocalizedMessage(), localStrings.getString("fileopen_dialog_read_file_failed"), 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), localStrings.getString("fileopen_dialog_read_file_failed"), 0);
        }
    }

    public void open(URL[] urls) {
        try {
            if (urls.length >= 1) {
                URL url = urls[0];
                GCDocument gcDocument = new GCDocument(this, url.toString());
                gcDocument.add(url);
                gcDocument.addInternalFrameListener(this.gcDocumentListener);
                this.desktopPane.add(gcDocument);
                gcDocument.setSelected(true);
                gcDocument.setSize(450, 300);
                gcDocument.setMaximum(true);
                gcDocument.setVisible(true);
            }
            if (urls.length > 1) {
                URL[] addURLs = new URL[urls.length - 1];
                System.arraycopy(urls, 1, addURLs, 0, addURLs.length);
                this.add(addURLs);
            }
            this.recentURLsMenu.getRecentURLsModel().add(urls);
            this.repaint();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.toString() + " " + e.getLocalizedMessage(), localStrings.getString("fileopen_dialog_read_file_failed"), 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), localStrings.getString("fileopen_dialog_read_file_failed"), 0);
        }
    }

    public void add(File[] files) {
        try {
            if (files.length >= 0) {
                this.openFileAction.setSelectedFile(files[0]);
            }
            URL[] urls = GCViewer.convertFilesToURLs(files);
            this.add(urls);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.toString() + " " + e.getLocalizedMessage(), localStrings.getString("fileopen_dialog_read_file_failed"), 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), localStrings.getString("fileopen_dialog_read_file_failed"), 0);
        }
    }

    public void add(URL[] urls) {
        try {
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                this.getSelectedGCDocument().add(url);
            }
            this.recentURLsMenu.getRecentURLsModel().add(urls);
            this.repaint();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.toString() + " " + e.getLocalizedMessage(), localStrings.getString("fileopen_dialog_read_file_failed"), 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), localStrings.getString("fileopen_dialog_read_file_failed"), 0);
        }
    }

    private JToolBar initToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(this.openFileAction);
        toolBar.add(this.openURLAction);
        toolBar.add(this.exportAction);
        toolBar.add(this.refreshAction);
        this.watchToggle = new JToggleButton();
        this.watchToggle.setAction(this.watchAction);
        this.watchToggle.setText("");
        toolBar.add(this.watchToggle);
        toolBar.addSeparator();
        this.zoomComboBox = new JComboBox<String>(new String[]{"1%", "5%", "10%", "50%", "100%", "200%", "300%", "500%", "1000%", "5000%"});
        this.zoomComboBox.setSelectedIndex(2);
        this.zoomComboBox.setAction(this.zoomAction);
        this.zoomComboBox.setEditable(true);
        this.zoomComboBox.setMaximumSize(this.zoomComboBox.getPreferredSize());
        toolBar.add(this.zoomComboBox);
        toolBar.addSeparator();
        toolBar.add(this.aboutAction);
        return toolBar;
    }

    private static ImageIcon createMonoColoredImageIcon(Paint paint, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 7);
        Graphics2D g = image.createGraphics();
        g.setPaint(paint);
        int lineHeight = 4;
        g.fill3DRect(0, height / 2 - 2, width, 4, false);
        g.dispose();
        return new ImageIcon(image);
    }

    private static ImageIcon createEmptyImageIcon(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 7);
        Graphics2D g = image.createGraphics();
        g.dispose();
        return new ImageIcon(image);
    }

    private JMenuBar initMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.fileMenu = new JMenu(localStrings.getString("main_frame_menu_file"));
        this.fileMenu.setMnemonic(localStrings.getString("main_frame_menu_mnemonic_file").charAt(0));
        menuBar.add(this.fileMenu);
        JMenuItem menuItem = new JMenuItem(this.openFileAction);
        this.fileMenu.add(menuItem);
        menuItem = new JMenuItem(this.openURLAction);
        this.fileMenu.add(menuItem);
        this.recentURLsMenu.setIcon(GCViewer.createEmptyImageIcon(20, 20));
        this.fileMenu.add(this.recentURLsMenu);
        this.exportMenuItem = new JMenuItem(this.exportAction);
        this.fileMenu.add(this.exportMenuItem);
        menuItem = new JMenuItem(this.refreshAction);
        this.fileMenu.add(menuItem);
        this.watchCheckBoxMenuItem = new JCheckBoxMenuItem(this.watchAction);
        this.fileMenu.add(this.watchCheckBoxMenuItem);
        menuItem = new JMenuItem(this.exitAction);
        this.fileMenu.add(menuItem);
        JMenu viewMenu = new JMenu(localStrings.getString("main_frame_menu_view"));
        viewMenu.setMnemonic(localStrings.getString("main_frame_menu_mnemonic_view").charAt(0));
        menuBar.add(viewMenu);
        this.showDataPanel = new JCheckBoxMenuItem(localStrings.getString("main_frame_menuitem_show_data_panel"), true);
        this.showDataPanel.setMnemonic(localStrings.getString("main_frame_menuitem_mnemonic_show_data_panel").charAt(0));
        this.showDataPanel.setIcon(GCViewer.createEmptyImageIcon(20, 20));
        this.showDataPanel.setToolTipText(localStrings.getString("main_frame_menuitem_hint_show_data_panel"));
        this.showDataPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GCDocument gcDocument = GCViewer.this.getSelectedGCDocument();
                if (gcDocument != null) {
                    gcDocument.setShowModelPanel(GCViewer.this.showDataPanel.getState());
                }
            }
        });
        viewMenu.add(this.showDataPanel);
        viewMenu.addSeparator();
        this.antiAlias = new JCheckBoxMenuItem(localStrings.getString("main_frame_menuitem_antialias"), true);
        this.antiAlias.setMnemonic(localStrings.getString("main_frame_menuitem_mnemonic_antialias").charAt(0));
        this.antiAlias.setIcon(GCViewer.createEmptyImageIcon(20, 20));
        this.antiAlias.setToolTipText(localStrings.getString("main_frame_menuitem_hint_antialias"));
        this.antiAlias.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GCDocument gcDocument = GCViewer.this.getSelectedGCDocument();
                if (gcDocument != null) {
                    gcDocument.getModelChart().setAntiAlias(GCViewer.this.antiAlias.getState());
                    gcDocument.relayout();
                }
            }
        });
        this.antiAlias.setSelected(false);
        viewMenu.add(this.antiAlias);
        viewMenu.addSeparator();
        this.lines = new HashMap();
        this.fullGCLines = new JCheckBoxMenuItem(localStrings.getString("main_frame_menuitem_full_gc_lines"), true);
        this.fullGCLines.setMnemonic(localStrings.getString("main_frame_menuitem_mnemonic_full_gc_lines").charAt(0));
        this.fullGCLines.setToolTipText(localStrings.getString("main_frame_menuitem_hint_full_gc_lines"));
        this.fullGCLines.setIcon(GCViewer.createMonoColoredImageIcon(FullGCLineRenderer.DEFAULT_LINEPAINT, 20, 20));
        this.fullGCLines.setActionCommand(FULL_GC_LINES);
        this.fullGCLines.addActionListener(this.viewActionListener);
        viewMenu.add(this.fullGCLines);
        this.lines.put(FULL_GC_LINES, this.fullGCLines);
        this.incGCLines = new JCheckBoxMenuItem(localStrings.getString("main_frame_menuitem_inc_gc_lines"), true);
        this.incGCLines.setMnemonic(localStrings.getString("main_frame_menuitem_mnemonic_inc_gc_lines").charAt(0));
        this.incGCLines.setToolTipText(localStrings.getString("main_frame_menuitem_hint_inc_gc_lines"));
        this.incGCLines.setIcon(GCViewer.createMonoColoredImageIcon(IncLineRenderer.DEFAULT_LINEPAINT, 20, 20));
        this.incGCLines.setActionCommand(INC_GC_LINES);
        this.incGCLines.addActionListener(this.viewActionListener);
        viewMenu.add(this.incGCLines);
        this.lines.put(INC_GC_LINES, this.incGCLines);
        this.gcTimesLine = new JCheckBoxMenuItem(localStrings.getString("main_frame_menuitem_gc_times_line"), true);
        this.gcTimesLine.setMnemonic(localStrings.getString("main_frame_menuitem_mnemonic_gc_times_line").charAt(0));
        this.gcTimesLine.setToolTipText(localStrings.getString("main_frame_menuitem_hint_gc_times_line"));
        this.gcTimesLine.setIcon(GCViewer.createMonoColoredImageIcon(GCTimesRenderer.DEFAULT_LINEPAINT, 20, 20));
        this.gcTimesLine.setActionCommand(GC_LINES_LINE);
        this.gcTimesLine.addActionListener(this.viewActionListener);
        viewMenu.add(this.gcTimesLine);
        this.lines.put(GC_LINES_LINE, this.gcTimesLine);
        this.gcTimesRectangle = new JCheckBoxMenuItem(localStrings.getString("main_frame_menuitem_gc_times_rectangles"), true);
        this.gcTimesRectangle.setMnemonic(localStrings.getString("main_frame_menuitem_mnemonic_gc_times_rectangles").charAt(0));
        this.gcTimesRectangle.setToolTipText(localStrings.getString("main_frame_menuitem_hint_gc_times_rectangles"));
        this.gcTimesRectangle.setIcon(GCViewer.createMonoColoredImageIcon(GCRectanglesRenderer.DEFAULT_LINEPAINT, 20, 20));
        this.gcTimesRectangle.setActionCommand(GC_TIMES_RECTANGLES);
        this.gcTimesRectangle.addActionListener(this.viewActionListener);
        viewMenu.add(this.gcTimesRectangle);
        this.lines.put(GC_TIMES_RECTANGLES, this.gcTimesRectangle);
        this.totalMemory = new JCheckBoxMenuItem(localStrings.getString("main_frame_menuitem_total_memory"), true);
        this.totalMemory.setMnemonic(localStrings.getString("main_frame_menuitem_mnemonic_total_memory").charAt(0));
        this.totalMemory.setToolTipText(localStrings.getString("main_frame_menuitem_hint_total_memory"));
        this.totalMemory.setIcon(GCViewer.createMonoColoredImageIcon(TotalHeapRenderer.DEFAULT_LINEPAINT, 20, 20));
        this.totalMemory.setActionCommand(TOTAL_MEMORY);
        this.totalMemory.addActionListener(this.viewActionListener);
        viewMenu.add(this.totalMemory);
        this.lines.put(TOTAL_MEMORY, this.totalMemory);
        this.tenuredMemory = new JCheckBoxMenuItem(localStrings.getString("main_frame_menuitem_tenured_memory"), true);
        this.tenuredMemory.setMnemonic(localStrings.getString("main_frame_menuitem_mnemonic_tenured_memory").charAt(0));
        this.tenuredMemory.setToolTipText(localStrings.getString("main_frame_menuitem_hint_tenured_memory"));
        this.tenuredMemory.setIcon(GCViewer.createMonoColoredImageIcon(TotalTenuredRenderer.DEFAULT_LINEPAINT, 20, 20));
        this.tenuredMemory.setActionCommand(TENURED_MEMORY);
        this.tenuredMemory.addActionListener(this.viewActionListener);
        viewMenu.add(this.tenuredMemory);
        this.lines.put(TENURED_MEMORY, this.tenuredMemory);
        this.youngMemory = new JCheckBoxMenuItem(localStrings.getString("main_frame_menuitem_young_memory"), true);
        this.youngMemory.setMnemonic(localStrings.getString("main_frame_menuitem_mnemonic_young_memory").charAt(0));
        this.youngMemory.setToolTipText(localStrings.getString("main_frame_menuitem_hint_young_memory"));
        this.youngMemory.setIcon(GCViewer.createMonoColoredImageIcon(TotalYoungRenderer.DEFAULT_LINEPAINT, 20, 20));
        this.youngMemory.setActionCommand(YOUNG_MEMORY);
        this.youngMemory.addActionListener(this.viewActionListener);
        viewMenu.add(this.youngMemory);
        this.lines.put(YOUNG_MEMORY, this.youngMemory);
        this.usedMemory = new JCheckBoxMenuItem(localStrings.getString("main_frame_menuitem_used_memory"), true);
        this.usedMemory.setMnemonic(localStrings.getString("main_frame_menuitem_mnemonic_used_memory").charAt(0));
        this.usedMemory.setToolTipText(localStrings.getString("main_frame_menuitem_hint_used_memory"));
        this.usedMemory.setIcon(GCViewer.createMonoColoredImageIcon(UsedHeapRenderer.DEFAULT_LINEPAINT, 20, 20));
        this.usedMemory.setActionCommand(USED_MEMORY);
        this.usedMemory.addActionListener(this.viewActionListener);
        viewMenu.add(this.usedMemory);
        this.lines.put(USED_MEMORY, this.usedMemory);
        this.windowMenu = new JMenu(localStrings.getString("main_frame_menu_window"));
        this.windowMenu.setMnemonic(localStrings.getString("main_frame_menu_mnemonic_window").charAt(0));
        menuBar.add(this.windowMenu);
        menuItem = new JMenuItem(this.arrangeAction);
        this.windowMenu.add(menuItem);
        this.windowMenu.addSeparator();
        JMenu helpMenu = new JMenu(localStrings.getString("main_frame_menu_help"));
        helpMenu.setMnemonic(localStrings.getString("main_frame_menu_mnemonic_help").charAt(0));
        menuBar.add(helpMenu);
        menuItem = new JMenuItem(this.aboutAction);
        helpMenu.add(menuItem);
        return menuBar;
    }

    public void exit() {
        this.storePreferences();
        this.dispose();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadPreferences() {
        File preferences = this.getPreferencesFile();
        if (preferences.exists()) {
            FileInputStream in = null;
            try {
                String recentFiles;
                in = new FileInputStream(preferences);
                Properties properties = new Properties();
                properties.load(in);
                if (!PREFERENCE_VERSION.equals(properties.getProperty("preferences.version"))) return;
                Iterator line = this.lines.keySet().iterator();
                while (line.hasNext()) {
                    String name = (String)line.next();
                    JCheckBoxMenuItem item = (JCheckBoxMenuItem)this.lines.get(name);
                    item.setState("true".equals(properties.getProperty("view." + name, "true")));
                    this.viewActionListener.actionPerformed(new ActionEvent(item, 0, item.getActionCommand()));
                }
                int width = this.getIntegerProperty(properties.getProperty("window.width"), 800);
                int height = this.getIntegerProperty(properties.getProperty("window.height"), 600);
                int x = this.getIntegerProperty(properties.getProperty("window.x"), 0);
                int y = this.getIntegerProperty(properties.getProperty("window.y"), 0);
                this.setBounds(x, y, width, height);
                String lastfile = properties.getProperty("lastfile");
                if (lastfile != null) {
                    this.openFileAction.setSelectedFile(new File(lastfile));
                }
                int i = 0;
                while ((recentFiles = properties.getProperty("recent." + i)) != null) {
                    StringTokenizer st = new StringTokenizer(recentFiles, ";");
                    URL[] urls = new URL[st.countTokens()];
                    int j = 0;
                    while (st.hasMoreTokens()) {
                        urls[j] = new URL(st.nextToken());
                        ++j;
                    }
                    this.recentURLsMenu.getRecentURLsModel().add(urls);
                    ++i;
                }
                return;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.setBounds(0, 0, 800, 600);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storePreferences() {
        File preferences = this.getPreferencesFile();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(preferences);
            Properties properties = new Properties();
            Iterator line = this.lines.keySet().iterator();
            while (line.hasNext()) {
                String name = (String)line.next();
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)this.lines.get(name);
                properties.setProperty("view." + item.getActionCommand(), item.getState() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
            }
            properties.setProperty("window.width", Integer.toString(this.getWidth()));
            properties.setProperty("window.height", Integer.toString(this.getHeight()));
            properties.setProperty("window.x", Integer.toString(this.getX()));
            properties.setProperty("window.y", Integer.toString(this.getY()));
            properties.setProperty("preferences.version", PREFERENCE_VERSION);
            if (this.openFileAction.getLastSelectedFiles().length != 0) {
                properties.setProperty("lastfile", this.openFileAction.getLastSelectedFiles()[0].getAbsolutePath());
            }
            Component[] recentMenuItems = this.recentURLsMenu.getMenuComponents();
            for (int i = 0; i < recentMenuItems.length; ++i) {
                OpenRecent openRecent = (OpenRecent)((JMenuItem)recentMenuItems[i]).getAction();
                URL[] urls = openRecent.getURLs();
                StringBuffer sb = new StringBuffer();
                for (int j = 0; j < urls.length; ++j) {
                    sb.append(urls[j]);
                    sb.append(';');
                }
                properties.setProperty("recent." + (recentMenuItems.length - i - 1), sb.toString());
            }
            properties.store(out, "GCViewer preferences " + new Date());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private int getIntegerProperty(String stringValue, int defaultValue) {
        int value = defaultValue;
        try {
            if (stringValue != null) {
                value = NumberParser.parseInt(stringValue);
            }
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        return value;
    }

    private File getPreferencesFile() {
        return new File(System.getProperty("user.home") + "/gcviewer.properties");
    }

    public static void main(final String[] args) {
        if (args.length > 1) {
            GCViewer.usage();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GCViewer viewer = new GCViewer();
                    if (args.length == 1) {
                        viewer.open(new File[]{new File(args[0])});
                    }
                }
            });
        }
    }

    private static void usage() {
        System.out.println("GCViewer");
        System.out.println("java com.tagtraum.perf.gcviewer.GCViewer [<gc-log-file>]");
    }

    private static class WindowMenuItemAction
    extends AbstractAction
    implements PropertyChangeListener {
        private GCDocument gcDocument;

        public WindowMenuItemAction(InternalFrameEvent e) {
            this.gcDocument = (GCDocument)e.getInternalFrame();
            this.putValue("Name", this.gcDocument.getTitle());
            this.gcDocument.addPropertyChangeListener("title", this);
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                this.gcDocument.setSelected(true);
            }
            catch (PropertyVetoException e1) {
                e1.printStackTrace();
            }
        }

        public GCDocument getGcDocument() {
            return this.gcDocument;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.putValue("Name", this.gcDocument.getTitle());
        }
    }

    private class ViewMenuActionListener
    implements ActionListener {
        private ViewMenuActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (GCViewer.this.getSelectedGCDocument() == null) {
                return;
            }
            if (e.getActionCommand() == GCViewer.FULL_GC_LINES) {
                GCViewer.this.getSelectedGCDocument().getModelChart().setShowFullGCLines(((JCheckBoxMenuItem)e.getSource()).getState());
            } else if (e.getActionCommand() == GCViewer.INC_GC_LINES) {
                GCViewer.this.getSelectedGCDocument().getModelChart().setShowIncGCLines(((JCheckBoxMenuItem)e.getSource()).getState());
            } else if (e.getActionCommand() == GCViewer.GC_LINES_LINE) {
                GCViewer.this.getSelectedGCDocument().getModelChart().setShowGCTimesLine(((JCheckBoxMenuItem)e.getSource()).getState());
            } else if (e.getActionCommand() == GCViewer.GC_TIMES_RECTANGLES) {
                GCViewer.this.getSelectedGCDocument().getModelChart().setShowGCTimesRectangles(((JCheckBoxMenuItem)e.getSource()).getState());
            } else if (e.getActionCommand() == GCViewer.TOTAL_MEMORY) {
                GCViewer.this.getSelectedGCDocument().getModelChart().setShowTotalMemoryLine(((JCheckBoxMenuItem)e.getSource()).getState());
            } else if (e.getActionCommand() == GCViewer.USED_MEMORY) {
                GCViewer.this.getSelectedGCDocument().getModelChart().setShowUsedMemoryLine(((JCheckBoxMenuItem)e.getSource()).getState());
            } else if (e.getActionCommand() == GCViewer.TENURED_MEMORY) {
                GCViewer.this.getSelectedGCDocument().getModelChart().setShowTenured(((JCheckBoxMenuItem)e.getSource()).getState());
            } else if (e.getActionCommand() == GCViewer.YOUNG_MEMORY) {
                GCViewer.this.getSelectedGCDocument().getModelChart().setShowYoung(((JCheckBoxMenuItem)e.getSource()).getState());
            }
        }
    }
}

