/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer;

import com.tagtraum.perf.gcviewer.AbstractGCEvent;
import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.GCModel;
import com.tagtraum.perf.gcviewer.ModelChart;
import com.tagtraum.perf.gcviewer.TimeOffsetPanel;
import com.tagtraum.perf.gcviewer.renderer.FullGCLineRenderer;
import com.tagtraum.perf.gcviewer.renderer.GCRectanglesRenderer;
import com.tagtraum.perf.gcviewer.renderer.GCTimesRenderer;
import com.tagtraum.perf.gcviewer.renderer.IncLineRenderer;
import com.tagtraum.perf.gcviewer.renderer.TotalHeapRenderer;
import com.tagtraum.perf.gcviewer.renderer.TotalTenuredRenderer;
import com.tagtraum.perf.gcviewer.renderer.TotalYoungRenderer;
import com.tagtraum.perf.gcviewer.renderer.UsedHeapRenderer;
import com.tagtraum.perf.gcviewer.util.TimeFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class ModelChartImpl
extends JScrollPane
implements ModelChart {
    private GCModel model = new GCModel(true);
    private Chart chart = new Chart();
    private Ruler timestampRuler;
    private Ruler memoryRuler;
    private Ruler pauseRuler;
    private double scaleFactor = 1.0;
    private double runningTime;
    private double maxPause;
    private long footprint;
    private TotalYoungRenderer totalYoungRenderer;
    private TotalHeapRenderer totalHeapRenderer;
    private TotalTenuredRenderer totalTenuredRenderer;
    private IncLineRenderer incLineRenderer;
    private GCRectanglesRenderer gcRectanglesRenderer;
    private FullGCLineRenderer fullGCLineRenderer;
    private GCTimesRenderer gcTimesRenderer;
    private UsedHeapRenderer usedHeapRenderer;
    private boolean antiAlias;
    private TimeOffsetPanel timeOffsetPanel;

    public ModelChartImpl() {
        this.chart.setPreferredSize(new Dimension(0, 0));
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(21);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.usedHeapRenderer = new UsedHeapRenderer(this);
        this.chart.add((Component)this.usedHeapRenderer, gridBagConstraints);
        this.gcTimesRenderer = new GCTimesRenderer(this);
        this.chart.add((Component)this.gcTimesRenderer, gridBagConstraints);
        this.fullGCLineRenderer = new FullGCLineRenderer(this);
        this.chart.add((Component)this.fullGCLineRenderer, gridBagConstraints);
        this.gcRectanglesRenderer = new GCRectanglesRenderer(this);
        this.chart.add((Component)this.gcRectanglesRenderer, gridBagConstraints);
        this.incLineRenderer = new IncLineRenderer(this);
        this.chart.add((Component)this.incLineRenderer, gridBagConstraints);
        this.totalTenuredRenderer = new TotalTenuredRenderer(this);
        this.chart.add((Component)this.totalTenuredRenderer, gridBagConstraints);
        this.totalYoungRenderer = new TotalYoungRenderer(this);
        this.chart.add((Component)this.totalYoungRenderer, gridBagConstraints);
        this.totalHeapRenderer = new TotalHeapRenderer(this);
        this.chart.add((Component)this.totalHeapRenderer, gridBagConstraints);
        this.setViewportView(this.chart);
        JPanel rowHeaderPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        rowHeaderPanel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 3;
        constraints.weightx = 2.0;
        constraints.weighty = 1.0;
        constraints.gridheight = 2;
        constraints.gridx = 0;
        constraints.gridy = 1;
        this.memoryRuler = new Ruler(true, 0.0, this.model.getFootprint(), "K");
        this.pauseRuler = new Ruler(true, 0.0, this.model.getPause().getMax(), "s");
        layout.setConstraints(this.memoryRuler, constraints);
        rowHeaderPanel.add(this.memoryRuler);
        constraints.gridx = 1;
        layout.setConstraints(this.pauseRuler, constraints);
        rowHeaderPanel.add(this.pauseRuler);
        this.setRowHeaderView(rowHeaderPanel);
        this.setCorner("UPPER_LEFT_CORNER", new JPanel());
        this.setCorner("LOWER_LEFT_CORNER", new JPanel());
        TimeFormat dateFormatter = new TimeFormat();
        this.timestampRuler = new Ruler(false, 0.0, this.model.getRunningTime(), "", dateFormatter);
        this.setColumnHeaderView(this.timestampRuler);
        this.getViewport().addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                ModelChartImpl.this.chart.setSize(ModelChartImpl.this.chart.getPreferredSize());
                ModelChartImpl.this.memoryRuler.setSize((int)ModelChartImpl.this.memoryRuler.getPreferredSize().getWidth(), e.getComponent().getHeight());
                ModelChartImpl.this.pauseRuler.setSize((int)ModelChartImpl.this.pauseRuler.getPreferredSize().getWidth(), e.getComponent().getHeight());
                ModelChartImpl.this.timestampRuler.setSize((int)ModelChartImpl.this.chart.getPreferredSize().getWidth(), (int)ModelChartImpl.this.timestampRuler.getPreferredSize().getHeight());
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        });
        JPopupMenu popupMenu = new JPopupMenu();
        this.timeOffsetPanel = new TimeOffsetPanel(popupMenu);
        popupMenu.add(this.timeOffsetPanel);
        final JPopupMenu timestampRulerPopup = popupMenu;
        AbstractAction setOffsetAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (ModelChartImpl.this.timeOffsetPanel.isOffsetSet()) {
                    ModelChartImpl.this.timestampRuler.setOffset(ModelChartImpl.this.timeOffsetPanel.getDate().getTime() / 1000L);
                } else {
                    ModelChartImpl.this.timestampRuler.setOffset(0.0);
                }
                ModelChartImpl.this.timestampRuler.revalidate();
                ModelChartImpl.this.timestampRuler.repaint();
            }
        };
        this.timeOffsetPanel.setOkAction(setOffsetAction);
        this.timestampRuler.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.maybePopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.maybePopup(e);
            }

            public void maybePopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    if (ModelChartImpl.this.timestampRuler.getOffset() != 0.0) {
                        ModelChartImpl.this.timeOffsetPanel.setDate(new Date((long)ModelChartImpl.this.timestampRuler.getOffset() * 1000L));
                        ModelChartImpl.this.timeOffsetPanel.setOffsetSet(true);
                    } else {
                        long suggestedStartDate = ModelChartImpl.this.model.getLastModified();
                        if (ModelChartImpl.this.model.hasCorrectTimestamp()) {
                            suggestedStartDate -= (long)(ModelChartImpl.this.model.getRunningTime() * 1000.0);
                        }
                        ModelChartImpl.this.timeOffsetPanel.setDate(new Date(suggestedStartDate));
                        ModelChartImpl.this.timeOffsetPanel.setOffsetSet(false);
                    }
                    timestampRulerPopup.show(e.getComponent(), e.getX(), e.getY());
                    ModelChartImpl.this.timeOffsetPanel.requestFocus();
                }
            }
        });
    }

    public void invalidate() {
        super.invalidate();
        this.chart.invalidate();
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
        this.chart.setSize(this.chart.getPreferredSize());
        this.memoryRuler.setSize((int)this.memoryRuler.getPreferredSize().getWidth(), this.getViewport().getHeight());
        this.pauseRuler.setSize((int)this.pauseRuler.getPreferredSize().getWidth(), this.getViewport().getHeight());
        this.timestampRuler.setSize((int)((double)this.getViewport().getWidth() * this.getScaleFactor()), (int)this.timestampRuler.getPreferredSize().getHeight());
        this.repaint();
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean antiAlias) {
        this.antiAlias = antiAlias;
    }

    public boolean isShowTenured() {
        return this.totalTenuredRenderer.isVisible();
    }

    public void setShowTenured(boolean showTenured) {
        this.totalTenuredRenderer.setVisible(showTenured);
    }

    public boolean isShowYoung() {
        return this.totalYoungRenderer.isVisible();
    }

    public void setShowYoung(boolean showYoung) {
        this.totalYoungRenderer.setVisible(showYoung);
    }

    public boolean isShowGCTimesLine() {
        return this.gcTimesRenderer.isVisible();
    }

    public void setShowGCTimesLine(boolean showGCTimesLine) {
        this.gcTimesRenderer.setVisible(showGCTimesLine);
    }

    public boolean isShowGCTimesRectangles() {
        return this.gcRectanglesRenderer.isVisible();
    }

    public void setShowGCTimesRectangles(boolean showGCTimesRectangles) {
        this.gcRectanglesRenderer.setVisible(showGCTimesRectangles);
    }

    public boolean isShowFullGCLines() {
        return this.fullGCLineRenderer.isVisible();
    }

    public void setShowFullGCLines(boolean showFullGCLines) {
        this.fullGCLineRenderer.setVisible(showFullGCLines);
    }

    public boolean isShowIncGCLines() {
        return this.incLineRenderer.isVisible();
    }

    public void setShowIncGCLines(boolean showIncGCLines) {
        this.incLineRenderer.setVisible(showIncGCLines);
    }

    public boolean isShowTotalMemoryLine() {
        return this.totalHeapRenderer.isVisible();
    }

    public void setShowTotalMemoryLine(boolean showTotalMemoryLine) {
        this.totalHeapRenderer.setVisible(showTotalMemoryLine);
    }

    public boolean isShowUsedMemoryLine() {
        return this.usedHeapRenderer.isVisible();
    }

    public void setShowUsedMemoryLine(boolean showUsedMemoryLine) {
        this.usedHeapRenderer.setVisible(showUsedMemoryLine);
    }

    public void setModel(GCModel model) {
        this.model = model;
    }

    public GCModel getModel() {
        return this.model;
    }

    public void setRunningTime(double runningTime) {
        this.timestampRuler.setMaxUnit(runningTime);
        this.runningTime = runningTime;
        this.getRowHeader().revalidate();
        this.usedHeapRenderer.invalidate();
        this.chart.revalidate();
    }

    public void setFootprint(long footprint) {
        this.memoryRuler.setMaxUnit(footprint);
        this.footprint = footprint;
        this.getColumnHeader().revalidate();
        this.chart.revalidate();
    }

    public void setMaxPause(double maxPause) {
        this.pauseRuler.setMaxUnit(maxPause);
        this.maxPause = maxPause;
        this.getColumnHeader().revalidate();
        this.chart.revalidate();
    }

    public long getFootprint() {
        return this.footprint;
    }

    public double getMaxPause() {
        return this.maxPause;
    }

    private class Ruler
    extends JPanel {
        private boolean vertical;
        private double minUnit;
        private double maxUnit;
        private final double log10 = Math.log(10.0);
        private Font font;
        private Format formatter;
        private String longestString;
        private String unitName;
        private int minHalfDistance;
        private double offset;

        public Ruler(boolean vertical, double minUnit, double maxUnit, String unitName) {
            this(vertical, minUnit, maxUnit, unitName, NumberFormat.getInstance());
        }

        public Ruler(boolean vertical, double minUnit, double maxUnit, String unitName, Format formatter) {
            this.setUnitName(unitName);
            this.formatter = formatter;
            this.setVertical(vertical);
            this.setMinUnit(minUnit);
            this.setMaxUnit(maxUnit);
            this.font = new Font("sans-serif", 0, 10);
        }

        public void setSize(int width, int height) {
            super.setSize(width, height);
            this.configureFormatter();
        }

        public Dimension getPreferredSize() {
            FontMetrics fm = this.getToolkit().getFontMetrics(this.font);
            this.configureFormatter();
            int minWidth = fm.stringWidth(this.longestString) + 5;
            Dimension bestSize = null;
            if (this.isVertical()) {
                bestSize = new Dimension(minWidth, this.getHeight());
            } else {
                bestSize = new Dimension((int)(ModelChartImpl.this.runningTime * ModelChartImpl.this.getScaleFactor()), fm.getHeight());
                this.minHalfDistance = minWidth;
            }
            return bestSize;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        protected void paintComponent(Graphics g) {
            super.paintComponents(g);
            this.configureFormatter();
            double lineDistance = this.getLineDistance();
            Rectangle clip = g.getClipBounds();
            g.clearRect(clip.x, clip.y, clip.width, clip.height);
            g.setColor(Color.black);
            if (this.isVertical()) {
                double line;
                double halfLineDistance = lineDistance / 2.0;
                for (line = (double)this.getHeight() - this.minUnit % lineDistance; line > 0.0; line -= lineDistance) {
                    g.drawLine(0, (int)line, this.getWidth(), (int)line);
                }
                for (line = (double)this.getHeight() - (this.minUnit - halfLineDistance) % lineDistance; line > 0.0; line -= lineDistance) {
                    int inset = 3;
                    g.drawLine(inset, (int)line, this.getWidth() - inset, (int)line);
                }
                String number = null;
                for (double line2 = (double)this.getHeight() - this.minUnit % lineDistance; line2 > 0.0; line2 -= lineDistance) {
                    g.setFont(this.font);
                    String newNumber = this.format(((double)this.getHeight() - line2) / this.getPixelsPerUnit()) + this.getUnitName();
                    if (!newNumber.equals(number)) {
                        g.drawString(newNumber, 2, (int)line2 - 2);
                    }
                    number = newNumber;
                }
            } else {
                double line;
                double halfLineDistance = lineDistance / 2.0;
                for (line = this.minUnit % lineDistance; line < (double)this.getWidth(); line += lineDistance) {
                    g.drawLine((int)line, 0, (int)line, this.getHeight());
                }
                for (line = (this.minUnit - halfLineDistance) % lineDistance; line < (double)this.getWidth(); line += lineDistance) {
                    int inset = 3;
                    g.drawLine((int)line, inset, (int)line, this.getHeight() - inset);
                }
                String number = null;
                for (double line3 = this.minUnit % lineDistance; line3 < (double)this.getWidth(); line3 += lineDistance) {
                    g.setFont(this.font);
                    String newNumber = this.format(line3 / this.getPixelsPerUnit()) + this.getUnitName();
                    if (!newNumber.equals(number)) {
                        g.drawString(newNumber, (int)line3 + 3, this.getHeight() - 2);
                    }
                    number = newNumber;
                }
            }
        }

        public double getOffset() {
            return this.offset;
        }

        public void setOffset(double offset) {
            this.offset = offset;
        }

        public void setFormatter(Format formatter) {
            this.formatter = formatter;
        }

        private String format(double val) {
            double offsetValue = val + this.offset;
            String s = null;
            if (this.formatter instanceof NumberFormat) {
                s = ((NumberFormat)this.formatter).format(offsetValue);
            } else if (this.formatter instanceof DateFormat) {
                Date date = new Date((long)offsetValue * 1000L);
                s = ((DateFormat)this.formatter).format(date);
            }
            return s;
        }

        private double getLineDistance() {
            if (this.formatter instanceof NumberFormat) {
                return this.getNumberLineDistance();
            }
            if (this.formatter instanceof DateFormat) {
                return this.getDateLineDistance();
            }
            return 0.0;
        }

        private double getDateLineDistance() {
            double lineDistance;
            block18: {
                block17: {
                    lineDistance = this.getPixelsPerUnit();
                    if (!this.isVertical()) break block17;
                    if (lineDistance < 20.0) {
                        lineDistance *= 10.0;
                    }
                    if (lineDistance < 20.0) {
                        lineDistance *= 3.0;
                    }
                    if (lineDistance < 20.0) {
                        lineDistance *= 2.0;
                    }
                    if (lineDistance < 20.0) {
                        lineDistance *= 2.0;
                    }
                    if (lineDistance < 20.0) {
                        lineDistance *= 5.0;
                    }
                    if (lineDistance < 20.0) {
                        lineDistance *= 2.0;
                    }
                    if (lineDistance < 20.0) {
                        lineDistance *= 3.0;
                    }
                    if (!(lineDistance < 20.0)) break block18;
                    double oneHourDistance = lineDistance;
                    while (lineDistance < 20.0) {
                        lineDistance += oneHourDistance;
                    }
                    break block18;
                }
                if (lineDistance < (double)(this.minHalfDistance * 2)) {
                    lineDistance *= 10.0;
                }
                if (lineDistance < (double)(this.minHalfDistance * 2)) {
                    lineDistance *= 3.0;
                }
                if (lineDistance < (double)(this.minHalfDistance * 2)) {
                    lineDistance *= 2.0;
                }
                if (lineDistance < (double)(this.minHalfDistance * 2)) {
                    lineDistance *= 2.0;
                }
                if (lineDistance < (double)(this.minHalfDistance * 2)) {
                    lineDistance *= 5.0;
                }
                if (lineDistance < (double)(this.minHalfDistance * 2)) {
                    lineDistance *= 2.0;
                }
                if (lineDistance < (double)(this.minHalfDistance * 2)) {
                    lineDistance *= 3.0;
                }
                if (lineDistance < (double)(this.minHalfDistance * 2)) {
                    double oneHourDistance = lineDistance;
                    while (lineDistance < (double)(this.minHalfDistance * 2)) {
                        lineDistance += oneHourDistance;
                    }
                }
            }
            return lineDistance;
        }

        private double getNumberLineDistance() {
            double lineDistance;
            double log10PixelPerUnit = Math.log(this.getPixelsPerUnit()) / this.log10;
            if (this.isVertical()) {
                for (lineDistance = this.getPixelsPerUnit() * Math.pow(10.0, Math.ceil(-log10PixelPerUnit) + 1.0); lineDistance < 20.0; lineDistance *= 10.0) {
                }
            } else {
                while (lineDistance < (double)(this.minHalfDistance * 2)) {
                    lineDistance *= 10.0;
                }
            }
            return lineDistance;
        }

        private double getPixelsPerUnit() {
            double pixelPerUnit = this.isVertical() ? (double)this.getHeight() / (this.maxUnit - this.minUnit) : ModelChartImpl.this.runningTime * ModelChartImpl.this.getScaleFactor() / (this.maxUnit - this.minUnit);
            return pixelPerUnit;
        }

        public double getMinUnit() {
            return this.minUnit;
        }

        public void setMinUnit(double minUnit) {
            this.minUnit = minUnit;
            this.configureFormatter();
        }

        public double getMaxUnit() {
            return this.maxUnit;
        }

        public void setMaxUnit(double maxUnit) {
            this.maxUnit = maxUnit;
            this.configureFormatter();
        }

        public void configureFormatter() {
            if (this.formatter instanceof NumberFormat) {
                double digits = Math.log(this.maxUnit) / this.log10;
                if (digits < 1.0) {
                    ((NumberFormat)this.formatter).setMaximumFractionDigits((int)Math.abs(digits) + 2);
                    ((NumberFormat)this.formatter).setMinimumFractionDigits((int)Math.abs(digits) + 2);
                } else {
                    ((NumberFormat)this.formatter).setMaximumFractionDigits(0);
                    ((NumberFormat)this.formatter).setMinimumFractionDigits(0);
                }
            }
            this.longestString = this.format(this.maxUnit);
            if (this.unitName != null) {
                this.longestString = this.longestString + this.unitName;
            }
            this.invalidate();
        }

        public boolean isVertical() {
            return this.vertical;
        }

        public void setVertical(boolean vertical) {
            this.vertical = vertical;
        }

        public String getUnitName() {
            return this.unitName;
        }

        public void setUnitName(String unitName) {
            this.unitName = unitName;
        }
    }

    private class Chart
    extends JPanel {
        private double yMemScaleFactor = 1.0;

        public Chart() {
            this.setBackground(Color.white);
            this.setLayout(new GridBagLayout());
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.scaleX(ModelChartImpl.this.runningTime), ModelChartImpl.this.getViewport().getHeight());
        }

        public void setSize(int width, int height) {
            super.setSize(width, height);
            this.computeScaleFactors();
        }

        public void computeScaleFactors() {
            this.yMemScaleFactor = (double)ModelChartImpl.this.getViewport().getHeight() / (double)ModelChartImpl.this.footprint;
        }

        private void drawUsedTenuredPolygon(Graphics g) {
            Polygon tenured = this.computeUsedTenuredPolygon();
            g.setColor(Color.ORANGE.darker());
            g.fillPolygon(tenured);
        }

        private Polygon computeUsedTenuredPolygon() {
            Polygon polygon = new Polygon();
            int zeroY = this.memScaleY(0L);
            polygon.addPoint(0, zeroY);
            Iterator i = ModelChartImpl.this.model.getGCEvents();
            while (i.hasNext()) {
                AbstractGCEvent event = (AbstractGCEvent)i.next();
                Iterator iterator = event.details();
                while (iterator.hasNext()) {
                    GCEvent detailEvent = (GCEvent)iterator.next();
                    if (detailEvent.getType().getGeneration() != AbstractGCEvent.Generation.TENURED) continue;
                    polygon.addPoint(this.scaleX(detailEvent.getTimestamp()), this.memScaleY(detailEvent.getPreUsed()));
                    polygon.addPoint(this.scaleX(detailEvent.getTimestamp() + detailEvent.getPause()), this.memScaleY(detailEvent.getPostUsed()));
                }
            }
            polygon.addPoint(this.scaleX(ModelChartImpl.this.model.getRunningTime()), zeroY);
            return polygon;
        }

        private int scaleX(double d) {
            return (int)(d * ModelChartImpl.this.getScaleFactor());
        }

        private int memScaleY(long l) {
            return this.getHeight() - (int)((double)l * this.yMemScaleFactor);
        }
    }
}

