/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer;

import com.tagtraum.perf.gcviewer.GCModel;
import com.tagtraum.perf.gcviewer.util.MemoryFormat;
import com.tagtraum.perf.gcviewer.util.TimeFormat;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ModelPanel
extends JTabbedPane {
    private static ResourceBundle localStrings = ResourceBundle.getBundle("com.tagtraum.perf.gcviewer.localStrings");
    private NumberFormat pauseFormatter = NumberFormat.getInstance();
    private DateFormat totalTimeFormatter;
    private NumberFormat throughputFormatter;
    private NumberFormat footprintFormatter;
    private NumberFormat footprintSlopeFormatter;
    private NumberFormat freedMemoryPerMinFormatter;
    private NumberFormat sigmaFormatter;
    private NumberFormat percentFormatter;
    private NumberFormat gcTimeFormatter;
    private MemoryFormat sigmaMemoryFormatter;
    private SummaryTab summaryTab;
    private MemoryTab memoryTab;
    private PauseTab pauseTab;

    public ModelPanel() {
        this.pauseFormatter.setMaximumFractionDigits(5);
        this.totalTimeFormatter = new TimeFormat();
        this.gcTimeFormatter = NumberFormat.getInstance();
        this.gcTimeFormatter.setMaximumFractionDigits(2);
        this.throughputFormatter = NumberFormat.getInstance();
        this.throughputFormatter.setMaximumFractionDigits(2);
        this.footprintFormatter = new MemoryFormat();
        this.sigmaFormatter = NumberFormat.getInstance();
        this.sigmaFormatter.setMaximumFractionDigits(0);
        this.sigmaMemoryFormatter = new MemoryFormat();
        this.footprintSlopeFormatter = new MemoryFormat();
        this.freedMemoryPerMinFormatter = new MemoryFormat();
        this.percentFormatter = NumberFormat.getInstance();
        this.percentFormatter.setMaximumFractionDigits(1);
        this.percentFormatter.setMinimumFractionDigits(1);
        this.summaryTab = new SummaryTab();
        this.addTab(localStrings.getString("data_panel_tab_summary"), this.summaryTab);
        this.memoryTab = new MemoryTab();
        this.addTab(localStrings.getString("data_panel_tab_memory"), this.memoryTab);
        this.pauseTab = new PauseTab();
        this.addTab(localStrings.getString("data_panel_tab_pause"), this.pauseTab);
    }

    private String sigmaMemoryFormat(double value) {
        if (Double.isNaN(value)) {
            return "NaN";
        }
        return this.sigmaMemoryFormatter.format(value);
    }

    public void setModel(GCModel model) {
        this.memoryTab.setModel(model);
        this.pauseTab.setModel(model);
        this.summaryTab.setModel(model);
        this.repaint();
    }

    private boolean isSignificant(double average, double standardDeviation) {
        return average - standardDeviation > 0.75 * average;
    }

    private class SummaryTab
    extends JPanel {
        private JLabel footprintValue;
        private JLabel accumPauseValue;
        private JLabel throughputValue;
        private JLabel totalTimeValue;
        private JLabel freedMemoryPerMinValue;
        private JLabel freedMemoryValue;
        private JLabel fullGCPerformanceValue;
        private JLabel gcPerformanceValue;

        public SummaryTab() {
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 17;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.insets = new Insets(0, 3, 0, 3);
            constraints.gridy = -1;
            this.setLayout(layout);
            JLabel footprintLabel = new JLabel(localStrings.getString("data_panel_footprint"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(footprintLabel, constraints);
            this.add(footprintLabel);
            this.footprintValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.footprintValue, constraints);
            this.add(this.footprintValue);
            JLabel freedMemoryLabel = new JLabel(localStrings.getString("data_panel_freedmemory"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(freedMemoryLabel, constraints);
            this.add(freedMemoryLabel);
            this.freedMemoryValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.freedMemoryValue, constraints);
            this.add(this.freedMemoryValue);
            JLabel freedMemoryPerMinLabel = new JLabel(localStrings.getString("data_panel_freedmemorypermin"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(freedMemoryPerMinLabel, constraints);
            this.add(freedMemoryPerMinLabel);
            this.freedMemoryPerMinValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.freedMemoryPerMinValue, constraints);
            this.add(this.freedMemoryPerMinValue);
            JLabel totalTimeLabel = new JLabel(localStrings.getString("data_panel_total_time"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(totalTimeLabel, constraints);
            this.add(totalTimeLabel);
            this.totalTimeValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.totalTimeValue, constraints);
            this.add(this.totalTimeValue);
            JLabel accumPauseLabel = new JLabel(localStrings.getString("data_panel_acc_pauses"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(accumPauseLabel, constraints);
            this.add(accumPauseLabel);
            this.accumPauseValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.accumPauseValue, constraints);
            this.add(this.accumPauseValue);
            JLabel throughputLabel = new JLabel(localStrings.getString("data_panel_throughput"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(throughputLabel, constraints);
            this.add(throughputLabel);
            this.throughputValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.throughputValue, constraints);
            this.add(this.throughputValue);
            JLabel fullGCPerformanceLabel = new JLabel(localStrings.getString("data_panel_performance_fullgc"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(fullGCPerformanceLabel, constraints);
            this.add(fullGCPerformanceLabel);
            this.fullGCPerformanceValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.fullGCPerformanceValue, constraints);
            this.add(this.fullGCPerformanceValue);
            JLabel gcPerformanceLabel = new JLabel(localStrings.getString("data_panel_performance_gc"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(gcPerformanceLabel, constraints);
            this.add(gcPerformanceLabel);
            this.gcPerformanceValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.gcPerformanceValue, constraints);
            this.add(this.gcPerformanceValue);
        }

        public void setModel(GCModel model) {
            this.accumPauseValue.setText(ModelPanel.this.gcTimeFormatter.format(model.getPause().getSum()) + "s");
            this.footprintValue.setText(ModelPanel.this.footprintFormatter.format(model.getFootprint()));
            this.freedMemoryValue.setText(ModelPanel.this.footprintFormatter.format(model.getFreedMemory()));
            if (model.hasCorrectTimestamp()) {
                this.throughputValue.setText(ModelPanel.this.throughputFormatter.format(model.getThroughput()) + "%");
                this.totalTimeValue.setText(ModelPanel.this.totalTimeFormatter.format(new Date((long)model.getRunningTime() * 1000L)));
                this.freedMemoryPerMinValue.setText(ModelPanel.this.freedMemoryPerMinFormatter.format((double)model.getFreedMemory() / model.getRunningTime() * 60.0) + "/min");
            } else {
                this.throughputValue.setText("n.a.");
                this.totalTimeValue.setText("n.a.");
                this.freedMemoryPerMinValue.setText("n.a.");
            }
            boolean gcDataAvailable = model.getGCPause().getN() > 0;
            this.gcPerformanceValue.setEnabled(gcDataAvailable);
            if (gcDataAvailable) {
                this.gcPerformanceValue.setText(ModelPanel.this.footprintFormatter.format((double)model.getFreedMemoryByGC().getSum() / model.getGCPause().getSum()) + "/s");
            } else {
                this.gcPerformanceValue.setText("n.a.");
            }
            boolean fullGCDataAvailable = model.getFullGCPause().getN() > 0;
            this.fullGCPerformanceValue.setEnabled(fullGCDataAvailable);
            if (fullGCDataAvailable) {
                this.fullGCPerformanceValue.setText(ModelPanel.this.footprintFormatter.format((double)model.getFreedMemoryByFullGC().getSum() / model.getFullGCPause().getSum()) + "/s");
            } else {
                this.fullGCPerformanceValue.setText("n.a.");
            }
        }
    }

    private class PauseTab
    extends JPanel {
        private JLabel fullGCPauseValue;
        private JLabel gcPauseValue;
        private JLabel avgFullGCPauseValue;
        private JLabel avgGCPauseValue;
        private JLabel avgPauseValue;
        private JLabel minPauseValue;
        private JLabel maxPauseValue;
        private JLabel accumPauseValue;

        public PauseTab() {
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 17;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.insets = new Insets(0, 3, 0, 3);
            constraints.gridy = -1;
            this.setLayout(layout);
            JLabel accumPauseLabel = new JLabel(localStrings.getString("data_panel_acc_pauses"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(accumPauseLabel, constraints);
            this.add(accumPauseLabel);
            this.accumPauseValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.accumPauseValue, constraints);
            this.add(this.accumPauseValue);
            JLabel fullGCPauseLabel = new JLabel(localStrings.getString("data_panel_acc_fullgcpauses"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(fullGCPauseLabel, constraints);
            this.add(fullGCPauseLabel);
            this.fullGCPauseValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.fullGCPauseValue, constraints);
            this.add(this.fullGCPauseValue);
            JLabel gcPauseLabel = new JLabel(localStrings.getString("data_panel_acc_gcpauses"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(gcPauseLabel, constraints);
            this.add(gcPauseLabel);
            this.gcPauseValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.gcPauseValue, constraints);
            this.add(this.gcPauseValue);
            JLabel minPauseLabel = new JLabel(localStrings.getString("data_panel_min_pause"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(minPauseLabel, constraints);
            this.add(minPauseLabel);
            this.minPauseValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.minPauseValue, constraints);
            this.add(this.minPauseValue);
            JLabel maxPauseLabel = new JLabel(localStrings.getString("data_panel_max_pause"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(maxPauseLabel, constraints);
            this.add(maxPauseLabel);
            this.maxPauseValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.maxPauseValue, constraints);
            this.add(this.maxPauseValue);
            JLabel avgPauseLabel = new JLabel(localStrings.getString("data_panel_avg_pause"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(avgPauseLabel, constraints);
            this.add(avgPauseLabel);
            this.avgPauseValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.avgPauseValue, constraints);
            this.add(this.avgPauseValue);
            JLabel avgFullGCPauseLabel = new JLabel(localStrings.getString("data_panel_avg_fullgcpause"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(avgFullGCPauseLabel, constraints);
            this.add(avgFullGCPauseLabel);
            this.avgFullGCPauseValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.avgFullGCPauseValue, constraints);
            this.add(this.avgFullGCPauseValue);
            JLabel avgGCPauseLabel = new JLabel(localStrings.getString("data_panel_avg_gcpause"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(avgGCPauseLabel, constraints);
            this.add(avgGCPauseLabel);
            this.avgGCPauseValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.avgGCPauseValue, constraints);
            this.add(this.avgGCPauseValue);
        }

        public void setModel(GCModel model) {
            boolean pauseDataAvailable = model.getPause().getN() != 0;
            boolean gcDataAvailable = model.getGCPause().getN() > 0;
            boolean fullGCDataAvailable = model.getFullGCPause().getN() > 0;
            this.avgPauseValue.setEnabled(pauseDataAvailable);
            this.minPauseValue.setEnabled(pauseDataAvailable);
            this.maxPauseValue.setEnabled(pauseDataAvailable);
            this.avgGCPauseValue.setEnabled(pauseDataAvailable);
            this.avgFullGCPauseValue.setEnabled(pauseDataAvailable);
            if (pauseDataAvailable) {
                this.avgPauseValue.setEnabled(ModelPanel.this.isSignificant(model.getPause().average(), model.getPause().standardDeviation()));
                this.avgPauseValue.setText(ModelPanel.this.pauseFormatter.format(model.getPause().average()) + "s (\u03c3=" + ModelPanel.this.pauseFormatter.format(model.getPause().standardDeviation()) + ")");
                this.minPauseValue.setText(ModelPanel.this.pauseFormatter.format(model.getPause().getMin()) + "s");
                this.maxPauseValue.setText(ModelPanel.this.pauseFormatter.format(model.getPause().getMax()) + "s");
                this.avgGCPauseValue.setEnabled(gcDataAvailable);
                if (gcDataAvailable) {
                    this.avgGCPauseValue.setEnabled(ModelPanel.this.isSignificant(model.getGCPause().average(), model.getGCPause().standardDeviation()));
                    this.avgGCPauseValue.setText(ModelPanel.this.pauseFormatter.format(model.getGCPause().average()) + "s (\u03c3=" + ModelPanel.this.pauseFormatter.format(model.getGCPause().standardDeviation()) + ")");
                } else {
                    this.avgGCPauseValue.setText("n.a.");
                }
                this.avgFullGCPauseValue.setEnabled(fullGCDataAvailable);
                if (fullGCDataAvailable) {
                    this.avgFullGCPauseValue.setEnabled(ModelPanel.this.isSignificant(model.getFullGCPause().average(), model.getPause().standardDeviation()));
                    this.avgFullGCPauseValue.setText(ModelPanel.this.pauseFormatter.format(model.getFullGCPause().average()) + "s (\u03c3=" + ModelPanel.this.pauseFormatter.format(model.getFullGCPause().standardDeviation()) + ")");
                } else {
                    this.avgFullGCPauseValue.setText("n.a.");
                }
            } else {
                this.avgPauseValue.setText("n.a.");
                this.minPauseValue.setText("n.a.");
                this.maxPauseValue.setText("n.a.");
                this.avgGCPauseValue.setText("n.a.");
                this.avgFullGCPauseValue.setText("n.a.");
            }
            this.accumPauseValue.setText(ModelPanel.this.gcTimeFormatter.format(model.getPause().getSum()) + "s");
            this.fullGCPauseValue.setText(ModelPanel.this.gcTimeFormatter.format(model.getFullGCPause().getSum()) + "s (" + ModelPanel.this.percentFormatter.format(model.getFullGCPause().getSum() * 100.0 / model.getPause().getSum()) + "%)");
            this.gcPauseValue.setText(ModelPanel.this.gcTimeFormatter.format(model.getGCPause().getSum()) + "s (" + ModelPanel.this.percentFormatter.format(model.getGCPause().getSum() * 100.0 / model.getPause().getSum()) + "%)");
        }
    }

    private class MemoryTab
    extends JPanel {
        private JLabel footprintAfterFullGCValue;
        private JLabel footprintAfterGCValue;
        private JLabel slopeAfterFullGCValue;
        private JLabel slopeAfterGCValue;
        private JLabel freedMemoryByFullGCValue;
        private JLabel avgFreedMemoryByFullGCValue;
        private JLabel freedMemoryByGCValue;
        private JLabel avgFreedMemoryByGCValue;
        private JLabel avgRelativePostGCIncValue;
        private JLabel avgRelativePostFullGCIncValue;
        private JLabel footprintValue;
        private JLabel freedMemoryValue;

        public MemoryTab() {
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 17;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.insets = new Insets(0, 3, 0, 3);
            constraints.gridy = -1;
            this.setLayout(layout);
            JLabel footprintLabel = new JLabel(localStrings.getString("data_panel_footprint"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(footprintLabel, constraints);
            this.add(footprintLabel);
            this.footprintValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.footprintValue, constraints);
            this.add(this.footprintValue);
            JLabel footprintAfterFullGCLabel = new JLabel(localStrings.getString("data_panel_footprintafterfullgc"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(footprintAfterFullGCLabel, constraints);
            this.add(footprintAfterFullGCLabel);
            this.footprintAfterFullGCValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.footprintAfterFullGCValue, constraints);
            this.add(this.footprintAfterFullGCValue);
            JLabel footprintAfterGCLabel = new JLabel(localStrings.getString("data_panel_footprintaftergc"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(footprintAfterGCLabel, constraints);
            this.add(footprintAfterGCLabel);
            this.footprintAfterGCValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.footprintAfterGCValue, constraints);
            this.add(this.footprintAfterGCValue);
            JLabel freedMemoryLabel = new JLabel(localStrings.getString("data_panel_freedmemory"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(freedMemoryLabel, constraints);
            this.add(freedMemoryLabel);
            this.freedMemoryValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.freedMemoryValue, constraints);
            this.add(this.freedMemoryValue);
            JLabel freedMemoryByFullGCLabel = new JLabel(localStrings.getString("data_panel_freedmemorybyfullgc"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(freedMemoryByFullGCLabel, constraints);
            this.add(freedMemoryByFullGCLabel);
            this.freedMemoryByFullGCValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.freedMemoryByFullGCValue, constraints);
            this.add(this.freedMemoryByFullGCValue);
            JLabel freedMemoryByGCLabel = new JLabel(localStrings.getString("data_panel_freedmemorybygc"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(freedMemoryByGCLabel, constraints);
            this.add(freedMemoryByGCLabel);
            this.freedMemoryByGCValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.freedMemoryByGCValue, constraints);
            this.add(this.freedMemoryByGCValue);
            JLabel avgFreedMemoryByFullGCLabel = new JLabel(localStrings.getString("data_panel_avgfreedmemorybyfullgc"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(avgFreedMemoryByFullGCLabel, constraints);
            this.add(avgFreedMemoryByFullGCLabel);
            this.avgFreedMemoryByFullGCValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.avgFreedMemoryByFullGCValue, constraints);
            this.add(this.avgFreedMemoryByFullGCValue);
            JLabel avgFreedMemoryByGCLabel = new JLabel(localStrings.getString("data_panel_avgfreedmemorybygc"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(avgFreedMemoryByGCLabel, constraints);
            this.add(avgFreedMemoryByGCLabel);
            this.avgFreedMemoryByGCValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.avgFreedMemoryByGCValue, constraints);
            this.add(this.avgFreedMemoryByGCValue);
            JLabel avgRelativePostFullGCIncLabel = new JLabel(localStrings.getString("data_panel_avgrelativepostfullgcincrease"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(avgRelativePostFullGCIncLabel, constraints);
            this.add(avgRelativePostFullGCIncLabel);
            this.avgRelativePostFullGCIncValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.avgRelativePostFullGCIncValue, constraints);
            this.add(this.avgRelativePostFullGCIncValue);
            JLabel avgRelativepostGCIncLabel = new JLabel(localStrings.getString("data_panel_avgrelativepostgcincrease"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(avgRelativepostGCIncLabel, constraints);
            this.add(avgRelativepostGCIncLabel);
            this.avgRelativePostGCIncValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.avgRelativePostGCIncValue, constraints);
            this.add(this.avgRelativePostGCIncValue);
            JLabel slopeAfterFullGCLabel = new JLabel(localStrings.getString("data_panel_slopeafterfullgc"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(slopeAfterFullGCLabel, constraints);
            this.add(slopeAfterFullGCLabel);
            this.slopeAfterFullGCValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.slopeAfterFullGCValue, constraints);
            this.add(this.slopeAfterFullGCValue);
            JLabel slopeAfterGCLabel = new JLabel(localStrings.getString("data_panel_slopeaftergc"));
            ++constraints.gridy;
            constraints.gridx = 0;
            layout.setConstraints(slopeAfterGCLabel, constraints);
            this.add(slopeAfterGCLabel);
            this.slopeAfterGCValue = new JLabel("", 4);
            constraints.gridx = 1;
            layout.setConstraints(this.slopeAfterGCValue, constraints);
            this.add(this.slopeAfterGCValue);
        }

        public void setModel(GCModel model) {
            this.footprintValue.setText(ModelPanel.this.footprintFormatter.format(model.getFootprint()));
            boolean fullGCDataVailable = model.getFootprintAfterFullGC().getN() != 0;
            boolean fullGCSlopeDataVailable = model.getFootprintAfterFullGC().getN() > 1;
            this.footprintAfterFullGCValue.setEnabled(fullGCDataVailable);
            this.slopeAfterFullGCValue.setEnabled(fullGCDataVailable);
            this.freedMemoryByFullGCValue.setEnabled(fullGCDataVailable);
            this.avgFreedMemoryByFullGCValue.setEnabled(fullGCDataVailable);
            this.avgRelativePostFullGCIncValue.setEnabled(fullGCDataVailable);
            if (!fullGCDataVailable) {
                this.footprintAfterFullGCValue.setText("n.a.");
                this.slopeAfterFullGCValue.setText("n.a.");
                this.freedMemoryByFullGCValue.setText("n.a.");
                this.avgFreedMemoryByFullGCValue.setText("n.a.");
            } else {
                this.footprintAfterFullGCValue.setText(ModelPanel.this.footprintFormatter.format(model.getFootprintAfterFullGC().average()) + " (\u03c3=" + ModelPanel.this.sigmaMemoryFormat(model.getFootprintAfterFullGC().standardDeviation()) + ")");
                this.footprintAfterFullGCValue.setEnabled(ModelPanel.this.isSignificant(model.getFootprintAfterFullGC().average(), model.getFootprintAfterFullGC().standardDeviation()));
                this.freedMemoryByFullGCValue.setText(ModelPanel.this.footprintFormatter.format(model.getFreedMemoryByFullGC().getSum()) + " (" + ModelPanel.this.percentFormatter.format((double)model.getFreedMemoryByFullGC().getSum() * 100.0 / (double)model.getFreedMemory()) + "%)");
                this.avgFreedMemoryByFullGCValue.setText(ModelPanel.this.footprintFormatter.format(model.getFreedMemoryByFullGC().average()) + "/coll (\u03c3=" + ModelPanel.this.sigmaMemoryFormat(model.getFreedMemoryByFullGC().standardDeviation()) + ")");
                this.avgFreedMemoryByFullGCValue.setEnabled(ModelPanel.this.isSignificant(model.getFreedMemoryByFullGC().average(), model.getFreedMemoryByFullGC().standardDeviation()));
                if (fullGCSlopeDataVailable) {
                    this.slopeAfterFullGCValue.setText(ModelPanel.this.footprintSlopeFormatter.format(model.getPostFullGCSlope().slope()) + "/s");
                    this.avgRelativePostFullGCIncValue.setText(ModelPanel.this.footprintSlopeFormatter.format(model.getRelativePostFullGCIncrease().slope()) + "/coll");
                } else {
                    this.slopeAfterFullGCValue.setText("n.a.");
                    this.avgRelativePostFullGCIncValue.setText("n.a.");
                }
            }
            boolean gcDataAvailable = model.getFootprintAfterGC().getN() != 0;
            this.footprintAfterGCValue.setEnabled(gcDataAvailable);
            this.slopeAfterGCValue.setEnabled(gcDataAvailable && fullGCDataVailable);
            this.freedMemoryByGCValue.setEnabled(gcDataAvailable);
            this.avgFreedMemoryByGCValue.setEnabled(gcDataAvailable);
            this.avgRelativePostGCIncValue.setEnabled(gcDataAvailable && fullGCDataVailable);
            if (!gcDataAvailable) {
                this.footprintAfterGCValue.setText("n.a.");
                this.slopeAfterGCValue.setText("n.a.");
                this.freedMemoryByGCValue.setText("n.a.");
                this.avgFreedMemoryByGCValue.setText("n.a.");
                this.avgRelativePostGCIncValue.setText("n.a.");
            } else {
                this.footprintAfterGCValue.setText(ModelPanel.this.footprintFormatter.format(model.getFootprintAfterGC().average()) + " (\u03c3=" + ModelPanel.this.sigmaMemoryFormat(model.getFootprintAfterGC().standardDeviation()) + ")");
                this.footprintAfterGCValue.setEnabled(ModelPanel.this.isSignificant(model.getFootprintAfterGC().average(), model.getFootprintAfterGC().standardDeviation()));
                if (fullGCDataVailable && model.getRelativePostGCIncrease().getN() != 0) {
                    this.slopeAfterGCValue.setText(ModelPanel.this.footprintSlopeFormatter.format(model.getPostGCSlope()) + "/s");
                    this.avgRelativePostGCIncValue.setText(ModelPanel.this.footprintSlopeFormatter.format(model.getRelativePostGCIncrease().average()) + "/coll");
                } else {
                    this.slopeAfterGCValue.setText("n.a.");
                    this.avgRelativePostGCIncValue.setText("n.a.");
                    this.slopeAfterGCValue.setEnabled(false);
                    this.avgRelativePostGCIncValue.setEnabled(false);
                }
                this.freedMemoryByGCValue.setText(ModelPanel.this.footprintFormatter.format(model.getFreedMemoryByGC().getSum()) + " (" + ModelPanel.this.percentFormatter.format((double)model.getFreedMemoryByGC().getSum() * 100.0 / (double)model.getFreedMemory()) + "%)");
                this.avgFreedMemoryByGCValue.setText(ModelPanel.this.footprintFormatter.format(model.getFreedMemoryByGC().average()) + "/coll (\u03c3=" + ModelPanel.this.sigmaMemoryFormat(model.getFreedMemoryByGC().standardDeviation()) + ")");
                this.avgFreedMemoryByGCValue.setEnabled(ModelPanel.this.isSignificant(model.getFreedMemoryByGC().average(), model.getFreedMemoryByGC().standardDeviation()));
            }
            this.freedMemoryValue.setText(ModelPanel.this.footprintFormatter.format(model.getFreedMemory()));
        }
    }
}

