/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer;

import com.tagtraum.perf.gcviewer.RecentURLEvent;
import com.tagtraum.perf.gcviewer.RecentURLsListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RecentURLsModel {
    private int maxElements = 10;
    private List urlSetList = new ArrayList();
    private List listeners = new ArrayList();
    private Set allURLs = new HashSet();

    public void addRecentURLsListener(RecentURLsListener recentURLsListener) {
        this.listeners.add(recentURLsListener);
    }

    protected void fireAddEvent(int position, URLSet urlSet) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((RecentURLsListener)this.listeners.get(i)).add(new RecentURLEvent(this, position, urlSet));
        }
    }

    protected void fireRemoveEvent(int position) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((RecentURLsListener)this.listeners.get(i)).remove(new RecentURLEvent(this, position));
        }
    }

    public List getURLsStartingWith(String start) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator urls = this.allURLs.iterator();
        while (urls.hasNext()) {
            String url = urls.next().toString();
            if (!url.startsWith(start)) continue;
            result.add(url);
        }
        Collections.sort(result);
        return result;
    }

    public void add(URL[] urls) {
        block2: {
            URLSet urlSet;
            block1: {
                this.allURLs.addAll(Arrays.asList(urls));
                urlSet = new URLSet(urls);
                if (this.urlSetList.contains(urlSet)) break block1;
                this.urlSetList.add(0, urlSet);
                this.fireAddEvent(0, urlSet);
                if (this.urlSetList.size() <= this.maxElements) break block2;
                this.urlSetList.remove(this.maxElements - 1);
                this.fireRemoveEvent(this.maxElements - 1);
                break block2;
            }
            int max = this.urlSetList.size();
            for (int i = 0; i < max; ++i) {
                URLSet existingURLSet = (URLSet)this.urlSetList.get(i);
                if (!urlSet.equals(existingURLSet)) continue;
                this.urlSetList.remove(i);
                this.fireRemoveEvent(i);
                this.urlSetList.add(0, urlSet);
                this.fireAddEvent(0, urlSet);
                break;
            }
        }
    }

    public class URLSet {
        private String[] urlStrings;
        private URL[] urls;

        public URLSet(URL[] urls) {
            this.urls = urls;
            this.urlStrings = this.createSortedFileStrings(urls);
        }

        private String[] createSortedFileStrings(URL[] urls) {
            Object[] fileStrings = new String[urls.length];
            for (int i = 0; i < urls.length; ++i) {
                fileStrings[i] = urls[i].toString();
            }
            Arrays.sort(fileStrings);
            return fileStrings;
        }

        public URL[] getUrls() {
            return this.urls;
        }

        public int hashCode() {
            return this.urlStrings[0].hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof URLSet) || obj == null) {
                return false;
            }
            URLSet that = (URLSet)obj;
            if (that.urlStrings.length != this.urlStrings.length) {
                return false;
            }
            for (int i = 0; i < that.urlStrings.length; ++i) {
                if (that.urlStrings[i].equals(this.urlStrings[i])) continue;
                return false;
            }
            return true;
        }
    }
}

