/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer;

import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimeOffsetPanel
extends JPanel {
    private static ResourceBundle localStrings = ResourceBundle.getBundle("com.tagtraum.perf.gcviewer.localStrings");
    private JSpinner timeSpinner;
    private JCheckBox setOffsetCheckBox;
    private int result;
    private static final String OK_ACTION_MAP_KEY = "ok";
    private static final String CANCEL_ACTION_MAP_KEY = "cancel";
    private JPopupMenu popup;
    private Action okAction;

    public TimeOffsetPanel(JPopupMenu popup) {
        this.popup = popup;
        this.timeSpinner = new JSpinner(new SpinnerDateModel());
        this.timeSpinner.setEditor(new JSpinner.DateEditor(this.timeSpinner, this.getPattern()));
        this.setOffsetCheckBox = new JCheckBox(localStrings.getString("timeoffset_prompt"), true);
        this.setOffsetCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TimeOffsetPanel.this.timeSpinner.setEnabled(TimeOffsetPanel.this.setOffsetCheckBox.isSelected());
                TimeOffsetPanel.this.okAction.actionPerformed(new ActionEvent(this, 0, null));
            }
        });
        this.add(this.setOffsetCheckBox);
        this.add(this.timeSpinner);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), OK_ACTION_MAP_KEY);
        this.getActionMap().put(OK_ACTION_MAP_KEY, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TimeOffsetPanel.this.result = 0;
                TimeOffsetPanel.this.popup.setVisible(false);
                if (TimeOffsetPanel.this.okAction != null) {
                    TimeOffsetPanel.this.okAction.actionPerformed(e);
                }
            }
        });
        this.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), CANCEL_ACTION_MAP_KEY);
        this.getActionMap().put(CANCEL_ACTION_MAP_KEY, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TimeOffsetPanel.this.result = 2;
                TimeOffsetPanel.this.popup.setVisible(false);
            }
        });
    }

    private String getPattern() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
        String format = "d. MMM HH:mm.ss a";
        if (dateFormat instanceof SimpleDateFormat) {
            format = ((SimpleDateFormat)dateFormat).toPattern();
        }
        return format;
    }

    public void setDate(Date date) {
        SpinnerDateModel spinnerDateModel = (SpinnerDateModel)this.timeSpinner.getModel();
        spinnerDateModel.setValue(date);
    }

    public Date getDate() {
        SpinnerDateModel spinnerDateModel = (SpinnerDateModel)this.timeSpinner.getModel();
        return spinnerDateModel.getDate();
    }

    public boolean isOffsetSet() {
        return this.setOffsetCheckBox.isSelected();
    }

    public void setOffsetSet(boolean value) {
        this.setOffsetCheckBox.setSelected(value);
    }

    public int getResult() {
        return this.result;
    }

    public void setOkAction(Action okAction) {
        this.okAction = okAction;
    }
}

