/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.action;

import com.tagtraum.perf.gcviewer.GCViewer;
import com.tagtraum.perf.gcviewer.util.ExtensionFileFilter;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;

public class AddFile
extends AbstractAction {
    private GCViewer gcViewer;
    private JFileChooser addDialog;
    private File[] lastSelectedFiles = new File[0];

    public AddFile(GCViewer gcViewer) {
        this.gcViewer = gcViewer;
        this.putValue("Name", GCViewer.localStrings.getString("main_frame_menuitem_add_file"));
        this.putValue("ShortDescription", GCViewer.localStrings.getString("main_frame_menuitem_hint_add_file"));
        this.putValue("MnemonicKey", new Integer(GCViewer.localStrings.getString("main_frame_menuitem_mnemonic_add_file").charAt(0)));
        this.putValue("ActionCommandKey", "add");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 2));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().getImage(gcViewer.getClass().getResource("images/add.gif"))));
        this.addDialog = new JFileChooser();
        this.addDialog.setDialogTitle(GCViewer.localStrings.getString("fileopen_dialog_title"));
        this.addDialog.setMultiSelectionEnabled(true);
        this.addDialog.addChoosableFileFilter(ExtensionFileFilter.GcExtensionFilter);
        this.addDialog.addChoosableFileFilter(ExtensionFileFilter.TxtExtensionFilter);
        this.addDialog.addChoosableFileFilter(ExtensionFileFilter.LogExtensionFilter);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        int val = this.addDialog.showOpenDialog(this.gcViewer);
        if (val == 0) {
            this.lastSelectedFiles = this.addDialog.getSelectedFiles();
            this.gcViewer.add(this.lastSelectedFiles);
        }
    }

    public void setSelectedFile(File file) {
        this.addDialog.setCurrentDirectory(file.getParentFile());
        this.addDialog.setSelectedFile(file);
    }

    public File[] getLastSelectedFiles() {
        return this.lastSelectedFiles;
    }
}

