/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.action;

import com.tagtraum.perf.gcviewer.ChartPanelView;
import com.tagtraum.perf.gcviewer.DataWriter;
import com.tagtraum.perf.gcviewer.DataWriterFactory;
import com.tagtraum.perf.gcviewer.GCDocument;
import com.tagtraum.perf.gcviewer.GCModel;
import com.tagtraum.perf.gcviewer.GCViewer;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class Export
extends AbstractAction {
    private GCViewer gcViewer;
    private JFileChooser saveDialog;
    private DataWriterFactory writerFactory;

    public Export(GCViewer gcViewer) {
        this.gcViewer = gcViewer;
        this.writerFactory = new DataWriterFactory();
        this.putValue("Name", GCViewer.localStrings.getString("main_frame_menuitem_export"));
        this.putValue("MnemonicKey", new Integer(GCViewer.localStrings.getString("main_frame_menuitem_mnemonic_export").charAt(0)));
        this.putValue("ShortDescription", GCViewer.localStrings.getString("main_frame_menuitem_hint_export"));
        this.putValue("ActionCommandKey", "export");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 2));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().getImage(gcViewer.getClass().getResource("images/save.png"))));
        this.setEnabled(false);
        this.saveDialog = new JFileChooser();
        this.saveDialog.setDialogTitle(GCViewer.localStrings.getString("fileexport_dialog_title"));
        this.saveDialog.removeChoosableFileFilter(this.saveDialog.getAcceptAllFileFilter());
        this.saveDialog.addChoosableFileFilter(new ExtensionFileFilter(".csv", GCViewer.localStrings.getString("fileexport_dialog_csv")));
        this.saveDialog.addChoosableFileFilter(new ExtensionFileFilter(".txt", GCViewer.localStrings.getString("fileexport_dialog_txt")));
    }

    public void actionPerformed(ActionEvent e) {
        GCDocument gcDocument = this.gcViewer.getSelectedGCDocument();
        for (int i = 0; i < gcDocument.getChartPanelViewCount(); ++i) {
            ChartPanelView chartPanelView = gcDocument.getChartPanelView(i);
            File file = new File(chartPanelView.getModel().getURL().getFile());
            this.saveDialog.setCurrentDirectory(file.getParentFile());
            this.saveDialog.setSelectedFile(file);
            int val = this.saveDialog.showSaveDialog(this.gcViewer);
            if (val == 0) {
                this.exportFile(chartPanelView.getModel(), this.saveDialog.getSelectedFile(), ((ExtensionFileFilter)this.saveDialog.getFileFilter()).getExtension());
                continue;
            }
            if (val != -1) continue;
            JOptionPane.showMessageDialog(this.gcViewer, GCViewer.localStrings.getString("fileexport_dialog_error_occured"), GCViewer.localStrings.getString("fileexport_dialog_write_file_failed"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportFile(GCModel model, File file, String extension) {
        DataWriter writer = null;
        try {
            if (file.toString().indexOf(46) == -1) {
                file = new File(file.toString() + extension);
            }
            if (!file.exists() || 0 == JOptionPane.showConfirmDialog(this.gcViewer, GCViewer.localStrings.getString("fileexport_dialog_confirm_overwrite"), GCViewer.localStrings.getString("fileexport_dialog_title"), 0)) {
                writer = this.writerFactory.getDataWriter(file, extension);
                writer.write(model);
            }
        }
        catch (Exception ioe) {
            JOptionPane.showMessageDialog(this.gcViewer, ioe.getLocalizedMessage(), GCViewer.localStrings.getString("fileexport_dialog_write_file_failed"), 0);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private static class ExtensionFileFilter
    extends FileFilter {
        private String extension;
        private String description;

        public ExtensionFileFilter(String extension, String description) {
            this.extension = extension.toLowerCase();
            this.description = description;
        }

        public boolean accept(File file) {
            return file.toString().toLowerCase().endsWith(this.extension);
        }

        public String getExtension() {
            return this.extension;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

