/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.action;

import com.tagtraum.perf.gcviewer.GCViewer;
import com.tagtraum.perf.gcviewer.RecentURLsModel;
import com.tagtraum.perf.gcviewer.util.AutoCompletionComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class OpenURL
extends AbstractAction {
    private GCViewer gcViewer;
    private AutoCompletionComboBox autoCompletionComboBox;

    public OpenURL(GCViewer gcViewer) {
        this.gcViewer = gcViewer;
        this.autoCompletionComboBox = new AutoCompletionComboBox();
        this.putValue("Name", GCViewer.localStrings.getString("main_frame_menuitem_open_url"));
        this.putValue("ShortDescription", GCViewer.localStrings.getString("main_frame_menuitem_hint_open_url"));
        this.putValue("MnemonicKey", new Integer(GCViewer.localStrings.getString("main_frame_menuitem_mnemonic_open_url").charAt(0)));
        this.putValue("ActionCommandKey", "open_url");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(85, 2));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().getImage(gcViewer.getClass().getResource("images/open_url.png"))));
    }

    public void setRecentURLsModel(RecentURLsModel recentURLsModel) {
        this.autoCompletionComboBox.setRecentURLsModel(recentURLsModel);
    }

    public void actionPerformed(ActionEvent e) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        panel.add((Component)this.autoCompletionComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        JCheckBox addURLCheckBox = new JCheckBox(GCViewer.localStrings.getString("urlopen_dialog_add_checkbox"), false);
        boolean aDocumentIsAlreadyOpen = this.gcViewer.getSelectedGCDocument() != null;
        addURLCheckBox.setVisible(aDocumentIsAlreadyOpen);
        addURLCheckBox.setEnabled(aDocumentIsAlreadyOpen);
        addURLCheckBox.setToolTipText(GCViewer.localStrings.getString("urlopen_dialog_hint_add_checkbox"));
        panel.add((Component)addURLCheckBox, gridBagConstraints);
        int result = JOptionPane.showConfirmDialog(this.gcViewer, panel, GCViewer.localStrings.getString("urlopen_dialog_title"), 2, -1);
        if (0 == result) {
            try {
                URL[] urls = new URL[]{new URL((String)this.autoCompletionComboBox.getSelectedItem())};
                if (addURLCheckBox.isSelected()) {
                    this.gcViewer.add(urls);
                } else {
                    this.gcViewer.open(urls);
                }
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
    }
}

