/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.action;

import com.tagtraum.perf.gcviewer.GCViewer;
import com.tagtraum.perf.gcviewer.util.NumberParser;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class Zoom
extends AbstractAction {
    private GCViewer gcViewer;

    public Zoom(GCViewer gcViewer) {
        this.gcViewer = gcViewer;
        this.putValue("Name", GCViewer.localStrings.getString("action_zoom"));
        this.putValue("ShortDescription", GCViewer.localStrings.getString("action_zoom_hint"));
        this.putValue("ActionCommandKey", "zoom");
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        ItemSelectable is = (ItemSelectable)e.getSource();
        Object[] o = is.getSelectedObjects();
        try {
            int zoomFactor;
            String item = (String)o[0];
            if (item.endsWith("%")) {
                item = item.substring(0, item.length() - 1);
            }
            if ((zoomFactor = NumberParser.parseInt(item.trim())) > 0) {
                this.gcViewer.getSelectedGCDocument().getModelChart().setScaleFactor((double)zoomFactor / 1000.0);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
    }
}

