/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.imp;

import com.tagtraum.perf.gcviewer.AbstractGCEvent;
import com.tagtraum.perf.gcviewer.DataReader;
import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.GCModel;
import com.tagtraum.perf.gcviewer.imp.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataReaderIBM1_3_1
implements DataReader {
    private static Logger LOG = Logger.getLogger(DataReaderIBM1_3_1.class.getName());
    private LineNumberReader in;
    private DateFormat cycleStartGCFormat;

    public DataReaderIBM1_3_1(InputStream in) {
        this.in = new LineNumberReader(new InputStreamReader(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GCModel read() throws IOException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Reading IBM 1.3.1 format...");
        }
        try {
            GCModel model = new GCModel(true);
            model.setFormat(GCModel.Format.IBM_VERBOSE_GC);
            int state = 0;
            String line = null;
            GCEvent lastEvent = new GCEvent();
            GCEvent event = null;
            long basetime = 0L;
            this.cycleStartGCFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.US);
            while ((line = this.in.readLine()) != null) {
                String trimmedLine = line.trim();
                if (!("".equals(trimmedLine) || trimmedLine.startsWith("<GC: ") || trimmedLine.startsWith("<"))) {
                    System.err.println("Malformed line (" + this.in.getLineNumber() + "): " + line);
                    state = 0;
                }
                switch (state) {
                    case 0: {
                        if (line.indexOf("Allocation Failure.") != -1) {
                            event = new GCEvent();
                            event.setType(AbstractGCEvent.Type.FULL_GC);
                            event.setTimestamp(lastEvent.getTimestamp() + this.parseTimeSinceLastAF(line));
                            break;
                        }
                        if (line.indexOf("GC cycle started") != -1) {
                            event = new GCEvent();
                            event.setType(AbstractGCEvent.Type.FULL_GC);
                            long time = this.parseGCCycleStart(line);
                            if (basetime == 0L) {
                                basetime = time;
                            }
                            event.setTimestamp((double)(time - basetime) / 1000.0);
                            ++state;
                            break;
                        }
                        if (line.indexOf("managing allocation failure, action=3") == -1) break;
                        event = new GCEvent();
                        event.setType(AbstractGCEvent.Type.FULL_GC);
                        event.setTimestamp(lastEvent.getTimestamp() + lastEvent.getPause());
                        event.setPreUsed(this.parsePreUsedAFAction3(line));
                        event.setPostUsed(event.getPreUsed());
                        state = 2;
                        break;
                    }
                    case 1: {
                        if (line.indexOf("freed") == -1 || line.indexOf("unloaded") != -1) break;
                        event.setPreUsed(this.parsePreUsed(line));
                        event.setPostUsed(this.parsePostUsed(line));
                        event.setTotal(this.parseTotalAfterGC(line));
                        event.setPause(this.parsePause(line));
                        model.add(event);
                        lastEvent = event;
                        event = null;
                        state = 0;
                        break;
                    }
                    case 2: {
                        if (line.indexOf("expanded heap by ") == -1 && line.indexOf("expanded heap fully by ") == -1) break;
                        event.setTotal(this.parseTotalAfterHeapExpansion(line));
                        ++state;
                        break;
                    }
                    case 3: {
                        if (line.indexOf("completed in ") == -1) break;
                        event.setPause(this.parsePause(line) - lastEvent.getPause());
                        model.add(event);
                        lastEvent = event;
                        event = null;
                        state = 0;
                        break;
                    }
                }
            }
            GCModel gCModel = model;
            return gCModel;
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {}
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Done reading.");
            }
        }
    }

    private long parseGCCycleStart(String line) throws IOException {
        try {
            int idx = line.indexOf("GC cycle started ");
            Date date = this.cycleStartGCFormat.parse(line.substring(idx + "GC cycle started ".length()));
            return date.getTime();
        }
        catch (java.text.ParseException e) {
            throw new ParseException(e.toString());
        }
    }

    private double parseTimeSinceLastAF(String line) {
        int start = line.indexOf(44) + 2;
        int end = line.indexOf(32, start);
        return Double.parseDouble(line.substring(start, end)) / 1000.0;
    }

    private int parsePreUsed(String line) {
        int start = line.indexOf("freed ") + "freed ".length();
        int end = line.indexOf(32, start);
        long freed = Long.parseLong(line.substring(start, end));
        start = line.indexOf(40, line.indexOf("freed")) + 1;
        end = line.indexOf(41, start);
        int mid = line.indexOf(47, start);
        long postFreedFree = Long.parseLong(line.substring(mid + 1, end)) - Long.parseLong(line.substring(start, mid));
        return (int)((freed + postFreedFree) / 1024L);
    }

    private int parsePreUsedAFAction3(String line) {
        int start = line.indexOf(40, line.indexOf("action=3")) + 1;
        int end = line.indexOf(41, start);
        int mid = line.indexOf(47, start);
        return (int)((Long.parseLong(line.substring(mid + 1, end)) - Long.parseLong(line.substring(start, mid))) / 1024L);
    }

    private int parsePostUsed(String line) {
        int start = line.indexOf(40, line.indexOf("freed")) + 1;
        int end = line.indexOf(41, start);
        int mid = line.indexOf(47, start);
        return (int)((Long.parseLong(line.substring(mid + 1, end)) - Long.parseLong(line.substring(start, mid))) / 1024L);
    }

    private int parseTotalAfterGC(String line) {
        int start = line.indexOf(47, line.indexOf("freed")) + 1;
        int end = line.indexOf(41, start);
        return (int)(Long.parseLong(line.substring(start, end)) / 1024L);
    }

    private int parseTotalAfterHeapExpansion(String line) {
        int start = line.indexOf("to ") + 3;
        int end = line.indexOf(32, start);
        return (int)(Long.parseLong(line.substring(start, end)) / 1024L);
    }

    private double parsePause(String line) {
        int start = line.indexOf("in ") + 3;
        int end = line.indexOf(32, start);
        return Double.parseDouble(line.substring(start, end)) / 1000.0;
    }
}

