/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.imp;

import com.tagtraum.perf.gcviewer.DataReader;
import com.tagtraum.perf.gcviewer.GCModel;
import com.tagtraum.perf.gcviewer.imp.IBMJ9SAXHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DataReaderIBM_J9_5_0
implements DataReader {
    private static Logger LOG = Logger.getLogger(DataReaderIBM_J9_5_0.class.getName());
    private InputStream in;

    public DataReaderIBM_J9_5_0(InputStream in) {
        this.in = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GCModel read() throws IOException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Reading IBM J9 5.0 format...");
        }
        try {
            GCModel model;
            block13: {
                model = new GCModel(true);
                model.setFormat(GCModel.Format.IBM_VERBOSE_GC);
                IBMJ9SAXHandler handler = new IBMJ9SAXHandler(model);
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                try {
                    SAXParser saxParser = factory.newSAXParser();
                    saxParser.parse(this.in, (DefaultHandler)handler);
                }
                catch (ParserConfigurationException e) {
                    IOException exception = new IOException(e.toString());
                    exception.initCause(e);
                    throw exception;
                }
                catch (SAXException e) {
                    if (e.getMessage().startsWith("XML document structures must start and end within the same entity")) break block13;
                    IOException exception = new IOException(e.toString());
                    exception.initCause(e);
                    throw exception;
                }
            }
            GCModel gCModel = model;
            return gCModel;
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {}
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Done reading.");
            }
        }
    }
}

