/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.imp;

import com.tagtraum.perf.gcviewer.AbstractGCEvent;
import com.tagtraum.perf.gcviewer.DataReader;
import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.GCModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataReaderSun1_2_2
implements DataReader {
    private static Logger LOG = Logger.getLogger(DataReaderSun1_2_2.class.getName());
    private BufferedReader in;

    public DataReaderSun1_2_2(InputStream in) {
        this.in = new BufferedReader(new InputStreamReader(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GCModel read() throws IOException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Reading Sun 1.2.2 format...");
        }
        try {
            GCModel model = new GCModel(true);
            model.setFormat(GCModel.Format.SUN_1_2_2VERBOSE_GC);
            String line = null;
            boolean timeline = false;
            GCEvent lastEvent = new GCEvent();
            GCEvent event = null;
            while ((line = this.in.readLine()) != null) {
                if (!timeline) {
                    if (!line.endsWith("milliseconds since last GC>")) continue;
                    timeline = true;
                    double time = Integer.parseInt(line.substring(5, line.indexOf(32, 5)));
                    event = new GCEvent();
                    event.setTimestamp(lastEvent.getTimestamp() + time / 1000.0);
                    continue;
                }
                timeline = false;
                if (line.indexOf("expanded object space by") != -1) {
                    int endIndex = line.indexOf(32, "<GC: expanded object space by ".length());
                    int beginIndex = endIndex + " to ".length();
                    int incTo = Integer.parseInt(line.substring(beginIndex, line.indexOf(32, beginIndex)));
                    int percentUsed = Integer.parseInt(line.substring(line.length() - "XX% free>".length(), line.length() - "% free>".length()));
                    event.setPostUsed((int)((long)(incTo * percentUsed) / 1024L / 100L));
                    event.setPreUsed(event.getPostUsed());
                    event.setTotal((int)((long)incTo / 1024L));
                    event.setType(AbstractGCEvent.Type.GC);
                    event.setPause(0.0);
                    model.add(event);
                    lastEvent = event;
                    continue;
                }
                if (line.indexOf(" freed ") == -1 || line.indexOf(" objects, ") == -1) continue;
                int startIndex = line.indexOf(44) + 2;
                int endIndex = line.indexOf(32, startIndex);
                int freed = Integer.parseInt(line.substring(startIndex, endIndex));
                startIndex = line.indexOf("in ") + 3;
                endIndex = line.indexOf(32, startIndex);
                int pause = Integer.parseInt(line.substring(startIndex, endIndex));
                startIndex = line.indexOf(40) + 1;
                endIndex = line.indexOf(47, startIndex);
                int postFree = Integer.parseInt(line.substring(startIndex, endIndex));
                startIndex = line.indexOf(47) + 1;
                endIndex = line.indexOf(41, startIndex);
                int total = Integer.parseInt(line.substring(startIndex, endIndex));
                event.setPostUsed((total - postFree) / 1024);
                event.setPreUsed((total - postFree + freed) / 1024);
                event.setTotal(total / 1024);
                event.setType(AbstractGCEvent.Type.GC);
                event.setPause((double)pause / 1000.0);
                model.add(event);
                lastEvent = event;
            }
            GCModel gCModel = model;
            return gCModel;
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {}
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Done reading.");
            }
        }
    }
}

