/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.imp;

import com.tagtraum.perf.gcviewer.AbstractGCEvent;
import com.tagtraum.perf.gcviewer.DataReader;
import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.GCModel;
import com.tagtraum.perf.gcviewer.imp.AbstractDataReaderSun;
import com.tagtraum.perf.gcviewer.imp.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParsePosition;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DataReaderSun1_4_0
extends AbstractDataReaderSun
implements DataReader {
    private static Logger LOG = Logger.getLogger(DataReaderSun1_4_0.class.getName());
    private static final String UNLOADING_CLASS = "[Unloading class ";
    private static final String DESIRED_SURVIVOR = "Desired survivor";
    private static final String APPLICATION_TIME = "Application time:";
    private static final String TOTAL_TIME_THREADS_STOPPED = "Total time for which application threads were stopped:";
    private static final String SURVIVOR_AGE = "- age";
    private static final HashSet EXCLUDE_STRINGS = new HashSet();
    private Pattern unloadingClassPattern = Pattern.compile(".*\\[Unloading class [^\\]]+\\]$");

    public DataReaderSun1_4_0(InputStream in) throws UnsupportedEncodingException {
        super(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GCModel read() throws IOException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Reading Sun 1.4.x/1.5.x format...");
        }
        try {
            String line;
            GCModel model = new GCModel(true);
            model.setFormat(GCModel.Format.SUN_X_LOG_GC);
            String beginningOfLine = null;
            ParsePosition parsePosition = new ParsePosition(0);
            block9: while ((line = this.in.readLine()) != null) {
                block18: {
                    try {
                        Iterator i = EXCLUDE_STRINGS.iterator();
                        while (i.hasNext()) {
                            String s = (String)i.next();
                            if (line.indexOf(s) != 0) continue;
                            continue block9;
                        }
                        int unloadingClassIndex = line.indexOf(UNLOADING_CLASS);
                        if (this.unloadingClassPattern.matcher(line).matches()) {
                            beginningOfLine = line.substring(0, unloadingClassIndex);
                            continue;
                        }
                        if (line.endsWith("[DefNew") || line.endsWith("[ParNew")) {
                            beginningOfLine = line;
                            continue;
                        }
                        if (beginningOfLine != null) {
                            line = beginningOfLine + line;
                            beginningOfLine = null;
                        }
                        model.add(this.parseLine(line, parsePosition));
                    }
                    catch (ParseException pe) {
                        if (LOG.isLoggable(Level.WARNING)) {
                            LOG.warning(pe.getMessage());
                        }
                        if (!LOG.isLoggable(Level.FINE)) break block18;
                        LOG.log(Level.FINE, pe.getMessage(), pe);
                    }
                }
                parsePosition.setIndex(0);
            }
            GCModel gCModel = model;
            return gCModel;
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {}
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Done reading.");
            }
        }
    }

    protected AbstractGCEvent parseLine(String line, ParsePosition pos) throws ParseException {
        try {
            GCEvent detailEvent;
            GCEvent event = new GCEvent();
            double timestamp = this.parseTimestamp(line, pos);
            event.setTimestamp(timestamp);
            event.setType(this.parseType(line, pos));
            while (this.hasNextDetail(line, pos)) {
                detailEvent = new GCEvent();
                if (this.nextCharIsBracket(line, pos)) {
                    detailEvent.setTimestamp(timestamp);
                } else {
                    detailEvent.setTimestamp(this.parseTimestamp(line, pos));
                }
                detailEvent.setType(this.parseType(line, pos));
                this.setMemoryAndPauses(detailEvent, line, pos);
                event.add(detailEvent);
            }
            this.setMemoryAndPauses(event, line, pos);
            if (event.getPause() == 0.0) {
                if (this.hasNextDetail(line, pos)) {
                    detailEvent = new GCEvent();
                    if (this.nextCharIsBracket(line, pos)) {
                        detailEvent.setTimestamp(timestamp);
                    } else {
                        detailEvent.setTimestamp(this.parseTimestamp(line, pos));
                    }
                    detailEvent.setType(this.parseType(line, pos));
                    this.setMemoryAndPauses(detailEvent, line, pos);
                    event.add(detailEvent);
                }
                this.setPause(event, line, pos);
            }
            return event;
        }
        catch (RuntimeException rte) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, rte.toString(), rte);
            }
            throw new ParseException("Error parsing entry, " + rte.toString(), line);
        }
    }

    static {
        EXCLUDE_STRINGS.add(UNLOADING_CLASS);
        EXCLUDE_STRINGS.add(DESIRED_SURVIVOR);
        EXCLUDE_STRINGS.add(APPLICATION_TIME);
        EXCLUDE_STRINGS.add(TOTAL_TIME_THREADS_STOPPED);
        EXCLUDE_STRINGS.add(SURVIVOR_AGE);
    }
}

