/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.imp;

import com.tagtraum.perf.gcviewer.AbstractGCEvent;
import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.GCModel;
import com.tagtraum.perf.gcviewer.imp.AF;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IBMJ9SAXHandler
extends DefaultHandler {
    private GCModel model;
    private DateFormat cycleStartGCFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.US);
    protected AF currentAF;
    int currentTenured = 0;
    private static Logger LOG = Logger.getLogger(IBMJ9SAXHandler.class.getName());
    Date begin = null;

    public IBMJ9SAXHandler(GCModel model) {
        this.model = model;
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        try {
            if (this.currentAF == null) {
                if ("af".equals(qName)) {
                    Date date;
                    this.currentAF = new AF();
                    String type = attrs.getValue("type");
                    String id = attrs.getValue("id");
                    String ts = attrs.getValue("timestamp");
                    this.currentAF.id = id;
                    this.currentAF.type = type;
                    this.currentAF.timestamp = date = this.cycleStartGCFormat.parse(ts);
                    if (this.begin == null) {
                        this.begin = date;
                        this.currentAF.elapsedTime = 0L;
                    } else {
                        this.currentAF.elapsedTime = (this.currentAF.timestamp.getTime() - this.begin.getTime()) / 1000L;
                        System.out.println("ElapsedTime: " + this.currentAF.elapsedTime);
                    }
                }
            } else if (this.currentAF != null) {
                if ("time".equals(qName)) {
                    String totalStr = attrs.getValue("totalms");
                    double total = -1.0;
                    if (totalStr != null) {
                        total = Double.parseDouble(totalStr);
                        this.currentAF.totalTime = total / 1000.0;
                    }
                } else if ("gc".equals(qName)) {
                    String type;
                    this.currentAF.gcType = type = attrs.getValue("type");
                } else if ("timesms".equals(qName)) {
                    String markStr = attrs.getValue("mark");
                    double mark = -1.0;
                    if (markStr != null) {
                        this.currentAF.gcTimeMark = mark = Double.parseDouble(markStr);
                    }
                    String sweepStr = attrs.getValue("sweep");
                    double sweep = -1.0;
                    if (sweepStr != null) {
                        mark = Double.parseDouble(sweepStr);
                        this.currentAF.gcTimeSweep = sweep;
                    }
                } else if ("tenured".equals(qName)) {
                    ++this.currentTenured;
                    String freeStr = attrs.getValue("freebytes");
                    int free = -1;
                    if (freeStr != null) {
                        free = Integer.parseInt(freeStr);
                    }
                    String totalStr = attrs.getValue("totalbytes");
                    int total = -1;
                    if (totalStr != null) {
                        total = Integer.parseInt(totalStr);
                    }
                    if (this.currentTenured == 1) {
                        this.currentAF.initialFreeBytes = free / 1000;
                        this.currentAF.initialTotalBytes = total / 1000;
                    } else if (this.currentTenured != 2) {
                        if (this.currentTenured == 3) {
                            this.currentAF.afterFreeBytes = free / 1000;
                            this.currentAF.afterTotalBytes = total / 1000;
                        } else {
                            LOG.warning("currentTenured is > 3!");
                        }
                    }
                } else if ("soa".equals(qName)) {
                    String freeStr = attrs.getValue("freebytes");
                    int free = -1;
                    if (freeStr != null) {
                        free = Integer.parseInt(freeStr);
                    }
                    String totalStr = attrs.getValue("totalbytes");
                    int total = -1;
                    if (totalStr != null) {
                        total = Integer.parseInt(totalStr);
                    }
                    if (this.currentTenured == 1) {
                        this.currentAF.initialSOAFreeBytes = free / 1000;
                        this.currentAF.initialSOATotalBytes = total / 1000;
                    } else if (this.currentTenured != 2) {
                        if (this.currentTenured == 3) {
                            this.currentAF.afterSOAFreeBytes = free / 1000;
                            this.currentAF.afterSOATotalBytes = total / 1000;
                        } else {
                            LOG.warning("currentTenured is > 3!");
                        }
                    }
                } else if ("loa".equals(qName)) {
                    String freeStr = attrs.getValue("freebytes");
                    int free = -1;
                    if (freeStr != null) {
                        free = Integer.parseInt(freeStr);
                    }
                    String totalStr = attrs.getValue("totalbytes");
                    int total = -1;
                    if (totalStr != null) {
                        total = Integer.parseInt(totalStr);
                    }
                    if (this.currentTenured == 1) {
                        this.currentAF.initialLOAFreeBytes = free / 1000;
                        this.currentAF.initialLOATotalBytes = total / 1000;
                    } else if (this.currentTenured != 2) {
                        if (this.currentTenured == 3) {
                            this.currentAF.afterLOAFreeBytes = free / 1000;
                            this.currentAF.afterLOATotalBytes = total / 1000;
                        } else {
                            LOG.warning("currentTenured is > 3!");
                        }
                    }
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if ("af".equals(qName)) {
            System.out.println("In AF endElement!");
            if (this.currentAF != null) {
                GCEvent detailEvent;
                int postUsed;
                int preUsed;
                GCEvent event = new GCEvent();
                if (!"tenured".equals(this.currentAF.type)) {
                    LOG.warning("Unhandled AF type: " + this.currentAF.type);
                }
                if (!"global".equals(this.currentAF.gcType)) {
                    LOG.warning("Different GC type: " + this.currentAF.gcType);
                } else {
                    event.setType(AbstractGCEvent.Type.FULL_GC);
                }
                if (this.currentAF.initialTotalBytes != -1 && this.currentAF.initialFreeBytes != -1) {
                    preUsed = this.currentAF.initialTotalBytes - this.currentAF.initialFreeBytes;
                    event.setPreUsed(preUsed);
                }
                if (this.currentAF.afterTotalBytes != -1 && this.currentAF.afterFreeBytes != -1) {
                    int postUsed2 = this.currentAF.afterTotalBytes - this.currentAF.afterFreeBytes;
                    event.setPostUsed(postUsed2);
                }
                if (this.currentAF.afterTotalBytes != -1) {
                    event.setTotal(this.currentAF.afterTotalBytes);
                }
                event.setTimestamp(this.currentAF.elapsedTime);
                if (this.currentAF.totalTime != -1.0) {
                    event.setPause(this.currentAF.totalTime);
                }
                if (this.currentAF.afterSOATotalBytes != -1 && this.currentAF.afterSOAFreeBytes != -1 && this.currentAF.initialSOAFreeBytes != -1 && this.currentAF.initialSOATotalBytes != -1) {
                    preUsed = this.currentAF.initialSOATotalBytes - this.currentAF.initialSOAFreeBytes;
                    postUsed = this.currentAF.afterSOATotalBytes - this.currentAF.afterSOAFreeBytes;
                    detailEvent = new GCEvent();
                    detailEvent.setTimestamp(this.currentAF.elapsedTime);
                    detailEvent.setType(AbstractGCEvent.Type.PS_YOUNG_GEN);
                    detailEvent.setTenuredDetail(true);
                    detailEvent.setPreUsed(preUsed);
                    detailEvent.setPostUsed(postUsed);
                    detailEvent.setTotal(this.currentAF.afterSOATotalBytes);
                    event.add(detailEvent);
                }
                if (this.currentAF.afterLOATotalBytes != -1 && this.currentAF.afterLOAFreeBytes != -1 && this.currentAF.initialLOAFreeBytes != -1 && this.currentAF.initialLOATotalBytes != -1) {
                    preUsed = this.currentAF.initialLOATotalBytes - this.currentAF.initialLOAFreeBytes;
                    postUsed = this.currentAF.afterLOATotalBytes - this.currentAF.afterLOAFreeBytes;
                    detailEvent = new GCEvent();
                    detailEvent.setTimestamp(this.currentAF.elapsedTime);
                    detailEvent.setType(AbstractGCEvent.Type.PS_OLD_GEN);
                    detailEvent.setTenuredDetail(true);
                    detailEvent.setPreUsed(preUsed);
                    detailEvent.setPostUsed(postUsed);
                    detailEvent.setTotal(this.currentAF.afterLOATotalBytes);
                    event.add(detailEvent);
                }
                this.model.add(event);
                this.currentTenured = 0;
                this.currentAF = null;
            } else {
                LOG.warning("Found end <af> tag with no begin tag");
            }
        }
    }
}

