/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.math;

import com.tagtraum.perf.gcviewer.math.Sum;
import java.io.Serializable;

public class DoubleData
implements Serializable {
    private int n;
    private double sum;
    private double sumSquares;
    private double min = Double.MAX_VALUE;
    private double max = Double.MIN_VALUE;

    public void add(double x) {
        this.sum += x;
        this.sumSquares += x * x;
        ++this.n;
        this.min = Math.min(this.min, x);
        this.max = Math.max(this.max, x);
    }

    public void add(double x, int weight) {
        this.sum += x * (double)weight;
        this.n += weight;
        this.sumSquares += x * x * (double)weight;
        this.min = Math.min(this.min, x);
        this.max = Math.max(this.max, x);
    }

    public int getN() {
        return this.n;
    }

    public double getSum() {
        return this.sum;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double average() {
        if (this.n == 0) {
            throw new IllegalStateException("n == 0");
        }
        return this.sum / (double)this.n;
    }

    public double standardDeviation() {
        if (this.n == 0) {
            throw new IllegalStateException("n == 0");
        }
        if (this.n == 1) {
            return 0.0;
        }
        return Math.sqrt(this.variance());
    }

    public double variance() {
        if (this.n == 0) {
            throw new IllegalStateException("n == 0");
        }
        if (this.n == 1) {
            return 0.0;
        }
        return (this.sumSquares - this.sum * this.sum / (double)this.n) / (double)(this.n - 1);
    }

    public void reset() {
        this.sum = 0.0;
        this.sumSquares = 0.0;
        this.n = 0;
    }

    public static double average(double[] n) {
        return Sum.sum(n) / (double)n.length;
    }

    public static double weightedAverage(double[] n, int[] weight) {
        double sum = 0.0;
        int m = 0;
        for (int i = 0; i < n.length; ++i) {
            sum += n[i] * (double)weight[i];
            m += weight[i];
        }
        return sum / (double)m;
    }
}

