/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.math;

import java.io.Serializable;

public class IntData
implements Serializable {
    private int n;
    private long sum;
    private long sumSquares;
    private int min = Integer.MAX_VALUE;
    private int max = Integer.MIN_VALUE;

    public void add(int x) {
        this.sum += (long)x;
        this.sumSquares += (long)x * (long)x;
        ++this.n;
        this.min = Math.min(this.min, x);
        this.max = Math.max(this.max, x);
    }

    public void add(int x, int weight) {
        this.sum += (long)(x * weight);
        this.n += weight;
        this.sumSquares += (long)x * (long)x * (long)weight;
        this.min = Math.min(this.min, x);
        this.max = Math.max(this.max, x);
    }

    public int getN() {
        return this.n;
    }

    public long getSum() {
        return this.sum;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public double average() {
        if (this.n == 0) {
            throw new IllegalStateException("n == 0");
        }
        return (double)this.sum / (double)this.n;
    }

    public double standardDeviation() {
        if (this.n == 0) {
            throw new IllegalStateException("n == 0");
        }
        if (this.n == 1) {
            return 0.0;
        }
        return Math.sqrt(this.variance());
    }

    public double variance() {
        if (this.n == 0) {
            throw new IllegalStateException("n == 0");
        }
        if (this.n == 1) {
            return 0.0;
        }
        double dsum = this.sum;
        double dn = this.n;
        return ((double)this.sumSquares - dsum * dsum / dn) / (dn - 1.0);
    }

    public void reset() {
        this.sum = 0L;
        this.sumSquares = 0L;
        this.n = 0;
    }

    public static long weightedAverage(long[] n, int[] weight) {
        long sum = 0L;
        int m = 0;
        for (int i = 0; i < n.length; ++i) {
            sum += n[i] * (long)weight[i];
            m += weight[i];
        }
        return sum / (long)m;
    }
}

