/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.math;

import com.tagtraum.perf.gcviewer.math.Sum;
import java.io.Serializable;

public class RegressionLine
implements Serializable {
    private double sumX;
    private double sumY;
    private double sumXSquare;
    private double sumXY;
    private int n;

    public void addPoint(double x, double y) {
        this.sumX += x;
        this.sumY += y;
        this.sumXSquare += x * x;
        this.sumXY += x * y;
        ++this.n;
    }

    public int getPointCount() {
        return this.n;
    }

    public boolean isLine() {
        return this.n > 1;
    }

    public boolean hasPoints() {
        return this.n != 0;
    }

    public double slope() {
        return RegressionLine.slope(this.n, this.sumX, this.sumY, this.sumXY, this.sumXSquare);
    }

    public void reset() {
        this.sumX = 0.0;
        this.sumY = 0.0;
        this.sumXSquare = 0.0;
        this.sumXY = 0.0;
        this.n = 0;
    }

    public static double slope(double[] x, double[] y) {
        double n = x.length;
        double sumX = Sum.sum(x);
        double sumY = Sum.sum(y);
        double sumXY = Sum.sumOfProducts(x, y);
        double sumXSquare = Sum.sumOfSquares(x);
        return RegressionLine.slope(n, sumX, sumY, sumXY, sumXSquare);
    }

    private static double slope(double n, double sumX, double sumY, double sumXY, double sumXSquare) {
        return (n * sumXY - sumX * sumY) / (n * sumXSquare - sumX * sumX);
    }
}

