/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.renderer;

import com.tagtraum.perf.gcviewer.ChartRenderer;
import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.ModelChartImpl;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Iterator;

public class FullGCLineRenderer
extends ChartRenderer {
    public static final Paint DEFAULT_LINEPAINT = Color.BLACK;

    public FullGCLineRenderer(ModelChartImpl modelChart) {
        super(modelChart);
        this.setLinePaint(DEFAULT_LINEPAINT);
    }

    public void paintComponent(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        double scaleFactor = this.getModelChart().getScaleFactor();
        Rectangle clipBounds = g2d.getClipBounds();
        int minX = clipBounds.x;
        int maxX = clipBounds.x + clipBounds.width;
        int height = this.getHeight();
        int lastScaledTimestamp = Integer.MIN_VALUE;
        Iterator i = this.getModelChart().getModel().getGCEvents();
        while (i.hasNext()) {
            int scaledTimestamp;
            GCEvent event = (GCEvent)i.next();
            if (!event.isFull() || (scaledTimestamp = (int)(scaleFactor * event.getTimestamp())) == lastScaledTimestamp || scaledTimestamp < minX || scaledTimestamp > maxX) continue;
            g2d.drawLine(scaledTimestamp, 0, scaledTimestamp, height);
            lastScaledTimestamp = scaledTimestamp;
        }
    }
}

