/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.renderer;

import com.tagtraum.perf.gcviewer.AbstractGCEvent;
import com.tagtraum.perf.gcviewer.ChartRenderer;
import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.ModelChartImpl;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.util.Iterator;

public class GCRectanglesRenderer
extends ChartRenderer {
    public static final Paint DEFAULT_LINEPAINT = Color.GRAY;
    private Paint darker;
    private Paint brighter;

    public GCRectanglesRenderer(ModelChartImpl modelChart) {
        super(modelChart);
        this.setLinePaint(DEFAULT_LINEPAINT);
    }

    public void setLinePaint(Paint linePaint) {
        super.setLinePaint(linePaint);
        if (linePaint instanceof Color) {
            this.darker = ((Color)linePaint).darker();
            this.brighter = ((Color)linePaint).brighter();
        } else {
            this.darker = linePaint;
            this.brighter = linePaint;
        }
    }

    public void paintComponent(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        double scaleFactor = this.getModelChart().getScaleFactor();
        double scaledHeight = (double)this.getHeight() / this.getModelChart().getMaxPause();
        int lastWidth = Integer.MIN_VALUE;
        int lastHeight = Integer.MIN_VALUE;
        int lastX = Integer.MIN_VALUE;
        int lastY = Integer.MIN_VALUE;
        Iterator i = this.getModelChart().getModel().getGCEvents();
        while (i.hasNext()) {
            GCEvent event = (GCEvent)i.next();
            double pause = event.getPause();
            int width = (int)Math.max(Math.abs(scaleFactor * pause), 1.0);
            int height = (int)(pause * scaledHeight);
            int x = (int)(scaleFactor * event.getTimestamp());
            int y = this.getHeight() - (int)(pause * scaledHeight);
            if (lastX == x && lastY == y && lastWidth == width && lastHeight == height) continue;
            if (event.getType() == AbstractGCEvent.Type.FULL_GC) {
                g2d.setPaint(this.darker);
            } else if (event.getType() == AbstractGCEvent.Type.INC_GC) {
                g2d.setPaint(this.brighter);
            } else {
                g2d.setPaint(this.getLinePaint());
            }
            g2d.fillRect(x, y, width, height);
            lastWidth = width;
            lastHeight = height;
            lastX = x;
            lastY = y;
        }
    }
}

