/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.renderer;

import com.tagtraum.perf.gcviewer.ChartRenderer;
import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.ModelChartImpl;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.util.Iterator;

public class IncLineRenderer
extends ChartRenderer {
    public static final Paint DEFAULT_LINEPAINT = Color.CYAN;

    public IncLineRenderer(ModelChartImpl modelChart) {
        super(modelChart);
        this.setLinePaint(DEFAULT_LINEPAINT);
    }

    public void paintComponent(Graphics2D g2d) {
        double scaleFactor = this.getModelChart().getScaleFactor();
        int height = this.getHeight();
        int lastScaledTimestamp = Integer.MIN_VALUE;
        Iterator i = this.getModelChart().getModel().getGCEvents();
        while (i.hasNext()) {
            int scaledTimestamp;
            GCEvent event;
            Object o = i.next();
            if (!(o instanceof GCEvent) || !(event = (GCEvent)o).isInc() || (scaledTimestamp = (int)(scaleFactor * event.getTimestamp())) == lastScaledTimestamp) continue;
            g2d.drawLine(scaledTimestamp, 0, scaledTimestamp, height);
            lastScaledTimestamp = scaledTimestamp;
        }
    }
}

