/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.renderer;

import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.GCModel;
import com.tagtraum.perf.gcviewer.ModelChart;
import com.tagtraum.perf.gcviewer.ModelChartImpl;
import com.tagtraum.perf.gcviewer.renderer.PolygonChartRenderer;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Polygon;
import java.util.Iterator;

public class TotalHeapRenderer
extends PolygonChartRenderer {
    public static final Paint DEFAULT_LINEPAINT = Color.RED;
    public static final Paint DEFAULT_FILLPAINT = new GradientPaint(0.0f, 0.0f, Color.RED, 0.0f, 0.0f, Color.WHITE);

    public TotalHeapRenderer(ModelChartImpl modelChart) {
        super(modelChart);
        this.setFillPaint(DEFAULT_FILLPAINT);
        this.setLinePaint(DEFAULT_LINEPAINT);
        this.setDrawPolygon(true);
        this.setDrawLine(true);
    }

    public Polygon computePolygon(ModelChart modelChart, GCModel model) {
        PolygonChartRenderer.ScaledPolygon polygon = this.createMemoryScaledPolygon();
        polygon.addPoint(0.0, 0.0);
        Iterator i = model.getGCEvents();
        while (i.hasNext()) {
            GCEvent event = (GCEvent)i.next();
            polygon.addPoint(event.getTimestamp(), (double)event.getTotal());
        }
        polygon.addPoint(model.getRunningTime(), 0.0);
        return polygon;
    }
}

