/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.renderer;

import com.tagtraum.perf.gcviewer.AbstractGCEvent;
import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.GCModel;
import com.tagtraum.perf.gcviewer.ModelChart;
import com.tagtraum.perf.gcviewer.ModelChartImpl;
import com.tagtraum.perf.gcviewer.renderer.PolygonChartRenderer;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Polygon;
import java.util.Iterator;

public class TotalYoungRenderer
extends PolygonChartRenderer {
    public static final Paint DEFAULT_LINEPAINT = Color.ORANGE;
    public static final Paint DEFAULT_FILLPAINT = new GradientPaint(0.0f, 0.0f, Color.ORANGE, 0.0f, 0.0f, Color.WHITE);

    public TotalYoungRenderer(ModelChartImpl modelChart) {
        super(modelChart);
        this.setFillPaint(DEFAULT_FILLPAINT);
        this.setLinePaint(DEFAULT_LINEPAINT);
        this.setDrawPolygon(true);
        this.setDrawLine(true);
    }

    public Polygon computePolygon(ModelChart modelChart, GCModel model) {
        PolygonChartRenderer.ScaledPolygon polygon = this.createMemoryScaledPolygon();
        polygon.addPoint(0.0, 0.0);
        double lastTenured = 0.0;
        double lastYoung = 0.0;
        Iterator i = model.getGCEvents();
        while (i.hasNext()) {
            GCEvent event = (GCEvent)i.next();
            double tenured = 0.0;
            double young = 0.0;
            Iterator iterator = event.details();
            while (iterator.hasNext()) {
                double total;
                Object o = iterator.next();
                if (!(o instanceof GCEvent)) continue;
                GCEvent detailEvent = (GCEvent)o;
                if (modelChart.isShowTenured() && detailEvent.getType().getGeneration() == AbstractGCEvent.Generation.TENURED) {
                    total = detailEvent.getTotal();
                    if (total == 0.0) {
                        total = tenured;
                    } else {
                        tenured = total;
                    }
                }
                if (detailEvent.getType().getGeneration() != AbstractGCEvent.Generation.YOUNG) continue;
                total = detailEvent.getTotal();
                if (total == 0.0) {
                    total = young;
                    continue;
                }
                young = total;
            }
            if (modelChart.isShowTenured() && tenured == 0.0 && young != 0.0) {
                tenured = (double)event.getTotal() - young;
            }
            if (young != 0.0) {
                polygon.addPoint(event.getTimestamp(), lastTenured + lastYoung);
                polygon.addPoint(event.getTimestamp() + event.getPause(), tenured + young);
                lastYoung = young;
            }
            if (tenured == 0.0) continue;
            lastTenured = tenured;
        }
        polygon.addPoint(model.getRunningTime(), lastTenured + lastYoung);
        polygon.addPoint(model.getRunningTime(), 0.0);
        return polygon;
    }
}

