/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.util;

import com.tagtraum.perf.gcviewer.RecentURLsModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class AutoCompletionTextField
extends JTextField
implements ComboBoxEditor {
    private RecentURLsModel recentURLsModel;
    private AutoCompletionComboBoxModel comboBoxModel;
    private List suggestions = new ArrayList();

    public AutoCompletionTextField() {
        this.comboBoxModel = new AutoCompletionComboBoxModel();
        this.setDocument(this.createDefaultModel());
        this.recentURLsModel = new RecentURLsModel();
    }

    public ComboBoxModel getComboBoxModel() {
        return this.comboBoxModel;
    }

    public Component getEditorComponent() {
        return this;
    }

    public void setItem(Object anObject) {
    }

    public Object getItem() {
        return this.getText();
    }

    public void setRecentURLsModel(RecentURLsModel recentURLsModel) {
        this.recentURLsModel = recentURLsModel;
    }

    protected Document createDefaultModel() {
        return new PlainDocument(){

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                String text = this.getText(0, offs) + str;
                List oldSuggestions = AutoCompletionTextField.this.suggestions;
                AutoCompletionTextField.this.suggestions = AutoCompletionTextField.this.recentURLsModel.getURLsStartingWith(text);
                String appendString = "";
                if (!AutoCompletionTextField.this.suggestions.isEmpty()) {
                    String suggestion = (String)AutoCompletionTextField.this.suggestions.get(0);
                    appendString = suggestion.substring(text.length());
                }
                super.insertString(offs, str + appendString, a);
                AutoCompletionTextField.this.setCaretPosition(offs);
                AutoCompletionTextField.this.setSelectionStart(text.length());
                AutoCompletionTextField.this.setSelectionEnd(this.getLength());
                if (!((Object)oldSuggestions).equals(AutoCompletionTextField.this.suggestions)) {
                    AutoCompletionTextField.this.comboBoxModel.fireContentsChanged();
                }
            }

            public void remove(int offs, int len) throws BadLocationException {
                super.remove(offs, len);
                List oldSuggestions = AutoCompletionTextField.this.suggestions;
                AutoCompletionTextField.this.suggestions = AutoCompletionTextField.this.recentURLsModel.getURLsStartingWith(AutoCompletionTextField.this.getText());
                if (!((Object)oldSuggestions).equals(AutoCompletionTextField.this.suggestions)) {
                    AutoCompletionTextField.this.comboBoxModel.fireContentsChanged();
                }
            }
        };
    }

    private class AutoCompletionComboBoxModel
    implements ComboBoxModel {
        private List listDataListeners = new ArrayList();
        private Object selected;

        public void setSelectedItem(Object anItem) {
            this.selected = anItem;
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public int getSize() {
            return AutoCompletionTextField.this.suggestions.size();
        }

        public Object getElementAt(int index) {
            return AutoCompletionTextField.this.suggestions.get(index);
        }

        public void addListDataListener(ListDataListener l) {
            this.listDataListeners.add(l);
        }

        public void removeListDataListener(ListDataListener l) {
            this.listDataListeners.remove(l);
        }

        private void fireContentsChanged() {
            for (int i = 0; i < this.listDataListeners.size(); ++i) {
                ((ListDataListener)this.listDataListeners.get(i)).contentsChanged(new ListDataEvent(this, 0, 0, this.getSize() - 1));
            }
        }
    }
}

