/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TimeFormat
extends DateFormat {
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private SimpleDateFormat secondsFormat = new SimpleDateFormat("s's'");
    private SimpleDateFormat minuteFormat = new SimpleDateFormat("m'm'");
    private SimpleDateFormat hourFormat = new SimpleDateFormat("H'h'");
    private DateFormat fullFormat = DateFormat.getDateTimeInstance(3, 2);

    public TimeFormat() {
        TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
        this.minuteFormat.setTimeZone(utcTimeZone);
        this.hourFormat.setTimeZone(utcTimeZone);
    }

    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        long time = date.getTime();
        if (time >= 31536000000L) {
            return this.fullFormat.format(date, toAppendTo, fieldPosition);
        }
        if (time >= 259200000L) {
            toAppendTo.append(time / 86400000L);
            toAppendTo.append('d');
            if (time % 86400000L != 0L) {
                this.hourFormat.format(date, toAppendTo, fieldPosition);
            }
        } else if (time >= 3600000L) {
            toAppendTo.append(time / 3600000L);
            toAppendTo.append('h');
        }
        if (time >= 60000L && time % 3600000L != 0L) {
            this.minuteFormat.format(date, toAppendTo, fieldPosition);
        }
        if (time >= 1000L && time % 60000L != 0L) {
            this.secondsFormat.format(date, toAppendTo, fieldPosition);
        }
        return toAppendTo;
    }

    public Date parse(String source, ParsePosition pos) {
        throw new RuntimeException("Not implemented.");
    }
}

