/*
 * Decompiled with CFR 0.152.
 */
package gudusoft.gsqlparser.pp.processor.type.select;

import gudusoft.gsqlparser.EJoinType;
import gudusoft.gsqlparser.TSourceToken;
import gudusoft.gsqlparser.nodes.TJoin;
import gudusoft.gsqlparser.nodes.TJoinItem;
import gudusoft.gsqlparser.nodes.TJoinList;
import gudusoft.gsqlparser.nodes.TParseTreeNodeList;
import gudusoft.gsqlparser.nodes.TTableList;
import gudusoft.gsqlparser.pp.mediator.MediatorFactory;
import gudusoft.gsqlparser.pp.mediator.type.KeywordAlignMediator;
import gudusoft.gsqlparser.pp.processor.type.comm.AbstractProcessor;
import gudusoft.gsqlparser.pp.processor.type.comm.ExpressionProcessor;
import gudusoft.gsqlparser.pp.utils.SourceTokenOperator;
import gudusoft.gsqlparser.pp.utils.SourceTokenSearcher;
import gudusoft.gsqlparser.stmt.TSelectSqlStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinOnProcessor
extends AbstractProcessor<TSelectSqlStatement> {
    @Override
    public void process(TSelectSqlStatement tParseTreeNode) {
        boolean bl = this.getParameter(Boolean.class);
        boolean bl2 = this.getParameter(Boolean.class, 1);
        TTableList tTableList = ((TSelectSqlStatement)tParseTreeNode).tables;
        tParseTreeNode = ((TSelectSqlStatement)tParseTreeNode).joins;
        if (tTableList.size() == 0) {
            return;
        }
        int n2 = SourceTokenOperator.curColumnNumberVT(tTableList.getElement(0).getStartToken());
        for (int i2 = 0; i2 < ((TParseTreeNodeList)tParseTreeNode).size(); ++i2) {
            TJoin tJoin = ((TJoinList)tParseTreeNode).getJoin(i2);
            for (int i3 = 0; i3 < tJoin.getJoinItems().size(); ++i3) {
                Object object;
                TJoinItem tJoinItem = tJoin.getJoinItems().getJoinItem(i3);
                if (tJoinItem == null) continue;
                TSourceToken tSourceToken = tJoinItem.getStartToken();
                SourceTokenOperator.removeAllBeforeTokenVT(this.getOption(), tSourceToken);
                tSourceToken = JoinOnProcessor.getBeginJoinToken(tJoinItem);
                if (tSourceToken != null) {
                    SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), tSourceToken);
                    SourceTokenOperator.addBefore(this.getOption(), tSourceToken, SourceTokenOperator.createReturnSourceToken());
                    if (bl2) {
                        object = MediatorFactory.getMediator(KeywordAlignMediator.class, this.getOption().sessionId);
                        SourceTokenOperator.addBefore(this.getOption(), tSourceToken, SourceTokenOperator.createWhitespaceSourceToken(((KeywordAlignMediator)object).getCurLevelIndentLen()));
                    } else {
                        SourceTokenOperator.addBefore(this.getOption(), tSourceToken, SourceTokenOperator.createWhitespaceSourceToken(n2));
                    }
                }
                if (tJoinItem.getOnCondition() == null || (object = SourceTokenSearcher.lastSelectedNotWhitespaceAndReturnToken(tJoinItem.getOnCondition().getStartToken(), "on")) == null || !bl) continue;
                SourceTokenOperator.removeWhitespaceAndReturnFromEnd(this.getOption(), (TSourceToken)object);
                SourceTokenOperator.addBefore(this.getOption(), (TSourceToken)object, SourceTokenOperator.createReturnSourceToken());
                SourceTokenOperator.addBefore(this.getOption(), (TSourceToken)object, SourceTokenOperator.createWhitespaceSourceToken(n2));
            }
            if (tJoin.getTable() == null || tJoin.getTable().getSubquery() == null) continue;
            ExpressionProcessor.processParenthesesNodeInSubQuery(this.getOption(), tJoin.getTable().getSubquery(), tJoin.getTable().getSubquery().getStartToken(), tJoin.getTable().getSubquery().getEndToken());
        }
    }

    public static TSourceToken getBeginJoinToken(TJoinItem tJoinItem) {
        TSourceToken tSourceToken = tJoinItem.getStartToken();
        TSourceToken tSourceToken2 = null;
        if (tJoinItem.getJoinType() == EJoinType.cross || tJoinItem.getJoinType() == EJoinType.crossapply) {
            tSourceToken2 = SourceTokenSearcher.backforwardSearch(tSourceToken, 5, "cross");
        } else if (tJoinItem.getJoinType() == EJoinType.full || tJoinItem.getJoinType() == EJoinType.fullouter) {
            tSourceToken2 = SourceTokenSearcher.backforwardSearch(tSourceToken, 10, "full");
        } else if (tJoinItem.getJoinType() == EJoinType.inner) {
            tSourceToken2 = SourceTokenSearcher.backforwardSearch(tSourceToken, 5, "inner");
            if (tSourceToken2 == null) {
                tSourceToken2 = SourceTokenSearcher.backforwardSearch(tSourceToken, 5, "join");
            }
        } else if (tJoinItem.getJoinType() == EJoinType.left || tJoinItem.getJoinType() == EJoinType.leftouter) {
            tSourceToken2 = SourceTokenSearcher.backforwardSearch(tSourceToken, 10, "left");
        } else if (tJoinItem.getJoinType() == EJoinType.natural) {
            tSourceToken2 = SourceTokenSearcher.backforwardSearch(tSourceToken, 5, "natural");
        } else if (tJoinItem.getJoinType() == EJoinType.nested) {
            tSourceToken2 = SourceTokenSearcher.backforwardSearch(tSourceToken, 5, "nested");
        } else if (tJoinItem.getJoinType() == EJoinType.right || tJoinItem.getJoinType() == EJoinType.rightouter) {
            tSourceToken2 = SourceTokenSearcher.backforwardSearch(tSourceToken, 10, "right");
        } else if (tJoinItem.getJoinType() == EJoinType.outerapply) {
            tSourceToken2 = SourceTokenSearcher.backforwardSearch(tSourceToken, 5, "outer");
        }
        return tSourceToken2;
    }
}

