package demos.columnInWhereClause;

import gudusoft.gsqlparser.nodes.IExpressionVisitor;
import gudusoft.gsqlparser.nodes.TExpression;
import gudusoft.gsqlparser.nodes.TParseTreeNode;

public class WhereCondition implements IExpressionVisitor
{

	private TExpression condition;

	public WhereCondition( TExpression expr )
	{
		this.condition = expr;
	}

	public void printColumn( )
	{
		this.condition.inOrderTraverse( this );
	}

	boolean is_compare_condition( int t )
	{
		return ( ( t == TExpression.simple_comparison_conditions )
				|| ( t == TExpression.group_comparison_conditions ) || ( t == TExpression.in_conditions ) );
	}

	public boolean exprVisit( TParseTreeNode pnode, boolean pIsLeafNode )
	{
		TExpression lcexpr = (TExpression) pnode;
		if ( is_compare_condition( lcexpr.getExpressionType( ) ) )
		{
			TExpression leftExpr = (TExpression) lcexpr.getLeftOperand( );

			System.out.println( "column: " + leftExpr.toString( ) );
			if ( lcexpr.getComparisonOperator( ) != null )
			{
				System.out.println( "Operator: "
						+ lcexpr.getComparisonOperator( ).astext );
			}
			System.out.println( "value: "
					+ lcexpr.getRightOperand( ).toString( ) );
			System.out.println( "" );

		}
		return true;
	}
}
