// toolbar variables
//  0 -
//  1 -  
//  2 -  proxies xml from server if logged in, empty if not logged in
//  3 -  applied proxy (Item ID from combobox)
//  4 -  history of proxy (<Item ID 1>|<Item ID 2>|<Item ID 3> )
//  5 -  current Login
//  6 -  current Password
//  7 -  clearcookie flag (1 - clear, other - don't clear)
//  8 -  clearhistory flag (1 - clear, other - don't clear)
//  9 -
// 10 -

var _tool = null;

function debugmsg(m)
{
//	MainWindow.document.parentWindow.alert(m);
	alert(m);
}

function setGeogToolHiddenState(hidden)
{
  if(typeof(_tool.geogToolHiddenState) == "function")
	  _tool.geogToolHiddenState(hidden);
  else {
    //_tool.SetPropertyById("tbs_button_geog_tool", "SkipSync", 1);
    _tool.SetPropertyById("tbs_button_geog_tool", "visibility", hidden?0:1);
    _tool.SetPropertyById("tbs_button_geog_tool_space", "visibility", hidden?0:1);
    _tool.SetPropertyById("tbs_button_geog_tool_sep", "visibility", hidden?0:1);
    _tool.SetPropertyById("tbs_button_geog_tool_space2", "visibility", hidden?0:1);
    _tool.Reload();
  }
}

function setVariable(name, text)
{
    try
    {
	    _tool.Var(name) = text;
    }catch (e)
    {
        try
        {
    	  _tool.Var[name] = text;
		  try{
	        _tool.saveData();
		  }catch (e){ debugmsg(e); }
    	}catch(e){ debugmsg(e); }
    }
}

function getVariable(name)
{
    var res;
    try
    {
        res = _tool.Var(name);
    }catch (e)
    {
      try{
	    _tool.loadData();
      }catch (e){ debugmsg(e); }
      res = _tool.Var[name];
      if (res == "0") res = "";
    }
    return res;
}

function ToolBarInit(tool)
{
	_tool = tool;
//	debugmsg('ToolBarInit');
    try
    {
    }catch(e)
	{ debugmsg(e.message); }
}

function Launch(tool, param)
{

  _tool = tool;
//  debugmsg('Launch logout');
//  debugmsg('Launch param = ' + param);
  try
  {
	_tool.userName = "";
	_tool.userPasswd = "";
	curLogin = "";
	curPasswd = "";
	setVariable(5,"");
	setVariable(6,"");
	setVariable(2,"")
	setVariable(3,'-1')
	setVariable(4,'')

	_tool.CallCmd("xproxy_cmd_apply_none");
	SetXml('HistorySection','<toolbar></toolbar>');
	_tool.CallCmd("getproxieslist");
	setGeogToolHiddenState(true);
	if (_tool.agentHiddenState)
		_tool.agentHiddenState(true);
	
   } catch(e)
   { debugmsg(e); }
}

function SetXml(section, textXml)
{
    try
    {
        _tool.setCustomXML(section, textXml);
        _tool.ReloadAllToolbars();		//-- reload it\\
    } catch(e)
    {
		try{
            _tool.CustomXML(section) = textXml;
            _tool.ReloadAllToolbars();		//-- reload it\\
		} catch(e)
		{
			debugmsg(e);
		}
    }
}

function SetXmlN(section, textXml)
{
    try
    {
        _tool.setCustomXML(section, textXml);
    } catch(e)
    {
		try{
            _tool.CustomXML(section) = textXml;
		} catch(e)
		{
			debugmsg(e);
		}
    }
}

