///
/***

    [SetProxy command 26.06.2009]
    xertive solution

***/
//////////////////////////////////////////////////////////////////////////
function xertive_parse_address(address)
{
	try
	{		
		var nProxyTypeNoProxy = 0;
		var nProxyTypeSetByUser = 1;
		if( !address || address == 'undefined' || address.length == 0 )
		{
			xertive_pref("network.proxy.type",nProxyTypeNoProxy);
			//alert('address undefined');
			return true;
		}
		var sAddress = null;
		var sPort = null;
		for(i=address.length-1;i>=0;i--)
		{
			if( address[i] == ':' )
			{
				if( i+2 < address.length )
				{
					// So if we found :// - that's mean port not specified
					if( address[i+1] == '/' && address[i+2] == '/' )
					{
						//alert('protocol found');
						return false;
					}
				}
				sAddress = address.substr(0,i);
				sPort = address.substr(i+1);
				break;
			}
		}
		// If port not found
		if( sAddress == null || sPort == null )
		{			
			//alert('port not found');
			xertive_pref("network.proxy.type",nProxyTypeNoProxy);
			return false;
		}
		// Saving settings
		// Setting 
		xertive_pref("network.proxy.type",nProxyTypeSetByUser);
		// Saving addresses
		xertive_pref("network.proxy.backup.http",xertive_load_pref("network.proxy.http"),"");
		xertive_pref("network.proxy.backup.gopher",xertive_load_pref("network.proxy.gopher"),"");
		xertive_pref("network.proxy.backup.ssl",xertive_load_pref("network.proxy.ssl"),"");
		xertive_pref("network.proxy.backup.ftp",xertive_load_pref("network.proxy.ftp"),"");
		xertive_pref("network.proxy.backup.socks",xertive_load_pref("network.proxy.socks"),"");
		// Saving ports	
		xertive_pref("network.proxy.backup.gopher_port",xertive_getPref("network.proxy.gopher_port"));			
		xertive_pref("network.proxy.backup.ssl_port",xertive_getPref("network.proxy.ssl_port"));
		xertive_pref("network.proxy.backup.ftp_port",xertive_getPref("network.proxy.ftp_port"));
		xertive_pref("network.proxy.backup.socks_port",xertive_getPref("network.proxy.socks_port"));
		
		var sHttpPortBackup = xertive_getPref("network.proxy.backup.http_port");
		var sHttpPort = xertive_getPref("network.proxy.http_port");
		var sTypeof = typeof( sHttpPortBackup );
		if( sTypeof == "number" )
		{
			xertive_pref( "network.proxy.backup.http_port",sHttpPort );
		}
		else if( sTypeof == "string" )
		{
			xertive_pref("network.proxy.backup.http_port",sHttpPort.toString() );
		}				
		// Setting up proxy address		
		xertive_pref("network.proxy.http",sAddress);
		xertive_pref("network.proxy.gopher",sAddress);
		xertive_pref("network.proxy.ssl",sAddress);
		xertive_pref("network.proxy.ftp",sAddress);
		xertive_pref("network.proxy.socks",sAddress);
		// Setting up proxy port
		xertive_pref("network.proxy.http_port", parseInt(sPort) );
		xertive_pref("network.proxy.gopher_port", parseInt(sPort) );
		xertive_pref("network.proxy.ssl_port", parseInt(sPort) );
		xertive_pref("network.proxy.ftp_port", parseInt(sPort) );
		xertive_pref("network.proxy.socks_port", parseInt(sPort) );
		// Ok
		BrowserReload();

		return true;
	}
	catch(e)
	{
		//alert('exception: '+e);
		return false;
	}
}

//////////////////////////////////////////////////////////////////////////
function getVariable(name)
{
    var res;
    try
    {
        res = xertive_tool.Var(name);
    }catch (e)
    {
      try{
	    xertive_tool.loadData();
      }catch (e){ debugmsg(e); }
      res = xertive_tool.Var[name];
      if (res == "0") res = "";
    }
    return res;
}

function xertive_ffsetproxy(proxyname, force)
{
	var clearCookie = getVariable(7);
	var clearCache = getVariable(8);
	
	var strProxy = proxyname;
	
	if ( force==false && proxyname=='none' )
	{
		strProxy = getVariable(9);
		if (strProxy=='')
			strProxy = 'none';
	}

	if ( clearCookie == '1' )
		xertive_callcmd('clearCookies');
		
	if ( clearCache == '1' )
		xertive_callcmd('clearCache');


    try 
    {       
        xertive_parse_address(strProxy);
    }
    catch(e) 
    {
        if(debugmode)alert(e);
    }
}
///