// toolbar variables
//  0 -
//  1 -  
//  2 -  proxies xml from server if logged in, empty if not logged in
//  3 -  applied proxy (Item ID from combobox)
//  4 -  history of proxy (<Item ID 1>|<Item ID 2>|<Item ID 3> )
//  5 -  current Login
//  6 -  current Password
//  7 -  clearcookie flag (1 - clear, other - don't clear)
//  8 -  clearhistory flag (1 - clear, other - don't clear)
//  9 -
// 10 -

var _tool = null;
var wnd = null;
var timer1 = null;
var xml1 = "";
var glob_applied = "";
var show_rss = false;
var g_upgradeXML = "<toolbar><BUTTON id=\"tbs_button_upgrade\" caption=\"Upgrade GeoSurf\" type=\"Split\" visibility=\"1\" command=\"redirect\" image=\"upgrade.png\" href=\"http://www.geosurf.com/?action=upgd\" hint=\"Click to upgrade your GeoSurf Account today!\"/><SPACE id=\"tbs_space_028823\" width=\"4\"/><SEPARATOR id=\"tbs_separator_026924\" resizeable=\"0\"/></toolbar>";

var countries1 = { 'ad':0,'ae':1,'af':2,'ag':3,'ai':4,'al':5,'am':6,'an':7,'ao':8,'ar':9,'as':10,'at':11,'au':12,'aw':13,
'az':14,'ba':15,'bb':16,'bd':17,'be':18,'bf':19,'bg':20,'bh':21,'bi':22,'bj':23,'bm':24,'bn':25,'bo':26,
'br':27,'bs':28,'bt':29,'bw':30,'by':31,'bz':32,'ca':33,'cd':34,'cf':35,'cg':36,'ch':37,'ci':38,'ck':39,
'cl':40,'cm':41,'cn':42,'co':43,'cr':44,'cu':45,'cv':46,'cy':47,'cz':48,'de':49,'dj':50,'dk':51,'dm':52,
'do':53,'dz':54,'ec':55,'ee':56,'eg':57,'eh':58,'england':59,'er':60,'es':61,'et':62,'europe':63,'fi':64,
'fj':65,'fk':66,'fm':67,'fo':68,'fr':69,'ga':70,'gb':71,'gd':72,'ge':73,'gg':74,'gh':75,'gi':76,'gl':77,
'gm':78,'gn':79,'gq':80,'gr':81,'gs':82,'gt':83,'gu':84,'gw':85,'gy':86,'hk':87,'hn':88,'hr':89,'ht':90,
'hu':91,'id':92,'ie':93,'il':94,'im':95,'in':96,'io':97,'iq':98,'ir':99,'is':100,'it':101,'je':102,'jm':103,
'jo':104,'jp':105,'ke':106,'kg':107,'kh':108,'ki':109,'km':110,'kn':111,'kp':112,'kr':113,'kw':114,'ky':115,
'kz':116,'la':117,'lb':118,'lc':119,'li':120,'lk':121,'lr':122,'ls':123,'lt':124,'lu':125,'lv':126,'ly':127,
'ma':128,'mc':129,'md':130,'mg':131,'mh':132,'mk':133,'ml':134,'mm':135,'mn':136,'mo':137,'mp':138,'mq':139,
'mr':140,'ms':141,'mt':142,'mu':143,'mv':144,'mw':145,'mx':146,'my':147,'mz':148,'na':149,'ne':150,'nf':151,
'ng':152,'ni':153,'nl':154,'no':155,'north_cyprus_turk_republic':156,'np':157,'nr':158,'nu':159,'nz':160,
'olympia':161,'om':162,'pa':163,'pe':164,'pf':165,'pg':166,'ph':167,'pk':168,'pl':169,'pm':170,'pn':171,
'pr':172,'pt':173,'pw':174,'py':175,'qa':176,'ro':177,'ru':178,'rw':179,'sa':180,'sb':181,'sc':182,'scotland':183,
'sd':184,'se':185,'serbia_montenegro':186,'sg':187,'sh':188,'si':189,'sk':190,'sl':191,'sm':192,'sn':193,'so':194,
'sr':195,'st':196,'sv':197,'sy':198,'sz':199,'tc':200,'td':201,'tg':202,'th':203,'tibet':204,'tj':205,'tl':206,
'tm':207,'tn':208,'to':209,'tr':210,'tt':211,'tv':212,'tw':213,'tz':214,'ua':215,'ug':216,'us':217,'uy':218,
'uz':219,'va':220,'vc':221,'ve':222,'vg':223,'vi':224,'vn':225,'vu':226,'wales':227,'wf':228,'ws':229,'ye':230,
'za':231,'zm':232,'zw':233 };

function debugmsg(m)
{
//	MainWindow.document.parentWindow.alert(m);
//	alert('section_loader.js : ' + m);
}

//debugmsg('init script');

try
{
//	alert(ToolbarControl);
    if (typeof ToolbarControl != "undefined")
        initProxyList(ToolbarControl);
//	debugmsg('init section_loader.js');
	if (_tool!=null)
	{
		if(window.addEventListener) // Mozilla, Netscape, Firefox
			var i = 1;
//			_tool.addEventListener('ToolbarReload', OnReloadToolbar, false);
		else // IE
			_tool.attachEvent('ToolbarReload', OnReloadToolbar);
	}
} catch(e)
{
    debugmsg('initialization: '+ e);
}

function getNodeByName(owner, name)
{
    try
    {
		if ( owner!=null && owner.selectSingleNode("//" + name) )
			return owner.selectSingleNode("//" + name).text;
    } catch(e)
    {
		try
		{
			//alert(owner.getElementsByTagName(name)[0].childNodes[0].nodeValue)
			var node = owner.getElementsByTagName(name)[0];
			if ( node!=null && node!=0 && node!="" && node.childNodes[0])
				return node.childNodes[0].nodeValue;
			else
				return null;
		} catch (e)
		{ debugmsg('getNodeByName(): ' + e);}
    }
    return "";
}

function GetCodeIndex(code)
{
try{
	if ( code=="" )
		return 1;
	var ind = countries1[code.toLowerCase()];
	if (ind!=null)
		return 3 + ind;
	}
	catch (e)
	{
		debugmsg('GetCodeIndex(code): ' + e);
	}
	return 1;
}

function GetSelectedCodeIndex(code)
{
	var ind = GetCodeIndex(code);
//	if (ind!=1)
//		ind += 234;
	return ind;
}

function GetDisabledCodeIndex(code)
{
	var ind = GetCodeIndex(code);
//	if (ind!=1)
//		ind += 234*2;
	return ind;
}

function GetXmlFromText(text)
{
  var xmlDoc = null;
//  alert(text);
  if (typeof text=='undefined' || text == '' || text==null)
	return null;
  try //Internet Explorer
  {
    xmlDoc=new ActiveXObject("Microsoft.XMLDOM");
    xmlDoc.async="false";
    xmlDoc.loadXML(text);
  }
  catch(e)
  {
        parser=new DOMParser();	
        xmlDoc=parser.parseFromString(text,"text/xml");				
        if (xmlDoc == 0)
        {	
            return null;
        } else
        {
            return xmlDoc;
        }
  }
  if (xmlDoc.parseError.errorCode  != 0)
  {
    return null;
  }
  return xmlDoc;
}

function initProxyList(tool)
{
    try
    {
        _tool = tool;
		if(typeof(tool.agentHiddenState) == "function")
		{
//			tool.agentHiddenState(true);
		}
		else
			tool.SetPropertyById("tbs_button_agent", "visibility", 0);
        glob_applied = getVariable(3);
		var savedList = getVariable(2);
        var xmlDoc = GetXmlFromText(savedList);
        UpdateMenu(xmlDoc,glob_applied);
    } catch(e) 
	{ debugmsg('initProxyList(tool): '+e); }
}

function setVariable(name, text)
{
    try
    {
	    _tool.Var(name) = text;
    }catch (e)
    {
        try
        {
    	  _tool.Var[name] = text;
		  try{
	        _tool.saveData();
		  }catch (e){ debugmsg('setVariable(name, text) 1 : ' + e); }
    	}catch(e){ debugmsg('setVariable(name, text) 2 : ' + e); }
    }
}

function getVariable(name)
{
    var res;
    try
    {
        res = _tool.Var(name);
    }catch (e)
    {
      try{
	    _tool.loadData();
      }catch (e){ debugmsg('getVariable(name) : '+ e); }
      res = _tool.Var[name];
      if (res == "0") res = "";
    }
    return res;
}

function ToolBarInit(tool)
{
	_tool = tool;
	if(window.addEventListener) // Mozilla, Netscape, Firefox
//		_tool.addEventListener('ToolbarReload', OnReloadToolbar, false);
		var i = 1;
	else // IE
		_tool.attachEvent('ToolbarReload', OnReloadToolbar);
//	debugmsg('ToolBarInit');
    try
    {
        initProxyList(tool);
    }catch(e)
	{ debugmsg('ToolBarInit(tool): ' +e); }
}

function OnReloadToolbar()
{
//	debugmsg('OnReloadToolbar()');
	if (_tool!=null)
	{
		var curItem = getVariable(3);
		if (  typeof curItem=='undefined' || curItem==null || curItem=='' || curItem==-1 )
			_tool.SetPropertyById('tbs_button_power','image','off-BT.png');
		else
			_tool.SetPropertyById('tbs_button_power','image','on-BT.png');

		var oldIt = _tool.GetPropertyById('tbs_combo_countries','applieditem');
		_tool.SetPropertyById('tbs_combo_countries','applieditem',curItem);
	}
}

function Launch(tool, param)
{
  _tool = tool;
//  debugmsg('Launch param = ' + param);
  try
  {
      glob_applied = getVariable(3);
      if ( param=="" || param==null || typeof param == undefined )
      {
        xmlDoc = GetXmlFromText(getVariable(2));
        UpdateMenu(xmlDoc,glob_applied);
      } else
      {
        xmlDoc = GetXmlFromText(getVariable(2));
        UpdateMenu(xmlDoc, param);
      }
   } catch(e){ debugmsg('Launch(tool, param): ' + e); }
}
function GetXml(section)
{
	var res = '';
	try{
        res = _tool.getCustomXML(section);

	} catch(e)
	{
		try{
			res = _tool.CustomXML(section);
		}
		catch (e)
		{
			debugmsg('GetXml(section): ' + e.message);
		}
	}
	return res;
}
function SetXml(section, textXml)
{
//	alert('SetXml' + section + '' + textXml);
    try
    {
        _tool.setCustomXML(section, textXml);
        _tool.ReloadAllToolbars();		//-- reload it\\
    } catch(e)
    {
		try{
            _tool.CustomXML(section) = textXml;
            _tool.ReloadAllToolbars();		//-- reload it\\
		} catch(e)
		{
			debugmsg('SetXml(section, textXml): ' + e);
		}
    }
}

function SetXmlN(section, textXml)
{
//	alert('SetXmlN' + section + '' + textXml);
    try
    {
        _tool.setCustomXML(section, textXml);
        _tool.ReloadAllToolbars();		//-- reload it\\
    } catch(e)
    {
		try{
            _tool.CustomXML(section) = textXml;
        _tool.ReloadAllToolbars();		//-- reload it\\
		} catch(e)
		{
			debugmsg('SetXmlN(section, textXml): '+e);
		}
    }
}

function UpdateMenu(xmlDoc, applied)
{
 try{
	var resXml = "";
	var mode = 2;

	var upgrade = getNodeByName(xmlDoc,"upgrade");
	if (upgrade=='true')
		SetXmlN('UpgradeButton',g_upgradeXML);
	else
		SetXmlN('UpgradeButton','<toolbar></toolbar>');

    _tool.SetPropertyById('tbs_combo_countries','selecteditem',applied);
    _tool.SetPropertyById('tbs_combo_countries','applieditem',applied);

    var commXml = "<COMMANDS>";// +
//		"<LAUNCHSCRIPT name=\"xproxy_cmd_item_none\" scriptid=\"tbs_include_script_004328\" param=\"none\"/>";
	var elemXml = "";
    var elemXmlInactive = "";

    elemXml = 
//"<COMBO id=\"tbs_combo_01231239296\" name=\"search\" dwidth=\"160\" fname=\"Tahoma\" fsize=\"13\" kind=\"editable\" limit=\"40\" histmax=\"10\" ptext=\"\" warning=\"\"><WIDTH>160</WIDTH></COMBO>"+
	"<COMBO id=\"tbs_combo_countries\" name=\"countries\" dwidth=\"200\" fname=\"Tahoma\" fsize=\"13\" kind=\"noneditable\" limit=\"40\" histmax=\"10\" ptext=\"Choose country\" pimg=\"\" checkimg=\"2\">";

    var oNodeList = null;
	var loginXml = '';
//	alert(xmlDoc);
    if (xmlDoc!=null)
	{
      oNodeList = xmlDoc.getElementsByTagName("proxy");
	  loginXml = '<toolbar><BUTTON id="tbs_button_login" caption="Logout" type="Single" visibility="1" image="user.png" command="xproxy_cmd_logout" hint=\"Logout from GeoSurf\"/></toolbar>';
	} else
	{
	  loginXml = '<toolbar><BUTTON id="tbs_button_login" caption="Login" type="Single" visibility="1" image="user.png" command="tbscmd_tbs_bubble_login" hint=\"Login to GeoSurf\"/></toolbar>';
	}
    if (oNodeList!=null)
    {
      for (i=0; i< oNodeList.length; i++)
      {
        var elem = oNodeList.item(i);
        var serverport = elem.getAttribute("server") + ":" + elem.getAttribute("port");
        var name = elem.getAttribute("name");
        var active = elem.getAttribute("active");
        if ( mode == 2 && active != 'yes' )
          continue;

        var code = elem.getAttribute("code");
        if (code==null)
          code = "";
        if (name==null)
          name = serverport;

        if ( active!='no' || active=="yes" || active==null )
        {
          var index = GetCodeIndex(code);
          elemXml += "<VALUE img=\""+index+"\" display=\""+name+"\" value=\"" + code + "\" code=\"" + serverport + "\" />";
        } else
        {
          var index = GetDisabledCodeIndex(code);
          elemXmlInactive += "<VALUE img=\""+index+"\" display=\""+name+"\" value=\"" + code + "\" code=\"" + serverport + "\" />";
        }
      }
      if (elemXmlInactive!="")
      {
        elemXml	+= "<VALUE id=\"tbs_separator_025496\" display=\"Inactive countries:\"/>";
        elemXml += elemXmlInactive;
	  }
    }
    elemXml += "</COMBO>"
    commXml +=  "</COMMANDS>";

	resXml = "<toolbar>" + commXml + elemXml + "</toolbar>";
//    debugmsg(resXml);

	var histxml= GetXml('HistorySection');
	if (getVariable(4)=='' || histxml==null || histxml=='')
		SetXmlN('HistorySection', '<toolbar></toolbar>');
	  
    SetXmlN('LoginButton',loginXml);
	SetXml("ProxyList", resXml);


  } catch(e)
  {
	debugmsg('UpdateMenu(xmlDoc, applied): ' + e);
  }
}

