#region Licensing Header
// ---------------------------------------------------------------------------------
//  Copyright (C) 2007-2011 Chillisoft Solutions
//  
//  This file is part of the Habanero framework.
//  
//      Habanero is a free framework: you can redistribute it and/or modify
//      it under the terms of the GNU Lesser General Public License as published by
//      the Free Software Foundation, either version 3 of the License, or
//      (at your option) any later version.
//  
//      The Habanero framework is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU Lesser General Public License for more details.
//  
//      You should have received a copy of the GNU Lesser General Public License
//      along with the Habanero framework.  If not, see <http://www.gnu.org/licenses/>.
// ---------------------------------------------------------------------------------
#endregion
using Habanero.Base;
using Habanero.Util;

namespace Habanero.Faces.Base
{
    /// <summary>
    /// Manages a filter clause that filters which data to
    /// display in a DataView, according to some criteria set on a string column
    /// </summary>
    public class DataViewStringFilterClause : DataViewFilterClause
    {
        /// <summary>
        /// Constructor to create a new filter clause
        /// </summary>
        /// <param name="filterColumn">The column of data on which to do the
        /// filtering</param>
        /// <param name="clauseOperator">The clause operator</param>
        /// <param name="filterValue">The filter value to compare to</param>
        internal DataViewStringFilterClause(string filterColumn, FilterClauseOperator clauseOperator, string filterValue)
            : base(filterColumn, clauseOperator, filterValue)
        {
        }

        ///// <summary>
        ///// Returns the filter value as a string
        ///// </summary>
        ///// <returns>Returns a string</returns>
        //protected override string CreateValueClause()
        //{

        //}

        /// <summary>
        /// Returns the value part of the clause
        /// </summary>
        /// <returns>Returns a string</returns>
        protected override string CreateValueClause(string stringLikeDelimiter, string dateTimeDelimiter)
        {
            string valueClause;
            string finalFilterValue =
                StringUtilities.ReplaceSingleQuotesWithTwo((string)_filterValue);
            switch (_clauseOperator)
            {
                case FilterClauseOperator.OpLike:
                    valueClause = "'" + stringLikeDelimiter + finalFilterValue + stringLikeDelimiter + "'";
                    break;
                case FilterClauseOperator.Is:
                    valueClause = finalFilterValue;
                    break;
                default:
                    valueClause = "'" + finalFilterValue + "'";
                    break;
            }
            return valueClause;
        }
    }
}