#region Licensing Header
// ---------------------------------------------------------------------------------
//  Copyright (C) 2007-2011 Chillisoft Solutions
//  
//  This file is part of the Habanero framework.
//  
//      Habanero is a free framework: you can redistribute it and/or modify
//      it under the terms of the GNU Lesser General Public License as published by
//      the Free Software Foundation, either version 3 of the License, or
//      (at your option) any later version.
//  
//      The Habanero framework is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU Lesser General Public License for more details.
//  
//      You should have received a copy of the GNU Lesser General Public License
//      along with the Habanero framework.  If not, see <http://www.gnu.org/licenses/>.
// ---------------------------------------------------------------------------------
#endregion
using Habanero.Faces.Test.Base;
using Habanero.Faces.Base;
using Habanero.Faces.Win;
using NUnit.Framework;

namespace Habanero.Faces.Test.Win.LayoutManager
{
    [TestFixture]
    public class TestFlowLayoutManagerWin : TestFlowLayoutManager
    {
        protected override IControlFactory GetControlFactory()
        {
            return new ControlFactoryWin();
        }

        //Note:this doesn't work in VWG in testing mode
        [Test]
        public void TestCentreAlignRowOneControl()
        {
            //---------------Set up test pack-------------------
            IControlHabanero managedControl = CreateManagedControl();
            FlowLayoutManager manager = CreateFlowLayoutManager(managedControl);
            IControlHabanero ctl = CreateStandardControl();
            //---------------Execute Test ----------------------
            manager.Alignment = FlowLayoutManager.Alignments.Centre;
            manager.AddControl(ctl);
            //---------------Test Result -----------------------
            Assert.AreEqual((_STD_ManagedControl_Width - _STD_CONTROL_WIDTH) / 2, ctl.Left, "Control should be centre aligned.");
        }

        //Note:this doesn't work in VWG in testing mode
        [Test]
        public void TestCentreAlignRowTwoControls()
        {
            //---------------Set up test pack-------------------
            IControlHabanero managedControl = CreateManagedControl();
            FlowLayoutManager manager = CreateFlowLayoutManager(managedControl);
            IControlHabanero ctl1 = CreateStandardControl();
            IControlHabanero ctl2 = CreateStandardControl();
            //---------------Execute Test ----------------------
            manager.Alignment = FlowLayoutManager.Alignments.Centre;
            manager.AddControl(ctl1);
            manager.AddControl(ctl2);
            //---------------Test Result -----------------------
            const int ctl1LeftPos = (_STD_ManagedControl_Width - _STD_CONTROL_WIDTH - _STD_GAP - _STD_CONTROL_WIDTH) / 2;
            const int ctl2LeftPos = ctl1LeftPos + _STD_GAP + _STD_CONTROL_WIDTH;
            Assert.AreEqual(ctl1LeftPos, ctl1.Left, "Control should be centre aligned.");
            Assert.AreEqual(ctl2LeftPos, ctl2.Left, "Control should be centre aligned.");
        }

        //Note_:this doesn't work in VWG in testing mode
        [Test]
        public void TestCentreAlignRowTwoRows()
        {
            //---------------Set up test pack-------------------
            IControlHabanero managedControl = CreateManagedControl();
            FlowLayoutManager manager = CreateFlowLayoutManager(managedControl);
            const int controlWidth = 20;
            const int managedControlWidth = 40;
            IControlHabanero ctl = CreateControl(controlWidth, 10);
            IControlHabanero ctl2 = CreateControl(controlWidth, 10);
            //---------------Execute Test ----------------------
            manager.Alignment = FlowLayoutManager.Alignments.Centre;
            manager.ManagedControl.Width = managedControlWidth;
            manager.AddControl(ctl);
            manager.AddControl(ctl2);
            //---------------Test Result -----------------------
            Assert.AreEqual((managedControlWidth - controlWidth) / 2, ctl.Left, "Control should be centre aligned.");
            Assert.AreEqual((managedControlWidth - controlWidth) / 2, ctl2.Left, "Control should be centre aligned.");
            Assert.AreEqual(StdSecondRowTop(), ctl2.Top, "Control should be in second row.");
        }

        //Note:this doesn't work in VWG in testing mode
        [Test]
        public void TestCentreAlignRowWithInvisibleControls()
        {
            //---------------Set up test pack-------------------
            IControlHabanero managedControl = CreateManagedControl();
            FlowLayoutManager manager = CreateFlowLayoutManager(managedControl);
            const int controlWidth = 20;
            const int managedControlWidth = 100;
            IControlHabanero ctl = CreateControl(controlWidth, 10);
            IControlHabanero ctl2 = CreateControl(controlWidth, 10);
            //---------------Execute Test ----------------------
            manager.Alignment = FlowLayoutManager.Alignments.Centre;
            manager.ManagedControl.Width = managedControlWidth;
            manager.AddControl(ctl);
            ctl2.Visible = false;
            manager.AddControl(ctl2);
            //---------------Test Result -----------------------
            Assert.AreEqual((managedControlWidth - controlWidth) / 2, ctl.Left, "Control should be centre aligned - other Control is invisible.");
        }
    }
}