#region Licensing Header
// ---------------------------------------------------------------------------------
//  Copyright (C) 2007-2011 Chillisoft Solutions
//  
//  This file is part of the Habanero framework.
//  
//      Habanero is a free framework: you can redistribute it and/or modify
//      it under the terms of the GNU Lesser General Public License as published by
//      the Free Software Foundation, either version 3 of the License, or
//      (at your option) any later version.
//  
//      The Habanero framework is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU Lesser General Public License for more details.
//  
//      You should have received a copy of the GNU Lesser General Public License
//      along with the Habanero framework.  If not, see <http://www.gnu.org/licenses/>.
// ---------------------------------------------------------------------------------
#endregion
using System;

namespace Habanero.Base
{
    ///<summary>
    /// Represents the method that will handle an event.
    ///</summary>
    ///<param name="sender">The source of the event.</param>
    ///<param name="eventArgs1">A TEventArgs1 that contains the event data.</param>
    ///<param name="eventArgs2">A TEventArgs2 that contains the event data.</param>
    ///<typeparam name="TEventArgs1">The type of the event data generated by the event for the first parameter.</typeparam>
    ///<typeparam name="TEventArgs2">The type of the event data generated by the event for the second parameter.</typeparam>
    public delegate void EventHandler<TEventArgs1, TEventArgs2>(object sender, TEventArgs1 eventArgs1, TEventArgs2 eventArgs2)
        where TEventArgs1 : EventArgs 
        where TEventArgs2 : EventArgs;
}