/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk;

import java.util.Stack;
import org.nfunk.jep.JEP;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.type.Complex;
import org.opensourcephysics.numerics.MathExpParser;
import org.opensourcephysics.numerics.ParserException;

public class JEParser
extends MathExpParser {
    public static final boolean MAKE_COMPLEX = true;
    public double tol = 1.0E-9;
    JEP jep = new JEP();
    String funcStr = null;
    String[] variables;
    boolean calcLimitValue = true;
    private static JEParser parser;

    public JEParser(String string, String string2) throws ParserException {
        this(string, string2, false);
    }

    public JEParser(String string, String string2, String string3) throws ParserException {
        this(string, string2, string3, false);
    }

    public JEParser(String string, String string2, boolean bl) throws ParserException {
        this.funcStr = string;
        this.variables = new String[1];
        this.variables[0] = string2;
        this.jep.addStandardFunctions();
        this.jep.addStandardConstants();
        this.jep.addFunction("sqrt", new SquareRoot());
        this.jep.addFunction("step", new Step());
        if (bl) {
            this.jep.addComplex();
        }
        this.jep.addVariable(string2, 0.0);
        this.jep.parseExpression(string);
        if (this.jep.hasError()) {
            String string3 = "Error in function string: " + this.funcStr;
            string3 = String.valueOf(string3) + '\n' + "Error: " + this.jep.getErrorInfo();
            throw new ParserException(string3);
        }
    }

    public JEParser(String string, String string2, String string3, boolean bl) throws ParserException {
        this.funcStr = string;
        this.variables = new String[2];
        this.variables[0] = string2;
        this.variables[1] = string3;
        this.jep.addStandardFunctions();
        this.jep.addStandardConstants();
        this.jep.addFunction("sqrt", new SquareRoot());
        this.jep.addFunction("step", new Step());
        if (bl) {
            this.jep.addComplex();
        }
        this.jep.addVariable(string2, 0.0);
        this.jep.addVariable(string3, 0.0);
        this.jep.parseExpression(string);
        if (this.jep.hasError()) {
            String string4 = "Error in function string: " + this.funcStr;
            string4 = String.valueOf(string4) + '\n' + "Error: " + this.jep.getErrorInfo();
            throw new ParserException(string4);
        }
    }

    public JEParser(String string, String[] stringArray, boolean bl) throws ParserException {
        this.funcStr = string;
        this.variables = new String[stringArray.length];
        this.jep.addStandardFunctions();
        this.jep.addStandardConstants();
        this.jep.addFunction("sqrt", new SquareRoot());
        this.jep.addFunction("step", new Step());
        if (bl) {
            this.jep.addComplex();
        }
        int n = 0;
        while (n < stringArray.length) {
            this.variables[n] = stringArray[n];
            this.jep.addVariable(stringArray[n], 0.0);
            ++n;
        }
        this.jep.parseExpression(string);
        if (this.jep.hasError()) {
            String string2 = "Error in function string: " + this.funcStr;
            string2 = String.valueOf(string2) + '\n' + "Error: " + this.jep.getErrorInfo();
            throw new ParserException(string2);
        }
    }

    public JEParser(String string, String[] stringArray) throws ParserException {
        this.funcStr = string;
        this.jep.addStandardFunctions();
        this.jep.addStandardConstants();
        this.jep.addFunction("sqrt", new SquareRoot());
        this.jep.addFunction("step", new Step());
        int n = 0;
        while (n < stringArray.length) {
            this.jep.addVariable(stringArray[n], 0.0);
            ++n;
        }
        this.jep.parseExpression(string);
        if (this.jep.hasError()) {
            String string2 = "Error in function string: " + this.funcStr;
            string2 = String.valueOf(string2) + '\n' + "Error: " + this.jep.getErrorInfo();
            throw new ParserException(string2);
        }
    }

    public void setFunction(String string) throws ParserException {
        this.funcStr = string;
        this.jep.parseExpression(this.funcStr);
        if (this.jep.hasError()) {
            String string2 = "Error in function string: " + this.funcStr;
            string2 = String.valueOf(string2) + '\n' + "Error: " + this.jep.getErrorInfo();
            throw new ParserException(string2);
        }
    }

    public void setToZero() {
        this.funcStr = "0";
        this.jep.parseExpression(this.funcStr);
    }

    public void setFunction(String string, String[] stringArray) throws ParserException {
        this.funcStr = string;
        this.variables = new String[stringArray.length];
        this.jep.initSymTab();
        int n = 0;
        while (n < stringArray.length) {
            this.variables[n] = stringArray[n];
            this.jep.addVariable(this.variables[n], 0.0);
            ++n;
        }
        this.jep.parseExpression(this.funcStr);
        if (this.jep.hasError()) {
            String string2 = "Error in function string: " + this.funcStr;
            string2 = String.valueOf(string2) + '\n' + "Error: " + this.jep.getErrorInfo();
            throw new ParserException(string2);
        }
    }

    public String getFunction() {
        return this.funcStr;
    }

    public boolean hasError() {
        return this.jep.hasError();
    }

    public double evaluate(double d) {
        this.jep.addVariable(this.variables[0], d);
        double d2 = this.jep.getValue();
        if (!Double.isNaN(d2) || !this.calcLimitValue) {
            return d2;
        }
        double d3 = d * 1.0E-5 + this.tol;
        this.jep.addVariable(this.variables[0], d + d3);
        double d4 = this.jep.getValue();
        this.jep.addVariable(this.variables[0], d - d3);
        double d5 = this.jep.getValue();
        return (d4 + d5) / 2.0;
    }

    public double evaluate(double d, double d2) {
        if (this.variables.length < 1) {
            System.out.println("JEParser Error: Only one variable has been defined.");
            return 0.0;
        }
        this.jep.addVariable(this.variables[0], d);
        this.jep.addVariable(this.variables[1], d2);
        return this.jep.getValue();
    }

    public double evaluate(double[] dArray) {
        if (this.variables.length < dArray.length) {
            System.out.println("JEParser Error: incorrect number of variables.");
            return 0.0;
        }
        int n = 0;
        while (n < dArray.length) {
            this.jep.addVariable(this.variables[n], dArray[n]);
            ++n;
        }
        return this.jep.getValue();
    }

    public Complex evaluateComplex(double d) {
        this.jep.addVariable(this.variables[0], d);
        return this.jep.getComplexValue();
    }

    public Complex evaluateComplex(double d, double d2) {
        this.jep.addVariable(this.variables[0], d);
        this.jep.addVariable(this.variables[1], d2);
        return this.jep.getComplexValue();
    }

    public Complex evaluateComplex(double d, double d2, double d3) {
        this.jep.addVariable(this.variables[0], d);
        this.jep.addVariable(this.variables[1], d2);
        this.jep.addVariable(this.variables[2], d3);
        return this.jep.getComplexValue();
    }

    public static synchronized Complex evalMath(String string) {
        try {
            JEParser jEParser = JEParser.getJEParser();
            jEParser.setFunction(string);
            return jEParser.evaluateComplex(0.0);
        }
        catch (ParserException parserException) {
            return new Complex(Double.NaN, Double.NaN);
        }
    }

    private static synchronized JEParser getJEParser() {
        if (parser == null) {
            try {
                parser = new JEParser("0", "", true);
            }
            catch (ParserException parserException) {}
        }
        return parser;
    }

    public class SquareRoot
    extends PostfixMathCommand
    implements PostfixMathCommandI {
        public SquareRoot() {
            this.numberOfParameters = 1;
        }

        public void run(Stack stack) throws ParseException {
            this.checkStack(stack);
            Object e = stack.pop();
            if (e instanceof Double) {
                double d = (Double)e;
                if (d >= 0.0) {
                    stack.push(new Double(Math.sqrt(d)));
                } else {
                    stack.push(new Complex(0.0, Math.sqrt(-d)));
                }
            } else if (e instanceof Complex) {
                stack.push(((Complex)e).sqrt());
            } else {
                throw new ParseException("Invalid parameter type");
            }
        }
    }

    public class Step
    extends PostfixMathCommand
    implements PostfixMathCommandI {
        public Step() {
            this.numberOfParameters = 1;
        }

        public void run(Stack stack) throws ParseException {
            this.checkStack(stack);
            Object e = stack.pop();
            if (e instanceof Double) {
                if ((Double)e >= 0.0) {
                    stack.push(new Double(1.0));
                } else {
                    stack.push(new Double(0.0));
                }
            } else {
                throw new ParseException("Invalid parameter type");
            }
        }
    }
}

