/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.util.Collection;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.GUIUtils;

public class OSPApplication {
    Control control;
    Object model;
    Class loadedControlClass;
    Class loadedModelClass;
    boolean compatibleModel = false;

    public OSPApplication(Control control, Object object) {
        this.control = control;
        this.model = object;
    }

    public void setCompatibleModel(boolean bl) {
        this.compatibleModel = bl;
    }

    public Class getLoadedModelClass() {
        return this.loadedModelClass;
    }

    public Class getLoadedControlClass() {
        return this.loadedControlClass;
    }

    public static XML.ObjectLoader getLoader() {
        return new OSPAppLoader();
    }

    static class OSPAppLoader
    implements XML.ObjectLoader {
        OSPAppLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            OSPApplication oSPApplication = (OSPApplication)object;
            xMLControl.setValue("control", oSPApplication.control);
            xMLControl.setValue("model", oSPApplication.model);
        }

        public Object createObject(XMLControl xMLControl) {
            Object object = xMLControl.getObject("model");
            Control control = (Control)xMLControl.getObject("control");
            return new OSPApplication(control, object);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            OSPApplication oSPApplication = (OSPApplication)object;
            oSPApplication.loadedControlClass = null;
            oSPApplication.loadedModelClass = null;
            XMLControlElement xMLControlElement = (XMLControlElement)xMLControl.getChildControl("control");
            XMLControlElement xMLControlElement2 = (XMLControlElement)xMLControl.getChildControl("model");
            if (xMLControlElement == null || xMLControlElement2 == null) {
                OSPLog.fine("OSP Application not loaded. An OSP application must have a model and a control.");
                return oSPApplication;
            }
            Class clazz = xMLControlElement2.getObjectClass();
            Class clazz2 = xMLControlElement.getObjectClass();
            if (clazz == null || clazz2 == null) {
                if (clazz2 == null) {
                    OSPLog.fine("Object not loaded. Cannot find class for control.");
                }
                if (clazz == null) {
                    OSPLog.fine("Object not loaded. Cannot find class for model.");
                }
                return oSPApplication;
            }
            boolean bl = oSPApplication.compatibleModel;
            if (oSPApplication.model != null) {
                boolean bl2 = XML.getLoader(clazz).getClass() == XML.getLoader(oSPApplication.model.getClass()).getClass();
                bl = bl || clazz == oSPApplication.model.getClass() || clazz.isAssignableFrom(oSPApplication.model.getClass()) && bl2;
            }
            oSPApplication.loadedControlClass = clazz2;
            if (oSPApplication.control != null && clazz2 == oSPApplication.control.getClass()) {
                xMLControlElement.loadObject(oSPApplication.control);
            } else {
                xMLControlElement.loadObject(oSPApplication.control, true, bl);
            }
            Collection collection = oSPApplication.control.getPropertyNames();
            for (String string : xMLControlElement.getPropertyNames()) {
                if (collection.contains(string)) continue;
                oSPApplication.control.setValue(string, null);
            }
            oSPApplication.loadedModelClass = clazz;
            if (oSPApplication.model != null && clazz == oSPApplication.model.getClass()) {
                xMLControlElement2.loadObject(oSPApplication.model);
            } else {
                xMLControlElement2.loadObject(oSPApplication.model, true, false);
            }
            GUIUtils.repaintOSPFrames();
            return oSPApplication;
        }
    }
}

