/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.davidson.jones;

import java.awt.Color;
import org.opensourcephysics.davidson.jones.OpticalElement;
import org.opensourcephysics.displayejs.GroupDrawable;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.numerics.Quaternion;

public class DrawableOpticalElement
extends GroupDrawable {
    OpticalElement oe;
    InteractiveArrow a;
    double length = 2.5;

    public DrawableOpticalElement(OpticalElement opticalElement, InteractiveArrow interactiveArrow) {
        this.oe = new OpticalElement(opticalElement.c11, opticalElement.c12, opticalElement.c21, opticalElement.c22);
        this.oe.setXYZ(0.0, 0.0, 0.0);
        this.oe.setSizeXYZ(0.1, 3.0, 3.0);
        this.oe.getStyle().setFillPattern(new Color(196, 196, 196, 128));
        this.add(this.oe);
        this.a = interactiveArrow;
        this.a.getStyle().setFillPattern(Color.BLACK);
        this.add(this.a);
    }

    public DrawableOpticalElement rotate(double d) {
        Quaternion quaternion = new Quaternion(1.0, 0.0, 0.0, 0.0);
        quaternion.setCoordinates(Math.cos(d / 2.0), Math.sin(d / 2.0), 0.0, 0.0);
        this.oe.setTransformation(quaternion);
        this.a.setSizeXYZ(0.0, Math.cos(d) * this.length, Math.sin(d) * this.length);
        return new DrawableOpticalElement(this.oe.rotate(d), this.a);
    }

    public void setDrawableOpticalElement(DrawableOpticalElement drawableOpticalElement) {
        this.oe = drawableOpticalElement.oe;
        this.a = drawableOpticalElement.a;
    }
}

