/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.davidson.jones;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.nfunk.JEParser;
import org.nfunk.jep.type.Complex;
import org.opensourcephysics.controls.AbstractAnimation;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.davidson.jones.DrawableOpticalElement;
import org.opensourcephysics.davidson.jones.DrawablePolarizer;
import org.opensourcephysics.davidson.jones.JonesVector;
import org.opensourcephysics.davidson.jones.MainOEControl;
import org.opensourcephysics.davidson.jones.MainOELoader;
import org.opensourcephysics.davidson.jones.OpticalCollection;
import org.opensourcephysics.displayejs.DrawingPanel3D;

public class MainOEApp
extends AbstractAnimation
implements PropertyChangeListener {
    public DrawingPanel3D panel3d = new DrawingPanel3D();
    double time = 0.0;
    double dt = 0.1;
    OpticalCollection optCol;
    DrawableOpticalElement optEl;

    public MainOEApp() {
        this.createElement();
        this.optCol = new OpticalCollection(this.panel3d, this.optEl);
        this.optCol.time = this.time;
        this.optCol.dt = this.dt;
        this.panel3d.setDecorationType(0);
        this.panel3d.setPreferredMinMax(-2.0, 2.0, -1.0, 1.0, -1.0, 1.0);
        this.panel3d.setAlphaAndBeta(3.9269908169872414, 0.5235987755982988);
        this.optCol.v.setElementAt(this.optCol.drawableOE.rotate(0.7853981633974483), 2);
        this.optCol.calcVector(this.panel3d);
        this.panel3d.repaint();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = this.isRunning();
        if (bl) {
            this.stopAnimation();
        }
        this.initializeAnimation();
        if (bl) {
            this.startAnimation();
        }
    }

    public void createElement() {
        this.optEl = new DrawablePolarizer();
    }

    public void clickAction() {
        boolean bl;
        boolean bl2 = bl = this.animationThread != null;
        if (bl) {
            this.stopAnimation();
        }
        Complex complex = new Complex();
        Complex complex2 = new Complex();
        complex.set(JEParser.evalMath(this.control.getString("c1")));
        complex2.set(JEParser.evalMath(this.control.getString("c2")));
        this.optCol.source.setJones(new JonesVector(complex, complex2));
        this.optCol.source.normalize();
        this.optCol.calcVector(this.panel3d);
        this.panel3d.repaint();
        if (bl) {
            this.startAnimation();
        } else {
            this.panel3d.repaint();
        }
    }

    public void buttonAction() {
        boolean bl;
        boolean bl2 = bl = this.animationThread != null;
        if (bl) {
            this.stopAnimation();
        } else {
            this.startAnimation();
        }
    }

    public void resetAnimation() {
        this.stopAnimation();
        this.time = 0.0;
        this.control.setValue("c1", "1");
        this.control.setValue("c2", 0);
        this.control.setValue("angleTXT", "pi/4");
        this.txtChanged();
    }

    public void sliderMoved() {
        boolean bl;
        boolean bl2 = bl = this.animationThread != null;
        if (bl) {
            this.stopAnimation();
        }
        Complex complex = new Complex();
        DrawableOpticalElement drawableOpticalElement = this.optCol.drawableOE;
        complex.set(JEParser.evalMath(this.control.getString("angle")));
        this.optCol.v.setElementAt(drawableOpticalElement.rotate(complex.re()), 2);
        this.control.setValue("angleTXT", complex.re());
        this.optCol.calcVector(this.panel3d);
        if (bl) {
            this.startAnimation();
        } else {
            this.panel3d.repaint();
        }
    }

    public void txtChanged() {
        boolean bl;
        boolean bl2 = bl = this.animationThread != null;
        if (bl) {
            this.stopAnimation();
        }
        Complex complex = new Complex();
        DrawableOpticalElement drawableOpticalElement = this.optCol.drawableOE;
        complex.set(JEParser.evalMath(this.control.getString("angleTXT")));
        this.optCol.v.setElementAt(drawableOpticalElement.rotate(complex.re()), 2);
        this.control.setValue("angle", complex.re());
        this.optCol.calcVector(this.panel3d);
        if (bl) {
            this.startAnimation();
        } else {
            this.panel3d.repaint();
        }
    }

    protected void doStep() {
        this.time += this.dt;
        this.optCol.wave1.doStep();
        this.optCol.wave2.doStep();
        this.panel3d.setMessage("t=" + this.decimalFormat.format(this.time));
        this.panel3d.repaint();
    }

    public static XML.ObjectLoader getLoader() {
        return new MainOELoader();
    }

    public static void main(String[] stringArray) {
        MainOEApp mainOEApp = new MainOEApp();
        MainOEControl mainOEControl = new MainOEControl(mainOEApp);
        mainOEApp.setControl(mainOEControl);
        mainOEControl.loadXML(stringArray);
    }
}

