/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.davidson.jones;

import java.awt.Color;
import java.util.Vector;
import org.nfunk.jep.type.Complex;
import org.opensourcephysics.davidson.jones.DrawableOpticalElement;
import org.opensourcephysics.davidson.jones.JonesVector;
import org.opensourcephysics.davidson.jones.PolarizedWave;
import org.opensourcephysics.davidson.jones.Source;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.Resolution;

public class OpticalCollection {
    Source source;
    PolarizedWave wave1;
    PolarizedWave wave2;
    DrawableOpticalElement drawableOE;
    double time = 0.0;
    double dt = 0.1;
    Vector v = new Vector();
    Complex c1;
    Complex c2;
    InteractiveArrow xaxisBody = new InteractiveArrow();
    InteractiveArrow yaxisBody = new InteractiveArrow();
    InteractiveArrow zaxisBody = new InteractiveArrow();

    public OpticalCollection(DrawingPanel3D drawingPanel3D, DrawableOpticalElement drawableOpticalElement) {
        this.c1 = new Complex(1.0, 0.0);
        this.c2 = new Complex(0.0, 0.0);
        this.drawableOE = drawableOpticalElement;
        this.source = new Source(new JonesVector(this.c1, this.c2));
        this.source.normalize();
        this.wave1 = new PolarizedWave(new JonesVector(this.c1, this.c2), -2.0, 0.0);
        this.wave2 = new PolarizedWave(new JonesVector(this.c1, this.c2), 0.0, 2.0);
        this.wave1.time = this.wave2.time = this.time;
        this.wave1.dt = this.wave2.dt = this.dt;
        this.xaxisBody.getStyle().setFillPattern(Color.RED);
        this.xaxisBody.setResolution(new Resolution(10));
        this.yaxisBody.getStyle().setFillPattern(Color.GREEN);
        this.yaxisBody.setResolution(new Resolution(10));
        this.zaxisBody.getStyle().setFillPattern(Color.BLUE);
        this.zaxisBody.setResolution(new Resolution(10));
        this.xaxisBody.setXYZ(-2.0, 0.0, 0.0);
        this.yaxisBody.setXYZ(-2.0, 0.0, 0.0);
        this.zaxisBody.setXYZ(-2.0, 0.0, 0.0);
        this.xaxisBody.setSizeXYZ(6.0, 0.0, 0.0);
        this.yaxisBody.setSizeXYZ(0.0, 2.0, 0.0);
        this.zaxisBody.setSizeXYZ(0.0, 0.0, 2.0);
        this.v.add(this.source);
        this.v.add(this.wave1);
        this.v.add(this.drawableOE);
        this.v.add(this.wave2);
        drawingPanel3D.addDrawable(this.wave1);
        drawingPanel3D.addDrawable(this.wave2);
        drawingPanel3D.addDrawable(this.xaxisBody);
        drawingPanel3D.addDrawable(this.yaxisBody);
        drawingPanel3D.addDrawable(this.zaxisBody);
    }

    public void calcVector(DrawingPanel3D drawingPanel3D) {
        this.wave1.time = this.wave2.time = this.time;
        this.wave1.dt = this.wave2.dt = this.dt;
        JonesVector jonesVector = this.source.getStatus();
        int n = 1;
        while (n < this.v.size()) {
            if (this.v.elementAt(n).getClass() == PolarizedWave.class) {
                ((PolarizedWave)this.v.elementAt(n)).setJones(jonesVector);
            } else {
                DrawableOpticalElement drawableOpticalElement = (DrawableOpticalElement)this.v.elementAt(n);
                jonesVector = drawableOpticalElement.oe.setStatus(jonesVector);
                drawingPanel3D.addDrawable(this.drawableOE);
                drawingPanel3D.addDrawable(this.drawableOE.a);
            }
            ++n;
        }
    }
}

