/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.davidson.jones;

import org.nfunk.jep.type.Complex;
import org.opensourcephysics.davidson.jones.JonesVector;
import org.opensourcephysics.displayejs.InteractiveBox;

public class OpticalElement
extends InteractiveBox {
    Complex c11;
    Complex c12;
    Complex c21;
    Complex c22;
    Complex[] oe = new Complex[4];

    public OpticalElement(Complex[] complexArray) {
        this.oe = complexArray;
    }

    public OpticalElement(Complex complex, Complex complex2, Complex complex3, Complex complex4) {
        this.c11 = complex;
        this.c12 = complex2;
        this.c21 = complex3;
        this.c22 = complex4;
        this.oe[0] = this.c11;
        this.oe[1] = this.c12;
        this.oe[2] = this.c21;
        this.oe[3] = this.c22;
    }

    public JonesVector setStatus(JonesVector jonesVector) {
        Complex complex = jonesVector.getVector()[0];
        Complex complex2 = jonesVector.getVector()[1];
        double d = this.c11.mul(complex).re() + this.c12.mul(complex2).re();
        double d2 = this.c11.mul(complex).im() + this.c12.mul(complex2).im();
        double d3 = this.c21.mul(complex).re() + this.c22.mul(complex2).re();
        double d4 = this.c21.mul(complex).im() + this.c22.mul(complex2).im();
        Complex complex3 = new Complex(d2, d);
        Complex complex4 = new Complex(d4, d3);
        return new JonesVector(complex3, complex4);
    }

    public void setComplexN(Complex complex, Complex complex2, Complex complex3, Complex complex4) {
        this.c11 = complex;
        this.c12 = complex2;
        this.c21 = complex3;
        this.c22 = complex4;
    }

    public OpticalElement rotate(double d) {
        double d2 = Math.cos(d) * Math.cos(d);
        double d3 = Math.cos(d) * Math.sin(d);
        double d4 = Math.sin(d) * Math.sin(d);
        double d5 = this.c11.re() * d2 - this.c21.re() * d3 - this.c12.re() * d3 + this.c22.re() * d4;
        double d6 = this.c11.im() * d2 - this.c21.im() * d3 - this.c12.im() * d3 + this.c22.im() * d4;
        double d7 = this.c11.re() * d3 + this.c21.re() * d2 - this.c12.re() * d4 - this.c22.re() * d3;
        double d8 = this.c11.im() * d3 + this.c21.im() * d2 - this.c12.im() * d4 - this.c22.im() * d3;
        double d9 = this.c11.re() * d3 - this.c21.re() * d4 + this.c12.re() * d2 - this.c22.re() * d3;
        double d10 = this.c11.im() * d3 - this.c21.im() * d4 + this.c12.im() * d2 - this.c22.im() * d3;
        double d11 = this.c11.re() * d4 + this.c21.re() * d3 + this.c12.re() * d3 + this.c22.re() * d2;
        double d12 = this.c11.im() * d4 + this.c21.im() * d3 + this.c12.im() * d3 + this.c22.im() * d2;
        return new OpticalElement(new Complex(d5, d6), new Complex(d7, d8), new Complex(d9, d10), new Complex(d11, d12));
    }
}

