/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.davidson.jones;

import java.awt.Color;
import java.util.Vector;
import org.opensourcephysics.davidson.jones.JonesVector;
import org.opensourcephysics.displayejs.GroupDrawable;
import org.opensourcephysics.displayejs.InteractiveArrow;

public class PolarizedWave
extends GroupDrawable {
    protected Vector arrows = new Vector();
    double time = 0.0;
    double dt = 0.1;
    double min = -1.0;
    double max = 1.0;
    private double density = 0.01;
    double k = Math.PI * 2;
    double w = Math.PI * 2;
    double length = Math.abs(this.max - this.min);
    int elements = (int)(this.length / this.density);
    JonesVector vec;

    public PolarizedWave(JonesVector jonesVector, double d, double d2) {
        this.vec = jonesVector;
        this.min = d;
        this.max = d2;
        this.length = Math.abs(this.max - this.min);
        this.updateVector();
    }

    public void setJones(JonesVector jonesVector) {
        this.vec = jonesVector;
        this.updateArrows();
    }

    public JonesVector getStatus() {
        return this.vec.getStatus();
    }

    public void doStep() {
        this.time += this.dt;
        this.updateArrows();
    }

    public void setMin(double d) {
        this.min = d;
        this.updateVector();
    }

    public void setMax(double d) {
        this.max = d;
        this.updateVector();
    }

    public void setMinMax(double d, double d2) {
        this.min = d;
        this.max = d2;
        this.updateVector();
    }

    public void setDensity(double d) {
        this.density = d;
        this.updateVector();
    }

    public void updateArrows() {
        double d = this.min;
        int n = 0;
        while (n < this.elements) {
            d = this.min + (double)n / ((double)this.elements / this.length);
            double d2 = this.vec.getAmplitudeX() * Math.cos(this.k * d - this.w * this.time + this.vec.c1.arg());
            double d3 = this.vec.getAmplitudeY() * Math.cos(this.k * d - this.w * this.time + this.vec.c2.arg());
            ((InteractiveArrow)this.arrows.elementAt(n)).setSizeXYZ(0.0, d2, d3);
            ++n;
        }
    }

    public void updateVector() {
        int n = 0;
        while (n < this.arrows.size()) {
            this.remove((InteractiveArrow)this.arrows.elementAt(n));
            ++n;
        }
        this.length = Math.abs(this.max - this.min);
        this.elements = (int)(this.length / this.density);
        this.arrows.removeAllElements();
        double d = this.min;
        int n2 = 0;
        while (n2 < this.elements) {
            this.arrows.addElement(new InteractiveArrow(1));
            d = this.min + (double)n2 / ((double)this.elements / this.length);
            ((InteractiveArrow)this.arrows.elementAt(n2)).setX(d);
            ((InteractiveArrow)this.arrows.elementAt(n2)).getStyle().setEdgeColor(Color.BLUE);
            double d2 = this.vec.getAmplitudeX() * Math.cos(this.k * d - this.w * this.time + this.vec.c1.arg());
            double d3 = this.vec.getAmplitudeY() * Math.cos(this.k * d - this.w * this.time + this.vec.c2.arg());
            ((InteractiveArrow)this.arrows.elementAt(n2)).setSizeXYZ(0.0, d2, d3);
            this.add((InteractiveArrow)this.arrows.elementAt(n2));
            ++n2;
        }
    }
}

