/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.davidson.jones;

import org.nfunk.jep.type.Complex;
import org.opensourcephysics.davidson.jones.JonesVector;

public class Source {
    JonesVector vec;

    public Source(JonesVector jonesVector) {
        this.vec = jonesVector;
    }

    public JonesVector getStatus() {
        return this.vec.getStatus();
    }

    public void setJones(JonesVector jonesVector) {
        this.vec = jonesVector;
    }

    public void normalize() {
        Complex complex = this.vec.c1.neg();
        Complex complex2 = this.vec.c2.neg();
        complex.setRe(this.vec.c1.re());
        complex2.setRe(this.vec.c2.re());
        double d = complex.re() * this.vec.c1.re() + complex2.re() * this.vec.c2.re();
        double d2 = -complex.im() * this.vec.c1.im() - complex2.im() * this.vec.c2.im();
        double d3 = Math.sqrt(d + d2);
        this.vec.c1.set(this.vec.c1.mul(1.0 / d3));
        this.vec.c2.set(this.vec.c2.mul(1.0 / d3));
    }
}

