/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import org.jibble.epsgraphics.EpsGraphics2D;
import org.opensourcephysics.display.DataTableFrame;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.Renderable;

public class GUIUtils {
    public static Map charMap = new HashMap();

    static {
        charMap.put("\\Alpha", "\u0391");
        charMap.put("\\Beta", "\u0392");
        charMap.put("\\Gamma", "\u0393");
        charMap.put("\\Delta", "\u0394");
        charMap.put("\\Epsilon", "\u0395");
        charMap.put("\\Zeta", "\u0396");
        charMap.put("\\Eta", "\u0397");
        charMap.put("\\Theta", "\u0398");
        charMap.put("\\Pi", "\u03a0");
        charMap.put("\\Rho", "\u03a1");
        charMap.put("\\Sigma", "\u03a3");
        charMap.put("\\Tau", "\u03a4");
        charMap.put("\\Phi", "\u03a6");
        charMap.put("\\Chi", "\u03a7");
        charMap.put("\\Psi", "\u03a8");
        charMap.put("\\Omega", "\u03a9");
        charMap.put("\\Xi", "\u039e");
        charMap.put("\\alpha", "\u03b1");
        charMap.put("\\beta", "\u03b2");
        charMap.put("\\gamma", "\u03b3");
        charMap.put("\\delta", "\u03b4");
        charMap.put("\\epsilon", "\u03b5");
        charMap.put("\\zeta", "\u03b6");
        charMap.put("\\eta", "\u03b7");
        charMap.put("\\theta", "\u03b8");
        charMap.put("\\iota", "\u03b9");
        charMap.put("\\kappa", "\u03ba");
        charMap.put("\\lamda", "\u03bb");
        charMap.put("\\mu", "\u03bc");
        charMap.put("\\micro", "\u03bc");
        charMap.put("\\nu", "\u03bd");
        charMap.put("\\xi", "\u03be");
        charMap.put("\\pi", "\u03c0");
        charMap.put("\\rho", "\u03c1");
        charMap.put("\\sigma", "\u03c3");
        charMap.put("\\tau", "\u03c4");
        charMap.put("\\phi", "\u03c6");
        charMap.put("\\chi", "\u03c7");
        charMap.put("\\psi", "\u03c8");
        charMap.put("\\omega", "\u03c9");
        charMap.put("\\degree", "\u00b0");
    }

    private GUIUtils() {
    }

    public static String parseTeX(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("\\$");
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            String string2;
            if (bl && (string2 = (String)charMap.get(stringArray[n].trim())) != null) {
                stringArray[n] = string2;
            }
            bl = !bl;
            ++n;
        }
        String string3 = "";
        int n2 = 0;
        while (n2 < stringArray.length) {
            string3 = String.valueOf(string3) + stringArray[n2];
            ++n2;
        }
        return string3;
    }

    public static String removeSubscripting(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("_");
        while (n > 0) {
            int n2;
            String string2 = string.substring(n + 1);
            if (string2.startsWith("{") && (n2 = string2.indexOf("}")) > 0) {
                string2 = String.valueOf(string2.substring(1, n2)) + string2.substring(n2 + 1);
            }
            string = String.valueOf(string.substring(0, n)) + string2;
            n = string.indexOf("_");
        }
        return string;
    }

    public static Component findInstance(Container container, Class clazz) {
        if (container == null || clazz.isInstance(container)) {
            return container;
        }
        Component[] componentArray = container.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component component;
            if (clazz.isInstance(componentArray[n])) {
                return componentArray[n];
            }
            if (componentArray[n] instanceof Container && clazz.isInstance(component = GUIUtils.findInstance((Container)componentArray[n], clazz))) {
                return component;
            }
            ++n;
        }
        return null;
    }

    public static void showDrawingAndTableFrames() {
        Frame[] frameArray = Frame.getFrames();
        int n = 0;
        while (n < frameArray.length) {
            if (frameArray[n].isDisplayable() && (frameArray[n].getName() == null || frameArray[n].getName().indexOf("Tool") <= -1) && OSPFrame.class.isInstance(frameArray[n])) {
                if (DataTableFrame.class.isInstance(frameArray[n])) {
                    ((DataTableFrame)frameArray[n]).refreshTable();
                }
                frameArray[n].setVisible(true);
                ((OSPFrame)frameArray[n]).invalidateImage();
                frameArray[n].repaint();
                frameArray[n].toFront();
            }
            ++n;
        }
        if (OSPRuntime.applet != null) {
            OSPRuntime.applet.getRootPane().repaint();
        }
    }

    public static void renderAnimatedFrames() {
        Frame[] frameArray = Frame.getFrames();
        int n = 0;
        while (n < frameArray.length) {
            if (frameArray[n].isDisplayable() && OSPFrame.class.isInstance(frameArray[n]) && ((OSPFrame)frameArray[n]).isAnimated()) {
                ((OSPFrame)frameArray[n]).render();
            }
            ++n;
        }
        if (OSPRuntime.applet != null && OSPRuntime.applet instanceof Renderable) {
            ((Renderable)((Object)OSPRuntime.applet)).render();
        }
    }

    public static void repaintAnimatedFrames() {
        Frame[] frameArray = Frame.getFrames();
        int n = 0;
        while (n < frameArray.length) {
            if (frameArray[n].isDisplayable() && OSPFrame.class.isInstance(frameArray[n]) && ((OSPFrame)frameArray[n]).isAnimated()) {
                ((OSPFrame)frameArray[n]).invalidateImage();
                ((OSPFrame)frameArray[n]).repaint();
            }
            ++n;
        }
    }

    public static void repaintOSPFrames() {
        Frame[] frameArray = Frame.getFrames();
        int n = 0;
        while (n < frameArray.length) {
            if (frameArray[n].isVisible() && frameArray[n].isDisplayable() && OSPFrame.class.isInstance(frameArray[n])) {
                ((OSPFrame)frameArray[n]).repaint();
            }
            ++n;
        }
    }

    public static void clearDrawingFrameData(boolean bl) {
        Frame[] frameArray = Frame.getFrames();
        int n = 0;
        while (n < frameArray.length) {
            if (frameArray[n].isDisplayable() && OSPFrame.class.isInstance(frameArray[n])) {
                OSPFrame oSPFrame = (OSPFrame)frameArray[n];
                if (bl || oSPFrame.isAutoclear()) {
                    oSPFrame.clearDataAndRepaint();
                }
            }
            ++n;
        }
    }

    public static void setAnimatedFrameIgnoreRepaint(boolean bl) {
        Frame[] frameArray = Frame.getFrames();
        int n = 0;
        while (n < frameArray.length) {
            DrawingPanel drawingPanel;
            if (frameArray[n].isDisplayable() && DrawingFrame.class.isInstance(frameArray[n]) && ((DrawingFrame)frameArray[n]).isAnimated() && (drawingPanel = ((DrawingFrame)frameArray[n]).getDrawingPanel()) != null) {
                drawingPanel.setIgnoreRepaint(bl);
            }
            ++n;
        }
    }

    public static void enableMenubars(boolean bl) {
        Frame[] frameArray = Frame.getFrames();
        int n = 0;
        while (n < frameArray.length) {
            if (frameArray[n].isDisplayable() && (frameArray[n].getName() == null || frameArray[n].getName().indexOf("Tool") <= -1)) {
                JMenuBar jMenuBar;
                Class<?> clazz = null;
                try {
                    clazz = Class.forName("org.opensourcephysics.display3d.core.DrawingFrame3D");
                }
                catch (ClassNotFoundException classNotFoundException) {}
                if ((DrawingFrame.class.isInstance(frameArray[n]) || clazz != null && clazz.isInstance(frameArray[n])) && (jMenuBar = ((JFrame)frameArray[n]).getJMenuBar()) != null) {
                    int n2 = 0;
                    int n3 = jMenuBar.getMenuCount();
                    while (n2 < n3) {
                        jMenuBar.getMenu(n2).setEnabled(bl);
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    public static void closeAndDisposeOSPFrames(Frame frame) {
        Frame[] frameArray = Frame.getFrames();
        int n = 0;
        while (n < frameArray.length) {
            if (frameArray[n] != frame && OSPFrame.class.isInstance(frameArray[n])) {
                ((OSPFrame)frameArray[n]).setDefaultCloseOperation(2);
                ((OSPFrame)frameArray[n]).setVisible(false);
                ((OSPFrame)frameArray[n]).dispose();
            }
            ++n;
        }
    }

    public static File showSaveDialog(Component component) {
        return GUIUtils.showSaveDialog(component, "Save");
    }

    public static File showSaveDialog(Component component, String string) {
        int n;
        JFileChooser jFileChooser = OSPRuntime.getChooser();
        if (jFileChooser == null) {
            return null;
        }
        String string2 = jFileChooser.getDialogTitle();
        jFileChooser.setDialogTitle(string);
        int n2 = jFileChooser.showSaveDialog(component);
        jFileChooser.setDialogTitle(string2);
        if (n2 != 0) {
            return null;
        }
        OSPRuntime.chooserDir = jFileChooser.getCurrentDirectory().toString();
        File file = jFileChooser.getSelectedFile();
        if (file.exists() && (n = JOptionPane.showConfirmDialog(component, "A file named " + file.getName() + " already exists.\nAre you sure you want to replace it?", "Warning", 1)) != 0) {
            return null;
        }
        return file;
    }

    public static File showOpenDialog(Component component) {
        JFileChooser jFileChooser = OSPRuntime.getChooser();
        int n = jFileChooser.showOpenDialog(component);
        if (n != 0) {
            return null;
        }
        OSPRuntime.chooserDir = jFileChooser.getCurrentDirectory().toString();
        File file = jFileChooser.getSelectedFile();
        return file;
    }

    public static void timingTest(Drawable drawable) {
        DrawingPanel drawingPanel = new DrawingPanel();
        DrawingFrame drawingFrame = new DrawingFrame(drawingPanel);
        drawingFrame.setVisible(true);
        drawingPanel.addDrawable(drawable);
        drawingPanel.scale();
        drawingPanel.setPixelScale();
        Graphics graphics = drawingPanel.getGraphics();
        if (graphics == null) {
            return;
        }
        long l = System.currentTimeMillis();
        drawable.draw(drawingPanel, graphics);
        System.out.print("first drawing=" + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        int n = 0;
        while (n < 5) {
            drawable.draw(drawingPanel, graphics);
            ++n;
        }
        System.out.println("  avg time/drawing=" + (System.currentTimeMillis() - l) / 5L);
        graphics.dispose();
    }

    public static void saveImage(JComponent jComponent, File file, String string) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            if (string.equals("eps")) {
                EpsGraphics2D epsGraphics2D = new EpsGraphics2D("", fileOutputStream, 0, 0, jComponent.getWidth(), jComponent.getHeight());
                jComponent.paint(epsGraphics2D);
                epsGraphics2D.scale(0.24, 0.24);
                epsGraphics2D.close();
            } else {
                BufferedImage bufferedImage = new BufferedImage(jComponent.getWidth(), jComponent.getHeight(), 5);
                Graphics graphics = bufferedImage.getGraphics();
                jComponent.paint(graphics);
                graphics.dispose();
                ImageIO.write((RenderedImage)bufferedImage, string, fileOutputStream);
                fileOutputStream.close();
            }
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static void saveImage(JComponent jComponent, String string, Component component) {
        File file = GUIUtils.showSaveDialog(jComponent, "Save Image");
        if (file == null) {
            return;
        }
        try {
            GUIUtils.saveImage(jComponent, file, string);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(component, "An error occurred while saving the file " + file.getName() + ".'");
        }
    }
}

