/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import org.opensourcephysics.displayejs.AbstractInteractiveTile;
import org.opensourcephysics.displayejs.InteractiveElement;

public class InteractiveBox
extends AbstractInteractiveTile {
    protected boolean closedBottom = true;
    protected boolean closedTop = true;
    protected boolean changeNTiles = true;
    protected int nx = -1;
    protected int ny = -1;
    protected int nz = -1;

    public void copyFrom(InteractiveElement interactiveElement) {
        super.copyFrom(interactiveElement);
        if (interactiveElement instanceof InteractiveBox) {
            InteractiveBox interactiveBox = (InteractiveBox)interactiveElement;
            this.setClosedBottom(interactiveBox.isClosedBottom());
            this.setClosedTop(interactiveBox.isClosedTop());
        }
    }

    public void setClosedBottom(boolean bl) {
        this.closedBottom = bl;
        this.hasChanged = true;
        this.changeNTiles = true;
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean bl) {
        this.closedTop = bl;
        this.hasChanged = true;
        this.changeNTiles = true;
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    protected synchronized void computeCorners() {
        double d;
        int n;
        double d2;
        int n2;
        int n3 = 1;
        int n4 = 1;
        int n5 = 1;
        if (this.resolution != null) {
            switch (this.resolution.type) {
                case 0: {
                    n3 = Math.max(this.resolution.n1, 1);
                    n4 = Math.max(this.resolution.n2, 1);
                    n5 = Math.max(this.resolution.n3, 1);
                    break;
                }
                case 1: {
                    n3 = Math.max((int)Math.round(0.49 + Math.abs(this.sizex) / this.resolution.maxLength), 1);
                    n4 = Math.max((int)Math.round(0.49 + Math.abs(this.sizey) / this.resolution.maxLength), 1);
                    n5 = Math.max((int)Math.round(0.49 + Math.abs(this.sizez) / this.resolution.maxLength), 1);
                }
            }
        }
        if (this.nx != n3 || this.ny != n4 || this.nz != n5 || this.changeNTiles) {
            this.nx = n3;
            this.ny = n4;
            this.nz = n5;
            n2 = 2 * this.nx * this.nz + 2 * this.ny * this.nz;
            if (this.closedBottom) {
                n2 += this.nx * this.ny;
            }
            if (this.closedTop) {
                n2 += this.nx * this.ny;
            }
            this.changeNTiles = false;
            this.setCorners(new double[n2][4][3]);
        }
        n2 = 0;
        double d3 = this.sizex / (double)this.nx;
        double d4 = this.sizey / (double)this.ny;
        double d5 = this.sizez / (double)this.nz;
        double d6 = this.x + this.sizex;
        double d7 = this.y + this.sizey;
        double d8 = this.z + this.sizez;
        int n6 = 0;
        while (n6 < this.nx) {
            d2 = this.x + (double)n6 * d3;
            n = 0;
            while (n < this.ny) {
                d = this.y + (double)n * d4;
                if (this.closedBottom) {
                    this.corners[n2][0][0] = d2;
                    this.corners[n2][0][1] = d;
                    this.corners[n2][0][2] = this.z;
                    this.corners[n2][1][0] = d2 + d3;
                    this.corners[n2][1][1] = d;
                    this.corners[n2][1][2] = this.z;
                    this.corners[n2][2][0] = d2 + d3;
                    this.corners[n2][2][1] = d + d4;
                    this.corners[n2][2][2] = this.z;
                    this.corners[n2][3][0] = d2;
                    this.corners[n2][3][1] = d + d4;
                    this.corners[n2][3][2] = this.z;
                    ++n2;
                }
                if (this.closedTop) {
                    this.corners[n2][0][0] = d2;
                    this.corners[n2][0][1] = d;
                    this.corners[n2][0][2] = d8;
                    this.corners[n2][1][0] = d2 + d3;
                    this.corners[n2][1][1] = d;
                    this.corners[n2][1][2] = d8;
                    this.corners[n2][2][0] = d2 + d3;
                    this.corners[n2][2][1] = d + d4;
                    this.corners[n2][2][2] = d8;
                    this.corners[n2][3][0] = d2;
                    this.corners[n2][3][1] = d + d4;
                    this.corners[n2][3][2] = d8;
                    ++n2;
                }
                ++n;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < this.nx) {
            d2 = this.x + (double)n6 * d3;
            n = 0;
            while (n < this.nz) {
                d = this.z + (double)n * d5;
                this.corners[n2][0][0] = d2;
                this.corners[n2][0][2] = d;
                this.corners[n2][0][1] = this.y;
                this.corners[n2][1][0] = d2 + d3;
                this.corners[n2][1][2] = d;
                this.corners[n2][1][1] = this.y;
                this.corners[n2][2][0] = d2 + d3;
                this.corners[n2][2][2] = d + d5;
                this.corners[n2][2][1] = this.y;
                this.corners[n2][3][0] = d2;
                this.corners[n2][3][2] = d + d5;
                this.corners[n2][3][1] = this.y;
                this.corners[++n2][0][0] = d2;
                this.corners[n2][0][2] = d;
                this.corners[n2][0][1] = d7;
                this.corners[n2][1][0] = d2 + d3;
                this.corners[n2][1][2] = d;
                this.corners[n2][1][1] = d7;
                this.corners[n2][2][0] = d2 + d3;
                this.corners[n2][2][2] = d + d5;
                this.corners[n2][2][1] = d7;
                this.corners[n2][3][0] = d2;
                this.corners[n2][3][2] = d + d5;
                this.corners[n2][3][1] = d7;
                ++n2;
                ++n;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < this.nz) {
            d2 = this.z + (double)n6 * d5;
            n = 0;
            while (n < this.ny) {
                d = this.y + (double)n * d4;
                this.corners[n2][0][2] = d2;
                this.corners[n2][0][1] = d;
                this.corners[n2][0][0] = this.x;
                this.corners[n2][1][2] = d2 + d5;
                this.corners[n2][1][1] = d;
                this.corners[n2][1][0] = this.x;
                this.corners[n2][2][2] = d2 + d5;
                this.corners[n2][2][1] = d + d4;
                this.corners[n2][2][0] = this.x;
                this.corners[n2][3][2] = d2;
                this.corners[n2][3][1] = d + d4;
                this.corners[n2][3][0] = this.x;
                this.corners[++n2][0][2] = d2;
                this.corners[n2][0][1] = d;
                this.corners[n2][0][0] = d6;
                this.corners[n2][1][2] = d2 + d5;
                this.corners[n2][1][1] = d;
                this.corners[n2][1][0] = d6;
                this.corners[n2][2][2] = d2 + d5;
                this.corners[n2][2][1] = d + d4;
                this.corners[n2][2][0] = d6;
                this.corners[n2][3][2] = d2;
                this.corners[n2][3][1] = d + d4;
                this.corners[n2][3][0] = d6;
                ++n2;
                ++n;
            }
            ++n6;
        }
        this.transformCorners();
        this.zmax = Double.NaN;
        this.zmin = Double.NaN;
        this.ymax = Double.NaN;
        this.ymin = Double.NaN;
        this.xmax = Double.NaN;
        this.xmin = Double.NaN;
        this.hasChanged = false;
    }
}

