/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import org.opensourcephysics.displayejs.Drawable3D;

public class Style {
    public static final int CENTERED = 0;
    public static final int NORTH = 1;
    public static final int SOUTH = 2;
    public static final int EAST = 3;
    public static final int WEST = 4;
    public static final int NORTH_EAST = 5;
    public static final int NORTH_WEST = 6;
    public static final int SOUTH_EAST = 7;
    public static final int SOUTH_WEST = 8;
    private Drawable3D drawable = null;
    int position = 0;
    double angle = 0.0;
    double cosAngle = 1.0;
    double sinAngle = 0.0;
    Color edgeColor = Color.black;
    Stroke edgeStroke = new BasicStroke();
    Paint fillPattern = Color.blue;
    Font font = null;
    Object displayObject = null;

    public Style(Drawable3D drawable3D) {
        this.drawable = drawable3D;
    }

    public Style(Style style) {
        this.drawable = style.drawable;
        this.position = style.position;
        this.angle = style.angle;
        this.cosAngle = style.cosAngle;
        this.sinAngle = style.sinAngle;
        this.edgeColor = style.edgeColor;
        this.edgeStroke = style.edgeStroke;
        this.fillPattern = style.fillPattern;
        this.font = style.font;
        this.displayObject = style.displayObject;
    }

    public void copyFrom(Style style) {
        this.drawable = style.drawable;
        this.position = style.position;
        this.angle = style.angle;
        this.cosAngle = style.cosAngle;
        this.sinAngle = style.sinAngle;
        this.edgeColor = style.edgeColor;
        this.edgeStroke = style.edgeStroke;
        this.fillPattern = style.fillPattern;
        this.font = style.font;
        this.displayObject = style.displayObject;
    }

    public void setPosition(int n) {
        this.position = n;
        this.drawable.needsToProject(null);
    }

    public int getPosition() {
        return this.position;
    }

    public void setAngle(double d) {
        this.angle = d;
        this.cosAngle = Math.cos(this.angle);
        this.sinAngle = Math.sin(this.angle);
        this.drawable.needsToProject(null);
    }

    public double getAngle() {
        return this.angle;
    }

    public void setEdgeColor(Color color) {
        this.edgeColor = color;
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeStroke(Stroke stroke) {
        this.edgeStroke = stroke;
    }

    public Stroke getEdgeStroke() {
        return this.edgeStroke;
    }

    public void setFillPattern(Paint paint) {
        this.fillPattern = paint;
    }

    public Paint getFillPattern() {
        return this.fillPattern;
    }

    public void setFont(Font font) {
        this.font = font;
        this.drawable.needsToProject(null);
    }

    public Font getFont() {
        return this.font;
    }

    public void setDisplayObject(Object object) {
        this.displayObject = object;
        this.drawable.needsToProject(null);
    }

    public Object getDisplayObject() {
        return this.displayObject;
    }
}

