/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import org.opensourcephysics.ejs.control.EjsControl;
import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;
import org.opensourcephysics.numerics.Util;

public class ParsedEjsControl
extends EjsControl {
    public ParsedEjsControl(Object object) {
        super(object);
    }

    public double getDouble(String string) {
        Value value = this.getValue(string);
        if (value instanceof DoubleValue) {
            return super.getDouble(string);
        }
        if (value instanceof IntegerValue) {
            return super.getInt(string);
        }
        String string2 = super.getString(string);
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return Util.evalMath(string2);
        }
    }

    public Object getObject(String string) {
        Value value = this.getValue(string);
        if (value == null) {
            return null;
        }
        if (value instanceof IntegerValue) {
            return new Integer(super.getInt(string));
        }
        if (value instanceof DoubleValue) {
            return new Double(super.getDouble(string));
        }
        if (value instanceof BooleanValue) {
            return new Boolean(super.getBoolean(string));
        }
        if (value instanceof StringValue) {
            return super.getString(string);
        }
        return super.getObject(string);
    }

    public int getInt(String string) {
        Value value = this.getValue(string);
        if (value instanceof IntegerValue) {
            return super.getInt(string);
        }
        if (value instanceof DoubleValue) {
            return (int)super.getDouble(string);
        }
        String string2 = super.getString(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return (int)Util.evalMath(string2);
        }
    }
}

