/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlLabel
extends ControlSwingElement {
    protected JLabel label;
    private String imageFile = null;
    private static ArrayList infoList = null;

    public ControlLabel(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        this.label = object instanceof JLabel ? (JLabel)object : new JLabel();
        return this.label;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("text");
            infoList.add("image");
            infoList.add("alignment");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("text")) {
            return "String NotTrimmed TRANSLATABLE";
        }
        if (string.equals("image")) {
            return "File|String";
        }
        if (string.equals("alignment")) {
            return "Alignment|int";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.label.setText(value.getString());
                break;
            }
            case 1: {
                if (value.getString().equals(this.imageFile)) {
                    return;
                }
                this.imageFile = value.getString();
                this.label.setIcon(this.getIcon(this.imageFile));
                break;
            }
            case 2: {
                this.label.setHorizontalAlignment(value.getInteger());
                break;
            }
            default: {
                super.setValue(n - 3, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.label.setText("");
                break;
            }
            case 1: {
                this.label.setIcon(null);
                this.imageFile = null;
                break;
            }
            case 2: {
                this.label.setHorizontalAlignment(0);
                break;
            }
            default: {
                super.setDefaultValue(n - 3);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return null;
            }
        }
        return super.getValue(n - 3);
    }
}

