/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlSlider
extends ControlSwingElement {
    private static final int RESOLUTION = 100000;
    private static final int VARIABLE = 0;
    protected JSlider slider;
    private DoubleValue internalValue;
    private boolean recalculate = true;
    private boolean defaultValueSet;
    private int ticks = 0;
    private double defaultValue;
    private double scale;
    private double minimum = 0.0;
    private double maximum = 1.0;
    private TitledBorder titledBorder;
    private EtchedBorder etchedBorder;
    private DecimalFormat format = null;
    private DecimalFormat ticksFormat = null;
    private static ArrayList infoList = null;
    private boolean adjusted = false;

    public ControlSlider(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        if (object instanceof JSlider) {
            this.slider = (JSlider)object;
        } else {
            this.slider = new JSlider();
            this.slider.setPaintLabels(false);
            this.slider.setPaintTicks(false);
            this.slider.setPaintTrack(true);
        }
        this.slider.setMinimum(0);
        this.slider.setMaximum(100000);
        this.slider.setValue(0);
        this.etchedBorder = new EtchedBorder(1);
        this.titledBorder = new TitledBorder(this.etchedBorder, "");
        this.titledBorder.setTitleJustification(2);
        this.slider.setBorder(this.etchedBorder);
        this.defaultValue = 0.0;
        this.defaultValueSet = false;
        this.internalValue = new DoubleValue(this.defaultValue);
        this.minimum = 0.0;
        this.maximum = 1.0;
        this.scale = 100000.0 * (this.maximum - this.minimum);
        this.setMaximum(this.maximum);
        this.internalValue.value = this.minimum + (double)this.slider.getValue() / this.scale;
        this.slider.addChangeListener(new MyChangeListener());
        this.slider.addMouseListener(new MyMouseListener());
        return this.slider;
    }

    private void setTheValue(double d) {
        this.internalValue.value = d;
        this.recalculate = false;
        this.slider.setValue((int)((this.internalValue.value - this.minimum) * this.scale));
        this.recalculate = true;
        if (this.format != null) {
            this.titledBorder.setTitle(this.format.format(this.internalValue.value));
            this.slider.repaint();
        }
    }

    public void reset() {
        if (this.defaultValueSet) {
            this.setTheValue(this.defaultValue);
            this.variableChanged(0, this.internalValue);
        }
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("variable");
            infoList.add("value");
            infoList.add("minimum");
            infoList.add("maximum");
            infoList.add("pressaction");
            infoList.add("dragaction");
            infoList.add("action");
            infoList.add("format");
            infoList.add("ticks");
            infoList.add("ticksFormat");
            infoList.add("closest");
            infoList.add("orientation");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("variable")) {
            return "int|double";
        }
        if (string.equals("value")) {
            return "int|double";
        }
        if (string.equals("minimum")) {
            return "int|double";
        }
        if (string.equals("maximum")) {
            return "int|double";
        }
        if (string.equals("pressaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("dragaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("format")) {
            return "Format|Object TRANSLATABLE";
        }
        if (string.equals("ticks")) {
            return "int    BASIC";
        }
        if (string.equals("ticksFormat")) {
            return "Format|Object BASIC TRANSLATABLE";
        }
        if (string.equals("closest")) {
            return "boolean BASIC";
        }
        if (string.equals("orientation")) {
            return "Orientation|int BASIC";
        }
        if (string.equals("enabled")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.internalValue.value == value.getDouble()) break;
                this.setTheValue(value.getDouble());
                break;
            }
            case 1: {
                this.defaultValueSet = true;
                this.defaultValue = value.getDouble();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 2: {
                this.setMinimum(value.getDouble());
                break;
            }
            case 3: {
                this.setMaximum(value.getDouble());
                break;
            }
            case 4: {
                this.removeAction(10, this.getProperty("pressaction"));
                this.addAction(10, value.getString());
                break;
            }
            case 5: {
                this.removeAction(1, this.getProperty("dragaction"));
                this.addAction(1, value.getString());
                break;
            }
            case 6: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            case 7: {
                if (!(value.getObject() instanceof DecimalFormat)) break;
                if (this.format == (DecimalFormat)value.getObject()) {
                    return;
                }
                this.format = (DecimalFormat)value.getObject();
                this.titledBorder.setTitle(this.format.format(this.internalValue.value));
                this.slider.setBorder(this.titledBorder);
                break;
            }
            case 8: {
                if (value.getInteger() == this.ticks) break;
                this.ticks = value.getInteger();
                this.setTicks();
                break;
            }
            case 9: {
                if (!(value.getObject() instanceof DecimalFormat)) break;
                if (this.ticksFormat == (DecimalFormat)value.getObject()) {
                    return;
                }
                this.ticksFormat = (DecimalFormat)value.getObject();
                this.slider.setPaintLabels(true);
                this.setTicks();
                break;
            }
            case 10: {
                this.slider.setSnapToTicks(value.getBoolean());
                break;
            }
            case 11: {
                if (this.slider.getOrientation() == value.getInteger()) break;
                this.slider.setOrientation(value.getInteger());
                break;
            }
            default: {
                super.setValue(n - 12, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.defaultValueSet = false;
                break;
            }
            case 2: {
                this.setMinimum(0.0);
                break;
            }
            case 3: {
                this.setMaximum(1.0);
                break;
            }
            case 4: {
                this.removeAction(10, this.getProperty("pressaction"));
                break;
            }
            case 5: {
                this.removeAction(1, this.getProperty("dragaction"));
                break;
            }
            case 6: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 7: {
                this.format = null;
                this.slider.setBorder(this.etchedBorder);
                break;
            }
            case 8: {
                this.ticks = 0;
                this.setTicks();
                break;
            }
            case 9: {
                this.ticksFormat = null;
                this.slider.setPaintLabels(false);
                this.setTicks();
                break;
            }
            case 10: {
                this.slider.setSnapToTicks(false);
                break;
            }
            case 11: {
                this.slider.setOrientation(0);
                break;
            }
            default: {
                super.setDefaultValue(n - 12);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return null;
            }
        }
        return super.getValue(n - 12);
    }

    private void setTicks() {
        if (this.ticks < 2) {
            this.slider.setPaintTicks(false);
            return;
        }
        int n = 100000 / (this.ticks - 1);
        this.slider.setMinorTickSpacing(n);
        this.slider.setMajorTickSpacing(2 * n);
        this.slider.setPaintTicks(true);
        if (this.ticksFormat != null) {
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            int n2 = 0;
            while (n2 <= 100000) {
                hashtable.put(new Integer(n2), new JLabel(this.ticksFormat.format(this.minimum + (double)n2 / this.scale)));
                n2 += 2 * n;
            }
            this.slider.setLabelTable(hashtable);
        }
    }

    private void setMinimum(double d) {
        if (d == this.minimum) {
            return;
        }
        this.minimum = d;
        if (this.minimum >= this.maximum) {
            this.maximum = this.minimum + 1.0;
        }
        this.scale = 100000.0 / (this.maximum - this.minimum);
        this.setTicks();
        this.setTheValue(this.internalValue.value);
    }

    private void setMaximum(double d) {
        if (d == this.maximum) {
            return;
        }
        this.maximum = d;
        if (this.minimum >= this.maximum) {
            this.minimum = this.maximum - 1.0;
        }
        this.scale = 100000.0 / (this.maximum - this.minimum);
        this.setTicks();
        this.setTheValue(this.internalValue.value);
    }

    private class MyChangeListener
    implements ChangeListener {
        private MyChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (ControlSlider.this.recalculate) {
                double d;
                ((ControlSlider)ControlSlider.this).internalValue.value = d = ControlSlider.this.minimum + (double)ControlSlider.this.slider.getValue() / ControlSlider.this.scale;
                if (ControlSlider.this.format != null) {
                    ControlSlider.this.titledBorder.setTitle(ControlSlider.this.format.format(((ControlSlider)ControlSlider.this).internalValue.value));
                    ControlSlider.this.slider.repaint();
                }
                ControlSlider.this.variableChanged(0, ControlSlider.this.internalValue);
            }
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ControlSlider.this.invokeActions(10);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ControlSlider.this.invokeActions(0);
        }
    }
}

