/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.Utils;
import org.opensourcephysics.ejs.control.swing.ConstantParser;
import org.opensourcephysics.ejs.control.swing.ControlContainer;
import org.opensourcephysics.ejs.control.swing.ControlWindow;
import org.opensourcephysics.ejs.control.value.Value;

public abstract class ControlSwingElement
extends ControlElement {
    public static final int NAME = 0;
    public static final int POSITION = 1;
    public static final int PARENT = 2;
    public static final int ENABLED = 3;
    public static final int VISIBLE = 4;
    public static final int SIZE = 5;
    public static final int FOREGROUND = 6;
    public static final int BACKGROUND = 7;
    public static final int FONT = 8;
    public static final int TOOLTIP = 9;
    public static final int ACTION_PRESS = 10;
    public static final int ACTION_ON = 20;
    public static final int ACTION_OFF = 21;
    private static ArrayList myInfoList = null;
    protected Component myVisual;
    private Color myDefaultBkgd = null;
    private Color myDefaultFrgd = null;
    private Font myDefaultFont = null;
    private Dimension mySize = null;

    public ControlSwingElement(Object object) {
        super(object);
        this.myVisual = this.createVisual(object);
        this.myObject = this.myVisual;
        this.myDefaultFrgd = this.myVisual.getForeground();
        this.myDefaultBkgd = this.myVisual.getBackground();
        this.myDefaultFont = this.myVisual.getFont();
        if (this.myVisual instanceof JComponent) {
            this.mySize = ((JComponent)this.myVisual).getPreferredSize();
        }
    }

    protected abstract Component createVisual(Object var1);

    public final Component getVisual() {
        return this.myVisual;
    }

    public Component getComponent() {
        return this.myVisual;
    }

    public ArrayList getPropertyList() {
        if (myInfoList == null) {
            myInfoList = new ArrayList();
            myInfoList.add("name");
            myInfoList.add("position");
            myInfoList.add("parent");
            myInfoList.add("enabled");
            myInfoList.add("visible");
            myInfoList.add("size");
            myInfoList.add("foreground");
            myInfoList.add("background");
            myInfoList.add("font");
            myInfoList.add("tooltip");
        }
        return myInfoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("name")) {
            return "String         CONSTANT HIDDEN";
        }
        if (string.equals("position")) {
            return "Position       CONSTANT PREVIOUS HIDDEN ";
        }
        if (string.equals("parent")) {
            return "ControlElement CONSTANT HIDDEN";
        }
        if (string.equals("enabled")) {
            return "boolean          BASIC HIDDEN";
        }
        if (string.equals("visible")) {
            return "boolean          BASIC HIDDEN";
        }
        if (string.equals("size")) {
            return "Dimension|Object BASIC";
        }
        if (string.equals("foreground")) {
            return "Color|Object     BASIC";
        }
        if (string.equals("background")) {
            return "Color|Object     BASIC";
        }
        if (string.equals("font")) {
            return "Font|Object      BASIC";
        }
        if (string.equals("tooltip")) {
            return "String           BASIC TRANSLATABLE";
        }
        return null;
    }

    public Value parseConstant(String string, String string2) {
        Value value;
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("Alignment") >= 0 && (value = ConstantParser.alignmentConstant(string2)) != null) {
            return value;
        }
        if (string.indexOf("Dimension") >= 0 && (value = ConstantParser.dimensionConstant(string2)) != null) {
            return value;
        }
        if (string.indexOf("Layout") >= 0 && (value = ConstantParser.layoutConstant(((ControlContainer)this).getContainer(), string2)) != null) {
            return value;
        }
        if (string.indexOf("Orientation") >= 0 && (value = ConstantParser.orientationConstant(string2)) != null) {
            return value;
        }
        if (string.indexOf("Placement") >= 0 && (value = ConstantParser.placementConstant(string2)) != null) {
            return value;
        }
        if (string.indexOf("Point") >= 0 && (value = ConstantParser.pointConstant(string2)) != null) {
            return value;
        }
        return super.parseConstant(string, string2);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                super.setValue(0, value);
                this.getComponent().setName(value.toString());
                break;
            }
            case 1: {
                ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
                if (controlElement != null && controlElement instanceof ControlContainer) {
                    ((ControlContainer)controlElement).remove(this);
                }
                this.myPropertiesTable.put("position", value.toString());
                if (controlElement == null || !(controlElement instanceof ControlContainer)) break;
                ((ControlContainer)controlElement).add(this);
                break;
            }
            case 2: {
                ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
                if (controlElement != null && controlElement instanceof ControlContainer) {
                    ((ControlContainer)controlElement).remove(this);
                }
                if ((controlElement = this.myGroup.getElement(value.toString())) == null) {
                    if (this instanceof ControlWindow) break;
                    System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + value + "> not found for " + this.toString());
                    break;
                }
                if (controlElement instanceof ControlContainer) {
                    ((ControlContainer)controlElement).add(this);
                    break;
                }
                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + value + "> is not a ControlContainer");
                break;
            }
            case 3: {
                this.getVisual().setEnabled(value.getBoolean());
                break;
            }
            case 4: {
                this.getVisual().setVisible(value.getBoolean());
                break;
            }
            case 5: {
                ControlElement controlElement;
                if (!(this.getComponent() instanceof JComponent)) break;
                Dimension dimension = (Dimension)value.getObject();
                if (dimension.width == this.mySize.width && dimension.height == this.mySize.height) {
                    return;
                }
                this.mySize = dimension;
                ((JComponent)this.getComponent()).setPreferredSize(this.mySize);
                if (this instanceof ControlContainer) {
                    ((ControlContainer)this).getContainer().validate();
                }
                if ((controlElement = this.myGroup.getElement(this.getProperty("parent"))) == null) break;
                ((ControlContainer)controlElement).adjustSize();
                break;
            }
            case 6: {
                if (!(value.getObject() instanceof Color)) break;
                this.getVisual().setForeground((Color)value.getObject());
                break;
            }
            case 7: {
                if (!(value.getObject() instanceof Color)) break;
                this.getVisual().setBackground((Color)value.getObject());
                break;
            }
            case 8: {
                if (!(value.getObject() instanceof Font)) break;
                this.getVisual().setFont((Font)value.getObject());
                break;
            }
            case 9: {
                if (!(this.getVisual() instanceof JComponent)) break;
                ((JComponent)this.getVisual()).setToolTipText(value.toString());
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                super.setDefaultValue(0);
                break;
            }
            case 1: {
                ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
                if (controlElement != null && controlElement instanceof ControlContainer) {
                    ((ControlContainer)controlElement).remove(this);
                }
                this.myPropertiesTable.remove("position");
                if (controlElement == null || !(controlElement instanceof ControlContainer)) break;
                ((ControlContainer)controlElement).add(this);
                break;
            }
            case 2: {
                ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
                if (controlElement == null || !(controlElement instanceof ControlContainer)) break;
                ((ControlContainer)controlElement).remove(this);
                break;
            }
            case 3: {
                this.getVisual().setEnabled(true);
                break;
            }
            case 4: {
                this.getVisual().setVisible(true);
                break;
            }
            case 5: {
                ControlElement controlElement;
                if (!(this.getComponent() instanceof JComponent)) break;
                ((JComponent)this.getComponent()).setPreferredSize(null);
                if (this instanceof ControlContainer) {
                    ((ControlContainer)this).getContainer().validate();
                }
                if ((controlElement = this.myGroup.getElement(this.getProperty("parent"))) == null) break;
                ((ControlContainer)controlElement).adjustSize();
                break;
            }
            case 6: {
                this.getVisual().setForeground(this.myDefaultFrgd);
                break;
            }
            case 7: {
                this.getVisual().setBackground(this.myDefaultBkgd);
                break;
            }
            case 8: {
                this.getVisual().setFont(this.myDefaultFont);
                break;
            }
            case 9: {
                if (!(this.getComponent() instanceof JComponent)) break;
                ((JComponent)this.getVisual()).setToolTipText(null);
                break;
            }
        }
    }

    public Value getValue(int n) {
        return null;
    }

    protected ImageIcon getIcon(String string) {
        ImageIcon imageIcon = this.getProperty("_ejs_codebase") != null ? Utils.icon(this.getProperty("_ejs_codebase"), string) : (this.getSimulation() != null && this.getSimulation().getCodebase() != null ? Utils.icon(this.getSimulation().getCodebase().toString(), string) : Utils.icon(null, string));
        return imageIcon;
    }
}

