/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.opensourcephysics.ejs.control.NeedsUpdate;
import org.opensourcephysics.ejs.control.swing.ControlContainer;
import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;

public abstract class ControlWindow
extends ControlContainer
implements NeedsUpdate {
    public static final int NAME = 3;
    public static final int VISIBLE = 7;
    private static final int SIZE = 8;
    protected BooleanValue internalValue;
    private LayoutManager myLayout = null;
    private Point myLocation = null;
    private Dimension mySize = null;
    protected boolean waitForReset = false;
    protected boolean startingup = true;
    protected boolean shouldShow = true;
    private static ArrayList infoList = null;

    public ControlWindow(Object object) {
        super(object);
    }

    public void dispose() {
        ((Window)this.getComponent()).dispose();
    }

    public void show() {
        Window window;
        if (this.startingup) {
            this.shouldShow = true;
            if (this.waitForReset) {
                return;
            }
        }
        if (!(window = (Window)this.getComponent()).isShowing()) {
            window.setVisible(true);
        }
    }

    public void hide() {
        Window window;
        if (this.startingup) {
            this.shouldShow = false;
            if (this.waitForReset) {
                return;
            }
        }
        if ((window = (Window)this.getComponent()).isShowing()) {
            window.setVisible(false);
        }
    }

    public void destroy() {
        this.dispose();
        super.destroy();
    }

    public void setWaitForReset(boolean bl) {
        this.waitForReset = bl;
        if (this.waitForReset) {
            ((Window)this.getComponent()).setVisible(false);
        }
    }

    public void reset() {
        this.startingup = false;
        if (this.shouldShow) {
            this.show();
        } else {
            this.hide();
        }
        super.reset();
    }

    public void update() {
        this.startingup = false;
    }

    public void adjustSize() {
        String string = this.getProperty("size");
        ((Window)this.getComponent()).validate();
        if (string != null && string.trim().toLowerCase().equals("pack")) {
            ((Window)this.getComponent()).pack();
        } else {
            super.adjustSize();
        }
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("layout");
            infoList.add("location");
            infoList.add("waitForReset");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("location")) {
            return "Point|Object";
        }
        if (string.equals("layout")) {
            return "Layout|Object";
        }
        if (string.equals("waitForReset")) {
            return "boolean HIDDEN";
        }
        if (string.equals("tooltip")) {
            return "String HIDDEN";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (!(value.getObject() instanceof LayoutManager)) break;
                LayoutManager layoutManager = (LayoutManager)value.getObject();
                if (layoutManager != this.myLayout) {
                    this.myLayout = layoutManager;
                    this.getContainer().setLayout(this.myLayout);
                }
                ((Container)this.getComponent()).validate();
                break;
            }
            case 1: {
                if (!(value.getObject() instanceof Point)) break;
                Point point = (Point)value.getObject();
                if (point.equals(this.myLocation)) {
                    return;
                }
                this.myLocation = point;
                this.getComponent().setLocation(this.myLocation);
                break;
            }
            case 2: {
                this.setWaitForReset(value.getBoolean());
                break;
            }
            case 7: {
                this.internalValue.value = value.getBoolean();
                if (this.internalValue.value) {
                    this.show();
                    break;
                }
                this.hide();
                break;
            }
            case 8: {
                Dimension dimension = null;
                if (value instanceof StringValue && "pack".equals(value.getString())) {
                    ((Window)this.getComponent()).pack();
                    dimension = this.getComponent().getSize();
                } else if (value.getObject() instanceof Dimension) {
                    dimension = (Dimension)value.getObject();
                    if (dimension.equals(this.mySize)) {
                        return;
                    }
                    this.mySize = dimension;
                    ((JComponent)this.getContainer()).setPreferredSize(this.mySize);
                    ((Container)this.getComponent()).validate();
                    ((Window)this.getComponent()).pack();
                } else {
                    return;
                }
                String string = this.getProperty("location");
                if (string == null || !string.trim().toLowerCase().equals("center")) break;
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                this.getComponent().setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
                break;
            }
            default: {
                super.setValue(n - 3, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.myLayout = new BorderLayout();
                this.getContainer().setLayout(this.myLayout);
                ((Container)this.getComponent()).validate();
                break;
            }
            case 1: {
                this.myLocation = new Point(0, 0);
                this.getComponent().setLocation(this.myLocation);
                break;
            }
            case 2: {
                this.setWaitForReset(false);
                break;
            }
            case 7: {
                this.internalValue.value = true;
                this.show();
                break;
            }
            case 8: {
                ((Window)this.getComponent()).pack();
                Dimension dimension = this.getComponent().getSize();
                String string = this.getProperty("location");
                if (string == null || !string.trim().toLowerCase().equals("center")) break;
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                this.getComponent().setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
                break;
            }
            default: {
                super.setDefaultValue(n - 3);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: {
                return null;
            }
        }
        return super.getValue(n - 3);
    }
}

